﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;

namespace System.Reactive
{
	internal sealed class Lookup<K, E> : ILookup<K, E>, IEnumerable<IGrouping<K, E>>, IEnumerable
	{
		public Lookup(IEqualityComparer<K> comparer)
		{
			this._dictionary = new Dictionary<K, List<E>>(comparer);
		}

		public void Add(K key, E element)
		{
			List<E> list;
			if (!this._dictionary.TryGetValue(key, out list))
			{
				list = (this._dictionary[key] = new List<E>());
			}
			list.Add(element);
		}

		public bool Contains(K key)
		{
			return this._dictionary.ContainsKey(key);
		}

		public int Count
		{
			get
			{
				return this._dictionary.Count;
			}
		}

		public IEnumerable<E> this[K key]
		{
			get
			{
				List<E> list;
				if (!this._dictionary.TryGetValue(key, out list))
				{
					return Enumerable.Empty<E>();
				}
				return Lookup<K, E>.Hide(list);
			}
		}

		private static IEnumerable<E> Hide(List<E> elements)
		{
			return elements.Skip(0);
		}

		public IEnumerator<IGrouping<K, E>> GetEnumerator()
		{
			Lookup<K, E>.<GetEnumerator>d__9 <GetEnumerator>d__ = new Lookup<K, E>.<GetEnumerator>d__9(0);
			<GetEnumerator>d__.<>4__this = this;
			return <GetEnumerator>d__;
		}

		IEnumerator IEnumerable.GetEnumerator()
		{
			return this.GetEnumerator();
		}

		private readonly Dictionary<K, List<E>> _dictionary;

		private sealed class Grouping : IGrouping<K, E>, IEnumerable<E>, IEnumerable
		{
			public Grouping(KeyValuePair<K, List<E>> keyValuePair)
			{
				this._keyValuePair = keyValuePair;
			}

			public K Key
			{
				get
				{
					return this._keyValuePair.Key;
				}
			}

			public IEnumerator<E> GetEnumerator()
			{
				return this._keyValuePair.Value.GetEnumerator();
			}

			IEnumerator IEnumerable.GetEnumerator()
			{
				return this.GetEnumerator();
			}

			private readonly KeyValuePair<K, List<E>> _keyValuePair;
		}
	}
}
