﻿using System;
using System.Reactive.PlatformServices;

namespace System.Reactive.Linq
{
	internal static class QueryServices
	{
		public static T GetQueryImpl<T>(T defaultInstance)
		{
			return QueryServices.Services.Extend<T>(defaultInstance);
		}

		private static IQueryServices Initialize()
		{
			return PlatformEnlightenmentProvider.Current.GetService<IQueryServices>(Array.Empty<object>()) ?? new DefaultQueryServices();
		}

		private static readonly IQueryServices Services = QueryServices.Initialize();
	}
}
