﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reactive.Concurrency;
using System.Reactive.Disposables;
using System.Reactive.Joins;
using System.Reactive.Linq.ObservableImpl;
using System.Reactive.Subjects;
using System.Reactive.Threading.Tasks;
using System.Reflection;
using System.Runtime.CompilerServices;
using System.Threading;
using System.Threading.Tasks;

namespace System.Reactive.Linq
{
	internal class QueryLanguage : IQueryLanguage
	{
		public virtual IObservable<T> Aggregate<TSource, T>(IObservable<TSource> source, T seed, Func<T, TSource, T> accumulator)
		{
			return new Aggregate<TSource, T>(source, seed, accumulator);
		}

		public virtual IObservable<TResult> Aggregate<TSource, T, TResult>(IObservable<TSource> source, T seed, Func<T, TSource, T> accumulator, Func<T, TResult> resultSelector)
		{
			return new Aggregate<TSource, T, TResult>(source, seed, accumulator, resultSelector);
		}

		public virtual IObservable<TSource> Aggregate<TSource>(IObservable<TSource> source, Func<TSource, TSource, TSource> accumulator)
		{
			return new Aggregate<TSource>(source, accumulator);
		}

		public virtual IObservable<double> Average<TSource>(IObservable<TSource> source, Func<TSource, double> selector)
		{
			return this.Average(this.Select<TSource, double>(source, selector));
		}

		public virtual IObservable<float> Average<TSource>(IObservable<TSource> source, Func<TSource, float> selector)
		{
			return this.Average(this.Select<TSource, float>(source, selector));
		}

		public virtual IObservable<decimal> Average<TSource>(IObservable<TSource> source, Func<TSource, decimal> selector)
		{
			return this.Average(this.Select<TSource, decimal>(source, selector));
		}

		public virtual IObservable<double> Average<TSource>(IObservable<TSource> source, Func<TSource, int> selector)
		{
			return this.Average(this.Select<TSource, int>(source, selector));
		}

		public virtual IObservable<double> Average<TSource>(IObservable<TSource> source, Func<TSource, long> selector)
		{
			return this.Average(this.Select<TSource, long>(source, selector));
		}

		public virtual IObservable<double?> Average<TSource>(IObservable<TSource> source, Func<TSource, double?> selector)
		{
			return this.Average(this.Select<TSource, double?>(source, selector));
		}

		public virtual IObservable<float?> Average<TSource>(IObservable<TSource> source, Func<TSource, float?> selector)
		{
			return this.Average(this.Select<TSource, float?>(source, selector));
		}

		public virtual IObservable<decimal?> Average<TSource>(IObservable<TSource> source, Func<TSource, decimal?> selector)
		{
			return this.Average(this.Select<TSource, decimal?>(source, selector));
		}

		public virtual IObservable<double?> Average<TSource>(IObservable<TSource> source, Func<TSource, int?> selector)
		{
			return this.Average(this.Select<TSource, int?>(source, selector));
		}

		public virtual IObservable<double?> Average<TSource>(IObservable<TSource> source, Func<TSource, long?> selector)
		{
			return this.Average(this.Select<TSource, long?>(source, selector));
		}

		public virtual IObservable<bool> All<TSource>(IObservable<TSource> source, Func<TSource, bool> predicate)
		{
			return new All<TSource>(source, predicate);
		}

		public virtual IObservable<bool> Any<TSource>(IObservable<TSource> source)
		{
			return new Any<TSource>.Count(source);
		}

		public virtual IObservable<bool> Any<TSource>(IObservable<TSource> source, Func<TSource, bool> predicate)
		{
			return new Any<TSource>.Predicate(source, predicate);
		}

		public virtual IObservable<double> Average(IObservable<double> source)
		{
			return new AverageDouble(source);
		}

		public virtual IObservable<float> Average(IObservable<float> source)
		{
			return new AverageSingle(source);
		}

		public virtual IObservable<decimal> Average(IObservable<decimal> source)
		{
			return new AverageDecimal(source);
		}

		public virtual IObservable<double> Average(IObservable<int> source)
		{
			return new AverageInt32(source);
		}

		public virtual IObservable<double> Average(IObservable<long> source)
		{
			return new AverageInt64(source);
		}

		public virtual IObservable<double?> Average(IObservable<double?> source)
		{
			return new AverageDoubleNullable(source);
		}

		public virtual IObservable<float?> Average(IObservable<float?> source)
		{
			return new AverageSingleNullable(source);
		}

		public virtual IObservable<decimal?> Average(IObservable<decimal?> source)
		{
			return new AverageDecimalNullable(source);
		}

		public virtual IObservable<double?> Average(IObservable<int?> source)
		{
			return new Class7(source);
		}

		public virtual IObservable<double?> Average(IObservable<long?> source)
		{
			return new Class8(source);
		}

		public virtual IObservable<bool> Contains<TSource>(IObservable<TSource> source, TSource value)
		{
			return new Contains<TSource>(source, value, EqualityComparer<TSource>.Default);
		}

		public virtual IObservable<bool> Contains<TSource>(IObservable<TSource> source, TSource value, IEqualityComparer<TSource> comparer)
		{
			return new Contains<TSource>(source, value, comparer);
		}

		public virtual IObservable<int> Count<TSource>(IObservable<TSource> source)
		{
			return new Count<TSource>.All(source);
		}

		public virtual IObservable<int> Count<TSource>(IObservable<TSource> source, Func<TSource, bool> predicate)
		{
			return new Count<TSource>.Predicate(source, predicate);
		}

		public virtual IObservable<TSource> ElementAt<TSource>(IObservable<TSource> source, int index)
		{
			return new ElementAt<TSource>(source, index);
		}

		public virtual IObservable<TSource> ElementAtOrDefault<TSource>(IObservable<TSource> source, int index)
		{
			return new ElementAtOrDefault<TSource>(source, index);
		}

		public virtual IObservable<TSource> FirstAsync<TSource>(IObservable<TSource> source)
		{
			return new FirstAsync<TSource>.Sequence(source);
		}

		public virtual IObservable<TSource> FirstAsync<TSource>(IObservable<TSource> source, Func<TSource, bool> predicate)
		{
			return new FirstAsync<TSource>.Predicate(source, predicate);
		}

		public virtual IObservable<TSource> FirstOrDefaultAsync<TSource>(IObservable<TSource> source)
		{
			return new FirstOrDefaultAsync<TSource>.Sequence(source);
		}

		public virtual IObservable<TSource> FirstOrDefaultAsync<TSource>(IObservable<TSource> source, Func<TSource, bool> predicate)
		{
			return new FirstOrDefaultAsync<TSource>.Predicate(source, predicate);
		}

		public virtual IObservable<bool> IsEmpty<TSource>(IObservable<TSource> source)
		{
			return new IsEmpty<TSource>(source);
		}

		public virtual IObservable<TSource> LastAsync<TSource>(IObservable<TSource> source)
		{
			return new LastAsync<TSource>.Sequence(source);
		}

		public virtual IObservable<TSource> LastAsync<TSource>(IObservable<TSource> source, Func<TSource, bool> predicate)
		{
			return new LastAsync<TSource>.Predicate(source, predicate);
		}

		public virtual IObservable<TSource> LastOrDefaultAsync<TSource>(IObservable<TSource> source)
		{
			return new LastOrDefaultAsync<TSource>.Sequence(source);
		}

		public virtual IObservable<TSource> LastOrDefaultAsync<TSource>(IObservable<TSource> source, Func<TSource, bool> predicate)
		{
			return new LastOrDefaultAsync<TSource>.Predicate(source, predicate);
		}

		public virtual IObservable<long> LongCount<TSource>(IObservable<TSource> source)
		{
			return new LongCount<TSource>.All(source);
		}

		public virtual IObservable<long> LongCount<TSource>(IObservable<TSource> source, Func<TSource, bool> predicate)
		{
			return new LongCount<TSource>.Predicate(source, predicate);
		}

		public virtual IObservable<TSource> Max<TSource>(IObservable<TSource> source)
		{
			return new Max<TSource>(source, Comparer<TSource>.Default);
		}

		public virtual IObservable<TSource> Max<TSource>(IObservable<TSource> source, IComparer<TSource> comparer)
		{
			return new Max<TSource>(source, comparer);
		}

		public virtual IObservable<double> Max(IObservable<double> source)
		{
			return new MaxDouble(source);
		}

		public virtual IObservable<float> Max(IObservable<float> source)
		{
			return new MaxSingle(source);
		}

		public virtual IObservable<decimal> Max(IObservable<decimal> source)
		{
			return new MaxDecimal(source);
		}

		public virtual IObservable<int> Max(IObservable<int> source)
		{
			return new MaxInt32(source);
		}

		public virtual IObservable<long> Max(IObservable<long> source)
		{
			return new MaxInt64(source);
		}

		public virtual IObservable<double?> Max(IObservable<double?> source)
		{
			return new MaxDoubleNullable(source);
		}

		public virtual IObservable<float?> Max(IObservable<float?> source)
		{
			return new MaxSingleNullable(source);
		}

		public virtual IObservable<decimal?> Max(IObservable<decimal?> source)
		{
			return new MaxDecimalNullable(source);
		}

		public virtual IObservable<int?> Max(IObservable<int?> source)
		{
			return new MaxInt32Nullable(source);
		}

		public virtual IObservable<long?> Max(IObservable<long?> source)
		{
			return new MaxInt64Nullable(source);
		}

		public virtual IObservable<TResult> Max<TSource, TResult>(IObservable<TSource> source, Func<TSource, TResult> selector)
		{
			return this.Max<TResult>(this.Select<TSource, TResult>(source, selector));
		}

		public virtual IObservable<TResult> Max<TSource, TResult>(IObservable<TSource> source, Func<TSource, TResult> selector, IComparer<TResult> comparer)
		{
			return this.Max<TResult>(this.Select<TSource, TResult>(source, selector), comparer);
		}

		public virtual IObservable<double> Max<TSource>(IObservable<TSource> source, Func<TSource, double> selector)
		{
			return this.Max(this.Select<TSource, double>(source, selector));
		}

		public virtual IObservable<float> Max<TSource>(IObservable<TSource> source, Func<TSource, float> selector)
		{
			return this.Max(this.Select<TSource, float>(source, selector));
		}

		public virtual IObservable<decimal> Max<TSource>(IObservable<TSource> source, Func<TSource, decimal> selector)
		{
			return this.Max(this.Select<TSource, decimal>(source, selector));
		}

		public virtual IObservable<int> Max<TSource>(IObservable<TSource> source, Func<TSource, int> selector)
		{
			return this.Max(this.Select<TSource, int>(source, selector));
		}

		public virtual IObservable<long> Max<TSource>(IObservable<TSource> source, Func<TSource, long> selector)
		{
			return this.Max(this.Select<TSource, long>(source, selector));
		}

		public virtual IObservable<double?> Max<TSource>(IObservable<TSource> source, Func<TSource, double?> selector)
		{
			return this.Max(this.Select<TSource, double?>(source, selector));
		}

		public virtual IObservable<float?> Max<TSource>(IObservable<TSource> source, Func<TSource, float?> selector)
		{
			return this.Max(this.Select<TSource, float?>(source, selector));
		}

		public virtual IObservable<decimal?> Max<TSource>(IObservable<TSource> source, Func<TSource, decimal?> selector)
		{
			return this.Max(this.Select<TSource, decimal?>(source, selector));
		}

		public virtual IObservable<int?> Max<TSource>(IObservable<TSource> source, Func<TSource, int?> selector)
		{
			return this.Max(this.Select<TSource, int?>(source, selector));
		}

		public virtual IObservable<long?> Max<TSource>(IObservable<TSource> source, Func<TSource, long?> selector)
		{
			return this.Max(this.Select<TSource, long?>(source, selector));
		}

		public virtual IObservable<IList<TSource>> MaxBy<TSource, TKey>(IObservable<TSource> source, Func<TSource, TKey> keySelector)
		{
			return new MaxBy<TSource, TKey>(source, keySelector, Comparer<TKey>.Default);
		}

		public virtual IObservable<IList<TSource>> MaxBy<TSource, TKey>(IObservable<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer)
		{
			return new MaxBy<TSource, TKey>(source, keySelector, comparer);
		}

		public virtual IObservable<TSource> Min<TSource>(IObservable<TSource> source)
		{
			return new Min<TSource>(source, Comparer<TSource>.Default);
		}

		public virtual IObservable<TSource> Min<TSource>(IObservable<TSource> source, IComparer<TSource> comparer)
		{
			return new Min<TSource>(source, comparer);
		}

		public virtual IObservable<double> Min(IObservable<double> source)
		{
			return new MinDouble(source);
		}

		public virtual IObservable<float> Min(IObservable<float> source)
		{
			return new MinSingle(source);
		}

		public virtual IObservable<decimal> Min(IObservable<decimal> source)
		{
			return new MinDecimal(source);
		}

		public virtual IObservable<int> Min(IObservable<int> source)
		{
			return new MinInt32(source);
		}

		public virtual IObservable<long> Min(IObservable<long> source)
		{
			return new MinInt64(source);
		}

		public virtual IObservable<double?> Min(IObservable<double?> source)
		{
			return new MinDoubleNullable(source);
		}

		public virtual IObservable<float?> Min(IObservable<float?> source)
		{
			return new MinSingleNullable(source);
		}

		public virtual IObservable<decimal?> Min(IObservable<decimal?> source)
		{
			return new MinDecimalNullable(source);
		}

		public virtual IObservable<int?> Min(IObservable<int?> source)
		{
			return new MinInt32Nullable(source);
		}

		public virtual IObservable<long?> Min(IObservable<long?> source)
		{
			return new MinInt64Nullable(source);
		}

		public virtual IObservable<TResult> Min<TSource, TResult>(IObservable<TSource> source, Func<TSource, TResult> selector)
		{
			return this.Min<TResult>(this.Select<TSource, TResult>(source, selector));
		}

		public virtual IObservable<TResult> Min<TSource, TResult>(IObservable<TSource> source, Func<TSource, TResult> selector, IComparer<TResult> comparer)
		{
			return this.Min<TResult>(this.Select<TSource, TResult>(source, selector), comparer);
		}

		public virtual IObservable<double> Min<TSource>(IObservable<TSource> source, Func<TSource, double> selector)
		{
			return this.Min(this.Select<TSource, double>(source, selector));
		}

		public virtual IObservable<float> Min<TSource>(IObservable<TSource> source, Func<TSource, float> selector)
		{
			return this.Min(this.Select<TSource, float>(source, selector));
		}

		public virtual IObservable<decimal> Min<TSource>(IObservable<TSource> source, Func<TSource, decimal> selector)
		{
			return this.Min(this.Select<TSource, decimal>(source, selector));
		}

		public virtual IObservable<int> Min<TSource>(IObservable<TSource> source, Func<TSource, int> selector)
		{
			return this.Min(this.Select<TSource, int>(source, selector));
		}

		public virtual IObservable<long> Min<TSource>(IObservable<TSource> source, Func<TSource, long> selector)
		{
			return this.Min(this.Select<TSource, long>(source, selector));
		}

		public virtual IObservable<double?> Min<TSource>(IObservable<TSource> source, Func<TSource, double?> selector)
		{
			return this.Min(this.Select<TSource, double?>(source, selector));
		}

		public virtual IObservable<float?> Min<TSource>(IObservable<TSource> source, Func<TSource, float?> selector)
		{
			return this.Min(this.Select<TSource, float?>(source, selector));
		}

		public virtual IObservable<decimal?> Min<TSource>(IObservable<TSource> source, Func<TSource, decimal?> selector)
		{
			return this.Min(this.Select<TSource, decimal?>(source, selector));
		}

		public virtual IObservable<int?> Min<TSource>(IObservable<TSource> source, Func<TSource, int?> selector)
		{
			return this.Min(this.Select<TSource, int?>(source, selector));
		}

		public virtual IObservable<long?> Min<TSource>(IObservable<TSource> source, Func<TSource, long?> selector)
		{
			return this.Min(this.Select<TSource, long?>(source, selector));
		}

		public virtual IObservable<IList<TSource>> MinBy<TSource, TKey>(IObservable<TSource> source, Func<TSource, TKey> keySelector)
		{
			return new MinBy<TSource, TKey>(source, keySelector, Comparer<TKey>.Default);
		}

		public virtual IObservable<IList<TSource>> MinBy<TSource, TKey>(IObservable<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer)
		{
			return new MinBy<TSource, TKey>(source, keySelector, comparer);
		}

		public virtual IObservable<bool> SequenceEqual<TSource>(IObservable<TSource> first, IObservable<TSource> second)
		{
			return new SequenceEqual<TSource>.Observable(first, second, EqualityComparer<TSource>.Default);
		}

		public virtual IObservable<bool> SequenceEqual<TSource>(IObservable<TSource> first, IObservable<TSource> second, IEqualityComparer<TSource> comparer)
		{
			return new SequenceEqual<TSource>.Observable(first, second, comparer);
		}

		public virtual IObservable<bool> SequenceEqual<TSource>(IObservable<TSource> first, IEnumerable<TSource> second)
		{
			return new SequenceEqual<TSource>.Enumerable(first, second, EqualityComparer<TSource>.Default);
		}

		public virtual IObservable<bool> SequenceEqual<TSource>(IObservable<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer)
		{
			return new SequenceEqual<TSource>.Enumerable(first, second, comparer);
		}

		public virtual IObservable<TSource> SingleAsync<TSource>(IObservable<TSource> source)
		{
			return new SingleAsync<TSource>.Sequence(source);
		}

		public virtual IObservable<TSource> SingleAsync<TSource>(IObservable<TSource> source, Func<TSource, bool> predicate)
		{
			return new SingleAsync<TSource>.Predicate(source, predicate);
		}

		public virtual IObservable<TSource> SingleOrDefaultAsync<TSource>(IObservable<TSource> source)
		{
			return new SingleOrDefaultAsync<TSource>.Sequence(source);
		}

		public virtual IObservable<TSource> SingleOrDefaultAsync<TSource>(IObservable<TSource> source, Func<TSource, bool> predicate)
		{
			return new SingleOrDefaultAsync<TSource>.Predicate(source, predicate);
		}

		public virtual IObservable<double> Sum(IObservable<double> source)
		{
			return new SumDouble(source);
		}

		public virtual IObservable<float> Sum(IObservable<float> source)
		{
			return new SumSingle(source);
		}

		public virtual IObservable<decimal> Sum(IObservable<decimal> source)
		{
			return new SumDecimal(source);
		}

		public virtual IObservable<int> Sum(IObservable<int> source)
		{
			return new SumInt32(source);
		}

		public virtual IObservable<long> Sum(IObservable<long> source)
		{
			return new SumInt64(source);
		}

		public virtual IObservable<double?> Sum(IObservable<double?> source)
		{
			return new SumDoubleNullable(source);
		}

		public virtual IObservable<float?> Sum(IObservable<float?> source)
		{
			return new SumSingleNullable(source);
		}

		public virtual IObservable<decimal?> Sum(IObservable<decimal?> source)
		{
			return new SumDecimalNullable(source);
		}

		public virtual IObservable<int?> Sum(IObservable<int?> source)
		{
			return new SumInt32Nullable(source);
		}

		public virtual IObservable<long?> Sum(IObservable<long?> source)
		{
			return new SumInt64Nullable(source);
		}

		public virtual IObservable<double> Sum<TSource>(IObservable<TSource> source, Func<TSource, double> selector)
		{
			return this.Sum(this.Select<TSource, double>(source, selector));
		}

		public virtual IObservable<float> Sum<TSource>(IObservable<TSource> source, Func<TSource, float> selector)
		{
			return this.Sum(this.Select<TSource, float>(source, selector));
		}

		public virtual IObservable<decimal> Sum<TSource>(IObservable<TSource> source, Func<TSource, decimal> selector)
		{
			return this.Sum(this.Select<TSource, decimal>(source, selector));
		}

		public virtual IObservable<int> Sum<TSource>(IObservable<TSource> source, Func<TSource, int> selector)
		{
			return this.Sum(this.Select<TSource, int>(source, selector));
		}

		public virtual IObservable<long> Sum<TSource>(IObservable<TSource> source, Func<TSource, long> selector)
		{
			return this.Sum(this.Select<TSource, long>(source, selector));
		}

		public virtual IObservable<double?> Sum<TSource>(IObservable<TSource> source, Func<TSource, double?> selector)
		{
			return this.Sum(this.Select<TSource, double?>(source, selector));
		}

		public virtual IObservable<float?> Sum<TSource>(IObservable<TSource> source, Func<TSource, float?> selector)
		{
			return this.Sum(this.Select<TSource, float?>(source, selector));
		}

		public virtual IObservable<decimal?> Sum<TSource>(IObservable<TSource> source, Func<TSource, decimal?> selector)
		{
			return this.Sum(this.Select<TSource, decimal?>(source, selector));
		}

		public virtual IObservable<int?> Sum<TSource>(IObservable<TSource> source, Func<TSource, int?> selector)
		{
			return this.Sum(this.Select<TSource, int?>(source, selector));
		}

		public virtual IObservable<long?> Sum<TSource>(IObservable<TSource> source, Func<TSource, long?> selector)
		{
			return this.Sum(this.Select<TSource, long?>(source, selector));
		}

		public virtual IObservable<TSource[]> ToArray<TSource>(IObservable<TSource> source)
		{
			return new ToArray<TSource>(source);
		}

		public virtual IObservable<IDictionary<TKey, TElement>> ToDictionary<TSource, TKey, TElement>(IObservable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, IEqualityComparer<TKey> comparer)
		{
			return new ToDictionary<TSource, TKey, TElement>(source, keySelector, elementSelector, comparer);
		}

		public virtual IObservable<IDictionary<TKey, TElement>> ToDictionary<TSource, TKey, TElement>(IObservable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector)
		{
			return new ToDictionary<TSource, TKey, TElement>(source, keySelector, elementSelector, EqualityComparer<TKey>.Default);
		}

		public virtual IObservable<IDictionary<TKey, TSource>> ToDictionary<TSource, TKey>(IObservable<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer)
		{
			return new ToDictionary<TSource, TKey, TSource>(source, keySelector, (TSource x) => x, comparer);
		}

		public virtual IObservable<IDictionary<TKey, TSource>> ToDictionary<TSource, TKey>(IObservable<TSource> source, Func<TSource, TKey> keySelector)
		{
			return new ToDictionary<TSource, TKey, TSource>(source, keySelector, (TSource x) => x, EqualityComparer<TKey>.Default);
		}

		public virtual IObservable<IList<TSource>> ToList<TSource>(IObservable<TSource> source)
		{
			return new ToList<TSource>(source);
		}

		public virtual IObservable<ILookup<TKey, TElement>> ToLookup<TSource, TKey, TElement>(IObservable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, IEqualityComparer<TKey> comparer)
		{
			return new ToLookup<TSource, TKey, TElement>(source, keySelector, elementSelector, comparer);
		}

		public virtual IObservable<ILookup<TKey, TSource>> ToLookup<TSource, TKey>(IObservable<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer)
		{
			return new ToLookup<TSource, TKey, TSource>(source, keySelector, (TSource x) => x, comparer);
		}

		public virtual IObservable<ILookup<TKey, TElement>> ToLookup<TSource, TKey, TElement>(IObservable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector)
		{
			return new ToLookup<TSource, TKey, TElement>(source, keySelector, elementSelector, EqualityComparer<TKey>.Default);
		}

		public virtual IObservable<ILookup<TKey, TSource>> ToLookup<TSource, TKey>(IObservable<TSource> source, Func<TSource, TKey> keySelector)
		{
			return new ToLookup<TSource, TKey, TSource>(source, keySelector, (TSource x) => x, EqualityComparer<TKey>.Default);
		}

		public virtual Func<IObservable<TResult>> FromAsyncPattern<TResult>(Func<AsyncCallback, object, IAsyncResult> begin, Func<IAsyncResult, TResult> end)
		{
			return delegate
			{
				AsyncSubject<TResult> subject = new AsyncSubject<TResult>();
				IObservable<TResult> observable;
				try
				{
					begin(delegate(IAsyncResult iar)
					{
						TResult tresult;
						try
						{
							tresult = end(iar);
						}
						catch (Exception ex2)
						{
							subject.OnError(ex2);
							return;
						}
						subject.OnNext(tresult);
						subject.OnCompleted();
					}, null);
					goto IL_0042;
				}
				catch (Exception ex)
				{
					observable = Observable.Throw<TResult>(ex, SchedulerDefaults.AsyncConversions);
				}
				return observable;
				IL_0042:
				return subject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, IObservable<TResult>> FromAsyncPattern<T1, TResult>(Func<T1, AsyncCallback, object, IAsyncResult> begin, Func<IAsyncResult, TResult> end)
		{
			return delegate(T1 x)
			{
				AsyncSubject<TResult> subject = new AsyncSubject<TResult>();
				IObservable<TResult> observable;
				try
				{
					begin(x, delegate(IAsyncResult iar)
					{
						TResult tresult;
						try
						{
							tresult = end(iar);
						}
						catch (Exception ex2)
						{
							subject.OnError(ex2);
							return;
						}
						subject.OnNext(tresult);
						subject.OnCompleted();
					}, null);
					goto IL_0043;
				}
				catch (Exception ex)
				{
					observable = Observable.Throw<TResult>(ex, SchedulerDefaults.AsyncConversions);
				}
				return observable;
				IL_0043:
				return subject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, IObservable<TResult>> FromAsyncPattern<T1, T2, TResult>(Func<T1, T2, AsyncCallback, object, IAsyncResult> begin, Func<IAsyncResult, TResult> end)
		{
			return delegate(T1 x, T2 y)
			{
				AsyncSubject<TResult> subject = new AsyncSubject<TResult>();
				IObservable<TResult> observable;
				try
				{
					begin(x, y, delegate(IAsyncResult iar)
					{
						TResult tresult;
						try
						{
							tresult = end(iar);
						}
						catch (Exception ex2)
						{
							subject.OnError(ex2);
							return;
						}
						subject.OnNext(tresult);
						subject.OnCompleted();
					}, null);
					goto IL_0044;
				}
				catch (Exception ex)
				{
					observable = Observable.Throw<TResult>(ex, SchedulerDefaults.AsyncConversions);
				}
				return observable;
				IL_0044:
				return subject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, IObservable<TResult>> FromAsyncPattern<T1, T2, T3, TResult>(Func<T1, T2, T3, AsyncCallback, object, IAsyncResult> begin, Func<IAsyncResult, TResult> end)
		{
			return delegate(T1 x, T2 y, T3 z)
			{
				AsyncSubject<TResult> subject = new AsyncSubject<TResult>();
				IObservable<TResult> observable;
				try
				{
					begin(x, y, z, delegate(IAsyncResult iar)
					{
						TResult tresult;
						try
						{
							tresult = end(iar);
						}
						catch (Exception ex2)
						{
							subject.OnError(ex2);
							return;
						}
						subject.OnNext(tresult);
						subject.OnCompleted();
					}, null);
					goto IL_0045;
				}
				catch (Exception ex)
				{
					observable = Observable.Throw<TResult>(ex, SchedulerDefaults.AsyncConversions);
				}
				return observable;
				IL_0045:
				return subject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, IObservable<TResult>> FromAsyncPattern<T1, T2, T3, T4, TResult>(Func<T1, T2, T3, T4, AsyncCallback, object, IAsyncResult> begin, Func<IAsyncResult, TResult> end)
		{
			return delegate(T1 x, T2 y, T3 z, T4 a)
			{
				AsyncSubject<TResult> subject = new AsyncSubject<TResult>();
				IObservable<TResult> observable;
				try
				{
					begin(x, y, z, a, delegate(IAsyncResult iar)
					{
						TResult tresult;
						try
						{
							tresult = end(iar);
						}
						catch (Exception ex2)
						{
							subject.OnError(ex2);
							return;
						}
						subject.OnNext(tresult);
						subject.OnCompleted();
					}, null);
					goto IL_0047;
				}
				catch (Exception ex)
				{
					observable = Observable.Throw<TResult>(ex, SchedulerDefaults.AsyncConversions);
				}
				return observable;
				IL_0047:
				return subject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, IObservable<TResult>> FromAsyncPattern<T1, T2, T3, T4, T5, TResult>(Func<T1, T2, T3, T4, T5, AsyncCallback, object, IAsyncResult> begin, Func<IAsyncResult, TResult> end)
		{
			return delegate(T1 x, T2 y, T3 z, T4 a, T5 b)
			{
				AsyncSubject<TResult> subject = new AsyncSubject<TResult>();
				IObservable<TResult> observable;
				try
				{
					begin(x, y, z, a, b, delegate(IAsyncResult iar)
					{
						TResult tresult;
						try
						{
							tresult = end(iar);
						}
						catch (Exception ex2)
						{
							subject.OnError(ex2);
							return;
						}
						subject.OnNext(tresult);
						subject.OnCompleted();
					}, null);
					goto IL_0049;
				}
				catch (Exception ex)
				{
					observable = Observable.Throw<TResult>(ex, SchedulerDefaults.AsyncConversions);
				}
				return observable;
				IL_0049:
				return subject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, IObservable<TResult>> FromAsyncPattern<T1, T2, T3, T4, T5, T6, TResult>(Func<T1, T2, T3, T4, T5, T6, AsyncCallback, object, IAsyncResult> begin, Func<IAsyncResult, TResult> end)
		{
			return delegate(T1 x, T2 y, T3 z, T4 a, T5 b, T6 c)
			{
				AsyncSubject<TResult> subject = new AsyncSubject<TResult>();
				IObservable<TResult> observable;
				try
				{
					begin(x, y, z, a, b, c, delegate(IAsyncResult iar)
					{
						TResult tresult;
						try
						{
							tresult = end(iar);
						}
						catch (Exception ex2)
						{
							subject.OnError(ex2);
							return;
						}
						subject.OnNext(tresult);
						subject.OnCompleted();
					}, null);
					goto IL_004B;
				}
				catch (Exception ex)
				{
					observable = Observable.Throw<TResult>(ex, SchedulerDefaults.AsyncConversions);
				}
				return observable;
				IL_004B:
				return subject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, IObservable<TResult>> FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, AsyncCallback, object, IAsyncResult> begin, Func<IAsyncResult, TResult> end)
		{
			return delegate(T1 x, T2 y, T3 z, T4 a, T5 b, T6 c, T7 d)
			{
				AsyncSubject<TResult> subject = new AsyncSubject<TResult>();
				IObservable<TResult> observable;
				try
				{
					begin(x, y, z, a, b, c, d, delegate(IAsyncResult iar)
					{
						TResult tresult;
						try
						{
							tresult = end(iar);
						}
						catch (Exception ex2)
						{
							subject.OnError(ex2);
							return;
						}
						subject.OnNext(tresult);
						subject.OnCompleted();
					}, null);
					goto IL_004D;
				}
				catch (Exception ex)
				{
					observable = Observable.Throw<TResult>(ex, SchedulerDefaults.AsyncConversions);
				}
				return observable;
				IL_004D:
				return subject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, IObservable<TResult>> FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, AsyncCallback, object, IAsyncResult> begin, Func<IAsyncResult, TResult> end)
		{
			return delegate(T1 x, T2 y, T3 z, T4 a, T5 b, T6 c, T7 d, T8 e)
			{
				AsyncSubject<TResult> subject = new AsyncSubject<TResult>();
				IObservable<TResult> observable;
				try
				{
					begin(x, y, z, a, b, c, d, e, delegate(IAsyncResult iar)
					{
						TResult tresult;
						try
						{
							tresult = end(iar);
						}
						catch (Exception ex2)
						{
							subject.OnError(ex2);
							return;
						}
						subject.OnNext(tresult);
						subject.OnCompleted();
					}, null);
					goto IL_004F;
				}
				catch (Exception ex)
				{
					observable = Observable.Throw<TResult>(ex, SchedulerDefaults.AsyncConversions);
				}
				return observable;
				IL_004F:
				return subject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, IObservable<TResult>> FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8, T9, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, AsyncCallback, object, IAsyncResult> begin, Func<IAsyncResult, TResult> end)
		{
			return delegate(T1 x, T2 y, T3 z, T4 a, T5 b, T6 c, T7 d, T8 e, T9 f)
			{
				AsyncSubject<TResult> subject = new AsyncSubject<TResult>();
				IObservable<TResult> observable;
				try
				{
					begin(x, y, z, a, b, c, d, e, f, delegate(IAsyncResult iar)
					{
						TResult tresult;
						try
						{
							tresult = end(iar);
						}
						catch (Exception ex2)
						{
							subject.OnError(ex2);
							return;
						}
						subject.OnNext(tresult);
						subject.OnCompleted();
					}, null);
					goto IL_0051;
				}
				catch (Exception ex)
				{
					observable = Observable.Throw<TResult>(ex, SchedulerDefaults.AsyncConversions);
				}
				return observable;
				IL_0051:
				return subject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, IObservable<TResult>> FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, AsyncCallback, object, IAsyncResult> begin, Func<IAsyncResult, TResult> end)
		{
			return delegate(T1 x, T2 y, T3 z, T4 a, T5 b, T6 c, T7 d, T8 e, T9 f, T10 g)
			{
				AsyncSubject<TResult> subject = new AsyncSubject<TResult>();
				IObservable<TResult> observable;
				try
				{
					begin(x, y, z, a, b, c, d, e, f, g, delegate(IAsyncResult iar)
					{
						TResult tresult;
						try
						{
							tresult = end(iar);
						}
						catch (Exception ex2)
						{
							subject.OnError(ex2);
							return;
						}
						subject.OnNext(tresult);
						subject.OnCompleted();
					}, null);
					goto IL_0053;
				}
				catch (Exception ex)
				{
					observable = Observable.Throw<TResult>(ex, SchedulerDefaults.AsyncConversions);
				}
				return observable;
				IL_0053:
				return subject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, IObservable<TResult>> FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, AsyncCallback, object, IAsyncResult> begin, Func<IAsyncResult, TResult> end)
		{
			return delegate(T1 x, T2 y, T3 z, T4 a, T5 b, T6 c, T7 d, T8 e, T9 f, T10 g, T11 h)
			{
				AsyncSubject<TResult> subject = new AsyncSubject<TResult>();
				IObservable<TResult> observable;
				try
				{
					begin(x, y, z, a, b, c, d, e, f, g, h, delegate(IAsyncResult iar)
					{
						TResult tresult;
						try
						{
							tresult = end(iar);
						}
						catch (Exception ex2)
						{
							subject.OnError(ex2);
							return;
						}
						subject.OnNext(tresult);
						subject.OnCompleted();
					}, null);
					goto IL_0055;
				}
				catch (Exception ex)
				{
					observable = Observable.Throw<TResult>(ex, SchedulerDefaults.AsyncConversions);
				}
				return observable;
				IL_0055:
				return subject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, IObservable<TResult>> FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, AsyncCallback, object, IAsyncResult> begin, Func<IAsyncResult, TResult> end)
		{
			return delegate(T1 x, T2 y, T3 z, T4 a, T5 b, T6 c, T7 d, T8 e, T9 f, T10 g, T11 h, T12 i)
			{
				AsyncSubject<TResult> subject = new AsyncSubject<TResult>();
				IObservable<TResult> observable;
				try
				{
					begin(x, y, z, a, b, c, d, e, f, g, h, i, delegate(IAsyncResult iar)
					{
						TResult tresult;
						try
						{
							tresult = end(iar);
						}
						catch (Exception ex2)
						{
							subject.OnError(ex2);
							return;
						}
						subject.OnNext(tresult);
						subject.OnCompleted();
					}, null);
					goto IL_0057;
				}
				catch (Exception ex)
				{
					observable = Observable.Throw<TResult>(ex, SchedulerDefaults.AsyncConversions);
				}
				return observable;
				IL_0057:
				return subject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, IObservable<TResult>> FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, AsyncCallback, object, IAsyncResult> begin, Func<IAsyncResult, TResult> end)
		{
			return delegate(T1 x, T2 y, T3 z, T4 a, T5 b, T6 c, T7 d, T8 e, T9 f, T10 g, T11 h, T12 i, T13 j)
			{
				AsyncSubject<TResult> subject = new AsyncSubject<TResult>();
				IObservable<TResult> observable;
				try
				{
					begin(x, y, z, a, b, c, d, e, f, g, h, i, j, delegate(IAsyncResult iar)
					{
						TResult tresult;
						try
						{
							tresult = end(iar);
						}
						catch (Exception ex2)
						{
							subject.OnError(ex2);
							return;
						}
						subject.OnNext(tresult);
						subject.OnCompleted();
					}, null);
					goto IL_0059;
				}
				catch (Exception ex)
				{
					observable = Observable.Throw<TResult>(ex, SchedulerDefaults.AsyncConversions);
				}
				return observable;
				IL_0059:
				return subject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, IObservable<TResult>> FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, AsyncCallback, object, IAsyncResult> begin, Func<IAsyncResult, TResult> end)
		{
			return delegate(T1 x, T2 y, T3 z, T4 a, T5 b, T6 c, T7 d, T8 e, T9 f, T10 g, T11 h, T12 i, T13 j, T14 k)
			{
				AsyncSubject<TResult> subject = new AsyncSubject<TResult>();
				IObservable<TResult> observable;
				try
				{
					begin(x, y, z, a, b, c, d, e, f, g, h, i, j, k, delegate(IAsyncResult iar)
					{
						TResult tresult;
						try
						{
							tresult = end(iar);
						}
						catch (Exception ex2)
						{
							subject.OnError(ex2);
							return;
						}
						subject.OnNext(tresult);
						subject.OnCompleted();
					}, null);
					goto IL_005B;
				}
				catch (Exception ex)
				{
					observable = Observable.Throw<TResult>(ex, SchedulerDefaults.AsyncConversions);
				}
				return observable;
				IL_005B:
				return subject.AsObservable<TResult>();
			};
		}

		public virtual Func<IObservable<Unit>> FromAsyncPattern(Func<AsyncCallback, object, IAsyncResult> begin, Action<IAsyncResult> end)
		{
			return this.FromAsyncPattern<Unit>(begin, delegate(IAsyncResult iar)
			{
				end(iar);
				return Unit.Default;
			});
		}

		public virtual Func<T1, IObservable<Unit>> FromAsyncPattern<T1>(Func<T1, AsyncCallback, object, IAsyncResult> begin, Action<IAsyncResult> end)
		{
			return this.FromAsyncPattern<T1, Unit>(begin, delegate(IAsyncResult iar)
			{
				end(iar);
				return Unit.Default;
			});
		}

		public virtual Func<T1, T2, IObservable<Unit>> FromAsyncPattern<T1, T2>(Func<T1, T2, AsyncCallback, object, IAsyncResult> begin, Action<IAsyncResult> end)
		{
			return this.FromAsyncPattern<T1, T2, Unit>(begin, delegate(IAsyncResult iar)
			{
				end(iar);
				return Unit.Default;
			});
		}

		public virtual Func<T1, T2, T3, IObservable<Unit>> FromAsyncPattern<T1, T2, T3>(Func<T1, T2, T3, AsyncCallback, object, IAsyncResult> begin, Action<IAsyncResult> end)
		{
			return this.FromAsyncPattern<T1, T2, T3, Unit>(begin, delegate(IAsyncResult iar)
			{
				end(iar);
				return Unit.Default;
			});
		}

		public virtual Func<T1, T2, T3, T4, IObservable<Unit>> FromAsyncPattern<T1, T2, T3, T4>(Func<T1, T2, T3, T4, AsyncCallback, object, IAsyncResult> begin, Action<IAsyncResult> end)
		{
			return this.FromAsyncPattern<T1, T2, T3, T4, Unit>(begin, delegate(IAsyncResult iar)
			{
				end(iar);
				return Unit.Default;
			});
		}

		public virtual Func<T1, T2, T3, T4, T5, IObservable<Unit>> FromAsyncPattern<T1, T2, T3, T4, T5>(Func<T1, T2, T3, T4, T5, AsyncCallback, object, IAsyncResult> begin, Action<IAsyncResult> end)
		{
			return this.FromAsyncPattern<T1, T2, T3, T4, T5, Unit>(begin, delegate(IAsyncResult iar)
			{
				end(iar);
				return Unit.Default;
			});
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, IObservable<Unit>> FromAsyncPattern<T1, T2, T3, T4, T5, T6>(Func<T1, T2, T3, T4, T5, T6, AsyncCallback, object, IAsyncResult> begin, Action<IAsyncResult> end)
		{
			return this.FromAsyncPattern<T1, T2, T3, T4, T5, T6, Unit>(begin, delegate(IAsyncResult iar)
			{
				end(iar);
				return Unit.Default;
			});
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, IObservable<Unit>> FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7>(Func<T1, T2, T3, T4, T5, T6, T7, AsyncCallback, object, IAsyncResult> begin, Action<IAsyncResult> end)
		{
			return this.FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, Unit>(begin, delegate(IAsyncResult iar)
			{
				end(iar);
				return Unit.Default;
			});
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, IObservable<Unit>> FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8>(Func<T1, T2, T3, T4, T5, T6, T7, T8, AsyncCallback, object, IAsyncResult> begin, Action<IAsyncResult> end)
		{
			return this.FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8, Unit>(begin, delegate(IAsyncResult iar)
			{
				end(iar);
				return Unit.Default;
			});
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, IObservable<Unit>> FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8, T9>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, AsyncCallback, object, IAsyncResult> begin, Action<IAsyncResult> end)
		{
			return this.FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8, T9, Unit>(begin, delegate(IAsyncResult iar)
			{
				end(iar);
				return Unit.Default;
			});
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, IObservable<Unit>> FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, AsyncCallback, object, IAsyncResult> begin, Action<IAsyncResult> end)
		{
			return this.FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, Unit>(begin, delegate(IAsyncResult iar)
			{
				end(iar);
				return Unit.Default;
			});
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, IObservable<Unit>> FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, AsyncCallback, object, IAsyncResult> begin, Action<IAsyncResult> end)
		{
			return this.FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, Unit>(begin, delegate(IAsyncResult iar)
			{
				end(iar);
				return Unit.Default;
			});
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, IObservable<Unit>> FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, AsyncCallback, object, IAsyncResult> begin, Action<IAsyncResult> end)
		{
			return this.FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, Unit>(begin, delegate(IAsyncResult iar)
			{
				end(iar);
				return Unit.Default;
			});
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, IObservable<Unit>> FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, AsyncCallback, object, IAsyncResult> begin, Action<IAsyncResult> end)
		{
			return this.FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, Unit>(begin, delegate(IAsyncResult iar)
			{
				end(iar);
				return Unit.Default;
			});
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, IObservable<Unit>> FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, AsyncCallback, object, IAsyncResult> begin, Action<IAsyncResult> end)
		{
			return this.FromAsyncPattern<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, Unit>(begin, delegate(IAsyncResult iar)
			{
				end(iar);
				return Unit.Default;
			});
		}

		public virtual IObservable<TSource> Start<TSource>(Func<TSource> function)
		{
			return this.ToAsync<TSource>(function)();
		}

		public virtual IObservable<TSource> Start<TSource>(Func<TSource> function, IScheduler scheduler)
		{
			return this.ToAsync<TSource>(function, scheduler)();
		}

		public virtual IObservable<TSource> StartAsync<TSource>(Func<Task<TSource>> functionAsync)
		{
			return this.StartAsyncImpl<TSource>(functionAsync, null);
		}

		public virtual IObservable<TSource> StartAsync<TSource>(Func<Task<TSource>> functionAsync, IScheduler scheduler)
		{
			return this.StartAsyncImpl<TSource>(functionAsync, scheduler);
		}

		private IObservable<TSource> StartAsyncImpl<TSource>(Func<Task<TSource>> functionAsync, IScheduler scheduler)
		{
			Task<TSource> task;
			IObservable<TSource> observable;
			try
			{
				task = functionAsync();
				goto IL_0016;
			}
			catch (Exception ex)
			{
				observable = this.Throw<TSource>(ex);
			}
			return observable;
			IL_0016:
			if (scheduler != null)
			{
				return task.ToObservable(scheduler);
			}
			return task.ToObservable<TSource>();
		}

		public virtual IObservable<TSource> StartAsync<TSource>(Func<CancellationToken, Task<TSource>> functionAsync)
		{
			return this.StartAsyncImpl<TSource>(functionAsync, null);
		}

		public virtual IObservable<TSource> StartAsync<TSource>(Func<CancellationToken, Task<TSource>> functionAsync, IScheduler scheduler)
		{
			return this.StartAsyncImpl<TSource>(functionAsync, scheduler);
		}

		private IObservable<TSource> StartAsyncImpl<TSource>(Func<CancellationToken, Task<TSource>> functionAsync, IScheduler scheduler)
		{
			CancellationDisposable cancellationDisposable = new CancellationDisposable();
			IObservable<TSource> observable;
			try
			{
				Task<TSource> task = functionAsync(cancellationDisposable.Token);
				goto IL_0024;
			}
			catch (Exception ex)
			{
				observable = this.Throw<TSource>(ex);
			}
			return observable;
			IL_0024:
			IObservable<TSource> observable2;
			if (scheduler != null)
			{
				Task<TSource> task;
				observable2 = task.ToObservable(scheduler);
			}
			else
			{
				Task<TSource> task;
				observable2 = task.ToObservable<TSource>();
			}
			return new QueryLanguage.StartAsyncObservable<TSource>(cancellationDisposable, observable2);
		}

		public virtual IObservable<Unit> Start(Action action)
		{
			return this.ToAsync(action, SchedulerDefaults.AsyncConversions)();
		}

		public virtual IObservable<Unit> Start(Action action, IScheduler scheduler)
		{
			return this.ToAsync(action, scheduler)();
		}

		public virtual IObservable<Unit> StartAsync(Func<Task> actionAsync)
		{
			return this.StartAsyncImpl(actionAsync, null);
		}

		public virtual IObservable<Unit> StartAsync(Func<Task> actionAsync, IScheduler scheduler)
		{
			return this.StartAsyncImpl(actionAsync, scheduler);
		}

		private IObservable<Unit> StartAsyncImpl(Func<Task> actionAsync, IScheduler scheduler)
		{
			Task task;
			IObservable<Unit> observable;
			try
			{
				task = actionAsync();
				goto IL_0016;
			}
			catch (Exception ex)
			{
				observable = this.Throw<Unit>(ex);
			}
			return observable;
			IL_0016:
			if (scheduler != null)
			{
				return task.ToObservable(scheduler);
			}
			return task.ToObservable();
		}

		public virtual IObservable<Unit> StartAsync(Func<CancellationToken, Task> actionAsync)
		{
			return this.StartAsyncImpl(actionAsync, null);
		}

		public virtual IObservable<Unit> StartAsync(Func<CancellationToken, Task> actionAsync, IScheduler scheduler)
		{
			return this.StartAsyncImpl(actionAsync, scheduler);
		}

		private IObservable<Unit> StartAsyncImpl(Func<CancellationToken, Task> actionAsync, IScheduler scheduler)
		{
			CancellationDisposable cancellationDisposable = new CancellationDisposable();
			IObservable<Unit> observable;
			try
			{
				Task task = actionAsync(cancellationDisposable.Token);
				goto IL_0024;
			}
			catch (Exception ex)
			{
				observable = this.Throw<Unit>(ex);
			}
			return observable;
			IL_0024:
			IObservable<Unit> observable2;
			if (scheduler != null)
			{
				Task task;
				observable2 = task.ToObservable(scheduler);
			}
			else
			{
				Task task;
				observable2 = task.ToObservable();
			}
			return new QueryLanguage.StartAsyncObservable<Unit>(cancellationDisposable, observable2);
		}

		public virtual IObservable<TResult> FromAsync<TResult>(Func<Task<TResult>> functionAsync)
		{
			return this.Defer<TResult>(() => this.StartAsync<TResult>(functionAsync));
		}

		public virtual IObservable<TResult> FromAsync<TResult>(Func<CancellationToken, Task<TResult>> functionAsync)
		{
			return this.Defer<TResult>(() => this.StartAsync<TResult>(functionAsync));
		}

		public virtual IObservable<TResult> FromAsync<TResult>(Func<Task<TResult>> functionAsync, IScheduler scheduler)
		{
			return this.Defer<TResult>(() => this.StartAsync<TResult>(functionAsync, scheduler));
		}

		public virtual IObservable<TResult> FromAsync<TResult>(Func<CancellationToken, Task<TResult>> functionAsync, IScheduler scheduler)
		{
			return this.Defer<TResult>(() => this.StartAsync<TResult>(functionAsync, scheduler));
		}

		public virtual IObservable<Unit> FromAsync(Func<Task> actionAsync)
		{
			return this.Defer<Unit>(() => this.StartAsync(actionAsync));
		}

		public virtual IObservable<Unit> FromAsync(Func<CancellationToken, Task> actionAsync)
		{
			return this.Defer<Unit>(() => this.StartAsync(actionAsync));
		}

		public virtual IObservable<Unit> FromAsync(Func<Task> actionAsync, IScheduler scheduler)
		{
			return this.Defer<Unit>(() => this.StartAsync(actionAsync, scheduler));
		}

		public virtual IObservable<Unit> FromAsync(Func<CancellationToken, Task> actionAsync, IScheduler scheduler)
		{
			return this.Defer<Unit>(() => this.StartAsync(actionAsync, scheduler));
		}

		public virtual Func<IObservable<TResult>> ToAsync<TResult>(Func<TResult> function)
		{
			return this.ToAsync<TResult>(function, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<IObservable<TResult>> ToAsync<TResult>(Func<TResult> function, IScheduler scheduler)
		{
			return delegate
			{
				AsyncSubject<TResult> asyncSubject = new AsyncSubject<TResult>();
				scheduler.ScheduleAction(new ValueTuple<Func<TResult>, AsyncSubject<TResult>>(function, asyncSubject), delegate([TupleElementNames(new string[] { "function", "subject" })] ValueTuple<Func<TResult>, AsyncSubject<TResult>> state)
				{
					TResult tresult;
					try
					{
						tresult = state.Item1();
					}
					catch (Exception ex)
					{
						state.Item2.OnError(ex);
						return;
					}
					state.Item2.OnNext(tresult);
					state.Item2.OnCompleted();
				});
				return asyncSubject.AsObservable<TResult>();
			};
		}

		public virtual Func<T, IObservable<TResult>> ToAsync<T, TResult>(Func<T, TResult> function)
		{
			return this.ToAsync<T, TResult>(function, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T, IObservable<TResult>> ToAsync<T, TResult>(Func<T, TResult> function, IScheduler scheduler)
		{
			return delegate(T first)
			{
				AsyncSubject<TResult> asyncSubject = new AsyncSubject<TResult>();
				scheduler.ScheduleAction(new ValueTuple<Func<T, TResult>, AsyncSubject<TResult>, T>(function, asyncSubject, first), delegate([TupleElementNames(new string[] { "function", "subject", "first" })] ValueTuple<Func<T, TResult>, AsyncSubject<TResult>, T> state)
				{
					TResult tresult;
					try
					{
						tresult = state.Item1(state.Item3);
					}
					catch (Exception ex)
					{
						state.Item2.OnError(ex);
						return;
					}
					state.Item2.OnNext(tresult);
					state.Item2.OnCompleted();
				});
				return asyncSubject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, IObservable<TResult>> ToAsync<T1, T2, TResult>(Func<T1, T2, TResult> function)
		{
			return this.ToAsync<T1, T2, TResult>(function, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, IObservable<TResult>> ToAsync<T1, T2, TResult>(Func<T1, T2, TResult> function, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second)
			{
				AsyncSubject<TResult> asyncSubject = new AsyncSubject<TResult>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<TResult>, Func<T1, T2, TResult>, T1, T2>(asyncSubject, function, first, second), delegate([TupleElementNames(new string[] { "subject", "function", "first", "second" })] ValueTuple<AsyncSubject<TResult>, Func<T1, T2, TResult>, T1, T2> state)
				{
					TResult tresult;
					try
					{
						tresult = state.Item2(state.Item3, state.Item4);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(tresult);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, IObservable<TResult>> ToAsync<T1, T2, T3, TResult>(Func<T1, T2, T3, TResult> function)
		{
			return this.ToAsync<T1, T2, T3, TResult>(function, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, IObservable<TResult>> ToAsync<T1, T2, T3, TResult>(Func<T1, T2, T3, TResult> function, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third)
			{
				AsyncSubject<TResult> asyncSubject = new AsyncSubject<TResult>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, TResult>, T1, T2, T3>(asyncSubject, function, first, second, third), delegate([TupleElementNames(new string[] { "subject", "function", "first", "second", "third" })] ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, TResult>, T1, T2, T3> state)
				{
					TResult tresult;
					try
					{
						tresult = state.Item2(state.Item3, state.Item4, state.Item5);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(tresult);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, IObservable<TResult>> ToAsync<T1, T2, T3, T4, TResult>(Func<T1, T2, T3, T4, TResult> function)
		{
			return this.ToAsync<T1, T2, T3, T4, TResult>(function, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, IObservable<TResult>> ToAsync<T1, T2, T3, T4, TResult>(Func<T1, T2, T3, T4, TResult> function, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth)
			{
				AsyncSubject<TResult> asyncSubject = new AsyncSubject<TResult>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, TResult>, T1, T2, T3, T4>(asyncSubject, function, first, second, third, fourth), delegate([TupleElementNames(new string[] { "subject", "function", "first", "second", "third", "fourth" })] ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, TResult>, T1, T2, T3, T4> state)
				{
					TResult tresult;
					try
					{
						tresult = state.Item2(state.Item3, state.Item4, state.Item5, state.Item6);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(tresult);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, TResult>(Func<T1, T2, T3, T4, T5, TResult> function)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, TResult>(function, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, TResult>(Func<T1, T2, T3, T4, T5, TResult> function, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth)
			{
				AsyncSubject<TResult> asyncSubject = new AsyncSubject<TResult>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, TResult>, T1, T2, T3, T4, T5>(asyncSubject, function, first, second, third, fourth, fifth), delegate([TupleElementNames(new string[] { "subject", "function", "first", "second", "third", "fourth", "fifth" })] ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, TResult>, T1, T2, T3, T4, T5> state)
				{
					TResult tresult;
					try
					{
						tresult = state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(tresult);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, TResult>(Func<T1, T2, T3, T4, T5, T6, TResult> function)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, TResult>(function, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, TResult>(Func<T1, T2, T3, T4, T5, T6, TResult> function, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth)
			{
				AsyncSubject<TResult> asyncSubject = new AsyncSubject<TResult>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6>>(asyncSubject, function, first, second, third, fourth, fifth, new ValueTuple<T6>(sixth)), delegate([TupleElementNames(new string[] { "subject", "function", "first", "second", "third", "fourth", "fifth", "sixth", null })] ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6>> state)
				{
					TResult tresult;
					try
					{
						tresult = state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(tresult);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, T7, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, TResult> function)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, T7, TResult>(function, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, T7, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, TResult> function, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth, T7 seventh)
			{
				AsyncSubject<TResult> asyncSubject = new AsyncSubject<TResult>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, T7, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6, T7>>(asyncSubject, function, first, second, third, fourth, fifth, new ValueTuple<T6, T7>(sixth, seventh)), delegate([TupleElementNames(new string[]
				{
					"subject", "function", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", null,
					null
				})] ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, T7, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6, T7>> state)
				{
					TResult tresult;
					try
					{
						tresult = state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1, state.Rest.Item2);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(tresult);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, TResult> function)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, TResult>(function, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, TResult> function, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth, T7 seventh, T8 eight)
			{
				AsyncSubject<TResult> asyncSubject = new AsyncSubject<TResult>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, T7, T8, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8>>(asyncSubject, function, first, second, third, fourth, fifth, new ValueTuple<T6, T7, T8>(sixth, seventh, eight)), delegate([TupleElementNames(new string[]
				{
					"subject", "function", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eight",
					null, null, null
				})] ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, T7, T8, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8>> state)
				{
					TResult tresult;
					try
					{
						tresult = state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1, state.Rest.Item2, state.Rest.Item3);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(tresult);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, TResult> function)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, TResult>(function, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, TResult> function, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth, T7 seventh, T8 eight, T9 ninth)
			{
				AsyncSubject<TResult> asyncSubject = new AsyncSubject<TResult>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9>>(asyncSubject, function, first, second, third, fourth, fifth, new ValueTuple<T6, T7, T8, T9>(sixth, seventh, eight, ninth)), delegate([TupleElementNames(new string[]
				{
					"subject", "function", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eight",
					"ninth", null, null, null, null
				})] ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9>> state)
				{
					TResult tresult;
					try
					{
						tresult = state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1, state.Rest.Item2, state.Rest.Item3, state.Rest.Item4);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(tresult);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, TResult> function)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, TResult>(function, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, TResult> function, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth, T7 seventh, T8 eight, T9 ninth, T10 tenth)
			{
				AsyncSubject<TResult> asyncSubject = new AsyncSubject<TResult>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10>>(asyncSubject, function, first, second, third, fourth, fifth, new ValueTuple<T6, T7, T8, T9, T10>(sixth, seventh, eight, ninth, tenth)), delegate([TupleElementNames(new string[]
				{
					"subject", "function", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eight",
					"ninth", "tenth", null, null, null, null, null
				})] ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10>> state)
				{
					TResult tresult;
					try
					{
						tresult = state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1, state.Rest.Item2, state.Rest.Item3, state.Rest.Item4, state.Rest.Item5);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(tresult);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, TResult> function)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, TResult>(function, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, TResult> function, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth, T7 seventh, T8 eight, T9 ninth, T10 tenth, T11 eleventh)
			{
				AsyncSubject<TResult> asyncSubject = new AsyncSubject<TResult>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11>>(asyncSubject, function, first, second, third, fourth, fifth, new ValueTuple<T6, T7, T8, T9, T10, T11>(sixth, seventh, eight, ninth, tenth, eleventh)), delegate([TupleElementNames(new string[]
				{
					"subject", "function", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eight",
					"ninth", "tenth", "eleventh", null, null, null, null, null, null
				})] ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11>> state)
				{
					TResult tresult;
					try
					{
						tresult = state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1, state.Rest.Item2, state.Rest.Item3, state.Rest.Item4, state.Rest.Item5, state.Rest.Item6);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(tresult);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, TResult> function)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, TResult>(function, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, TResult> function, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth, T7 seventh, T8 eight, T9 ninth, T10 tenth, T11 eleventh, T12 twelfth)
			{
				AsyncSubject<TResult> asyncSubject = new AsyncSubject<TResult>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11, T12>>(asyncSubject, function, first, second, third, fourth, fifth, new ValueTuple<T6, T7, T8, T9, T10, T11, T12>(sixth, seventh, eight, ninth, tenth, eleventh, twelfth)), delegate([TupleElementNames(new string[]
				{
					"subject", "function", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eight",
					"ninth", "tenth", "eleventh", "twelfth", null, null, null, null, null, null,
					null
				})] ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11, T12>> state)
				{
					TResult tresult;
					try
					{
						tresult = state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1, state.Rest.Item2, state.Rest.Item3, state.Rest.Item4, state.Rest.Item5, state.Rest.Item6, state.Rest.Item7);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(tresult);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, TResult> function)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, TResult>(function, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, TResult> function, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth, T7 seventh, T8 eight, T9 ninth, T10 tenth, T11 eleventh, T12 twelfth, T13 thirteenth)
			{
				AsyncSubject<TResult> asyncSubject = new AsyncSubject<TResult>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13>>>(asyncSubject, function, first, second, third, fourth, fifth, new ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13>>(sixth, seventh, eight, ninth, tenth, eleventh, twelfth, new ValueTuple<T13>(thirteenth))), delegate([TupleElementNames(new string[]
				{
					"subject", "function", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eight",
					"ninth", "tenth", "eleventh", "twelfth", "thirteenth", null, null, null, null, null,
					null, null, null, null
				})] ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13>>> state)
				{
					TResult tresult;
					try
					{
						tresult = state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1, state.Rest.Item2, state.Rest.Item3, state.Rest.Item4, state.Rest.Item5, state.Rest.Item6, state.Rest.Item7, state.Rest.Rest.Item1);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(tresult);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, TResult> function)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, TResult>(function, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, TResult> function, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth, T7 seventh, T8 eight, T9 ninth, T10 tenth, T11 eleventh, T12 twelfth, T13 thirteenth, T14 fourteenth)
			{
				AsyncSubject<TResult> asyncSubject = new AsyncSubject<TResult>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13, T14>>>(asyncSubject, function, first, second, third, fourth, fifth, new ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13, T14>>(sixth, seventh, eight, ninth, tenth, eleventh, twelfth, new ValueTuple<T13, T14>(thirteenth, fourteenth))), delegate([TupleElementNames(new string[]
				{
					"subject", "function", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eight",
					"ninth", "tenth", "eleventh", "twelfth", "thirteenth", "fourteenth", null, null, null, null,
					null, null, null, null, null, null, null
				})] ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13, T14>>> state)
				{
					TResult tresult;
					try
					{
						tresult = state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1, state.Rest.Item2, state.Rest.Item3, state.Rest.Item4, state.Rest.Item5, state.Rest.Item6, state.Rest.Item7, state.Rest.Rest.Item1, state.Rest.Rest.Item2);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(tresult);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, TResult> function)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, TResult>(function, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, TResult> function, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth, T7 seventh, T8 eight, T9 ninth, T10 tenth, T11 eleventh, T12 twelfth, T13 thirteenth, T14 fourteenth, T15 fifteenth)
			{
				AsyncSubject<TResult> asyncSubject = new AsyncSubject<TResult>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13, T14, T15>>>(asyncSubject, function, first, second, third, fourth, fifth, new ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13, T14, T15>>(sixth, seventh, eight, ninth, tenth, eleventh, twelfth, new ValueTuple<T13, T14, T15>(thirteenth, fourteenth, fifteenth))), delegate([TupleElementNames(new string[]
				{
					"subject", "function", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eight",
					"ninth", "tenth", "eleventh", "twelfth", "thirteenth", "fourteenth", "fifteenth", null, null, null,
					null, null, null, null, null, null, null, null, null, null
				})] ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13, T14, T15>>> state)
				{
					TResult tresult;
					try
					{
						tresult = state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1, state.Rest.Item2, state.Rest.Item3, state.Rest.Item4, state.Rest.Item5, state.Rest.Item6, state.Rest.Item7, state.Rest.Rest.Item1, state.Rest.Rest.Item2, state.Rest.Rest.Item3);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(tresult);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<TResult>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, TResult> function)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, TResult>(function, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, IObservable<TResult>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, TResult>(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, TResult> function, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth, T7 seventh, T8 eight, T9 ninth, T10 tenth, T11 eleventh, T12 twelfth, T13 thirteenth, T14 fourteenth, T15 fifteenth, T16 sixteenth)
			{
				AsyncSubject<TResult> asyncSubject = new AsyncSubject<TResult>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13, T14, T15, T16>>>(asyncSubject, function, first, second, third, fourth, fifth, new ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13, T14, T15, T16>>(sixth, seventh, eight, ninth, tenth, eleventh, twelfth, new ValueTuple<T13, T14, T15, T16>(thirteenth, fourteenth, fifteenth, sixteenth))), delegate([TupleElementNames(new string[]
				{
					"subject", "function", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eight",
					"ninth", "tenth", "eleventh", "twelfth", "thirteenth", "fourteenth", "fifteenth", "sixteenth", null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null
				})] ValueTuple<AsyncSubject<TResult>, Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, TResult>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13, T14, T15, T16>>> state)
				{
					TResult tresult;
					try
					{
						tresult = state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1, state.Rest.Item2, state.Rest.Item3, state.Rest.Item4, state.Rest.Item5, state.Rest.Item6, state.Rest.Item7, state.Rest.Rest.Item1, state.Rest.Rest.Item2, state.Rest.Rest.Item3, state.Rest.Rest.Item4);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(tresult);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<TResult>();
			};
		}

		public virtual Func<IObservable<Unit>> ToAsync(Action action)
		{
			return this.ToAsync(action, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<IObservable<Unit>> ToAsync(Action action, IScheduler scheduler)
		{
			return delegate
			{
				AsyncSubject<Unit> asyncSubject = new AsyncSubject<Unit>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<Unit>, Action>(asyncSubject, action), delegate([TupleElementNames(new string[] { "subject", "action" })] ValueTuple<AsyncSubject<Unit>, Action> state)
				{
					try
					{
						state.Item2();
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(Unit.Default);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<Unit>();
			};
		}

		public virtual Func<TSource, IObservable<Unit>> ToAsync<TSource>(Action<TSource> action)
		{
			return this.ToAsync<TSource>(action, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<TSource, IObservable<Unit>> ToAsync<TSource>(Action<TSource> action, IScheduler scheduler)
		{
			return delegate(TSource first)
			{
				AsyncSubject<Unit> asyncSubject = new AsyncSubject<Unit>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<Unit>, Action<TSource>, TSource>(asyncSubject, action, first), delegate([TupleElementNames(new string[] { "subject", "action", "first" })] ValueTuple<AsyncSubject<Unit>, Action<TSource>, TSource> state)
				{
					try
					{
						state.Item2(state.Item3);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(Unit.Default);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<Unit>();
			};
		}

		public virtual Func<T1, T2, IObservable<Unit>> ToAsync<T1, T2>(Action<T1, T2> action)
		{
			return this.ToAsync<T1, T2>(action, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, IObservable<Unit>> ToAsync<T1, T2>(Action<T1, T2> action, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second)
			{
				AsyncSubject<Unit> asyncSubject = new AsyncSubject<Unit>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<Unit>, Action<T1, T2>, T1, T2>(asyncSubject, action, first, second), delegate([TupleElementNames(new string[] { "subject", "action", "first", "second" })] ValueTuple<AsyncSubject<Unit>, Action<T1, T2>, T1, T2> state)
				{
					try
					{
						state.Item2(state.Item3, state.Item4);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(Unit.Default);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<Unit>();
			};
		}

		public virtual Func<T1, T2, T3, IObservable<Unit>> ToAsync<T1, T2, T3>(Action<T1, T2, T3> action)
		{
			return this.ToAsync<T1, T2, T3>(action, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, IObservable<Unit>> ToAsync<T1, T2, T3>(Action<T1, T2, T3> action, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third)
			{
				AsyncSubject<Unit> asyncSubject = new AsyncSubject<Unit>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3>, T1, T2, T3>(asyncSubject, action, first, second, third), delegate([TupleElementNames(new string[] { "subject", "action", "first", "second", "third" })] ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3>, T1, T2, T3> state)
				{
					try
					{
						state.Item2(state.Item3, state.Item4, state.Item5);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(Unit.Default);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<Unit>();
			};
		}

		public virtual Func<T1, T2, T3, T4, IObservable<Unit>> ToAsync<T1, T2, T3, T4>(Action<T1, T2, T3, T4> action)
		{
			return this.ToAsync<T1, T2, T3, T4>(action, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, IObservable<Unit>> ToAsync<T1, T2, T3, T4>(Action<T1, T2, T3, T4> action, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth)
			{
				AsyncSubject<Unit> asyncSubject = new AsyncSubject<Unit>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4>, T1, T2, T3, T4>(asyncSubject, action, first, second, third, fourth), delegate([TupleElementNames(new string[] { "subject", "action", "first", "second", "third", "fourth" })] ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4>, T1, T2, T3, T4> state)
				{
					try
					{
						state.Item2(state.Item3, state.Item4, state.Item5, state.Item6);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(Unit.Default);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<Unit>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5>(Action<T1, T2, T3, T4, T5> action)
		{
			return this.ToAsync<T1, T2, T3, T4, T5>(action, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5>(Action<T1, T2, T3, T4, T5> action, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth)
			{
				AsyncSubject<Unit> asyncSubject = new AsyncSubject<Unit>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5>, T1, T2, T3, T4, T5>(asyncSubject, action, first, second, third, fourth, fifth), delegate([TupleElementNames(new string[] { "subject", "action", "first", "second", "third", "fourth", "fifth" })] ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5>, T1, T2, T3, T4, T5> state)
				{
					try
					{
						state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(Unit.Default);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<Unit>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6>(Action<T1, T2, T3, T4, T5, T6> action)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6>(action, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6>(Action<T1, T2, T3, T4, T5, T6> action, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth)
			{
				AsyncSubject<Unit> asyncSubject = new AsyncSubject<Unit>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6>, T1, T2, T3, T4, T5, ValueTuple<T6>>(asyncSubject, action, first, second, third, fourth, fifth, new ValueTuple<T6>(sixth)), delegate([TupleElementNames(new string[] { "subject", "action", "first", "second", "third", "fourth", "fifth", "sixth", null })] ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6>, T1, T2, T3, T4, T5, ValueTuple<T6>> state)
				{
					try
					{
						state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(Unit.Default);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<Unit>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6, T7>(Action<T1, T2, T3, T4, T5, T6, T7> action)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, T7>(action, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6, T7>(Action<T1, T2, T3, T4, T5, T6, T7> action, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth, T7 seventh)
			{
				AsyncSubject<Unit> asyncSubject = new AsyncSubject<Unit>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6, T7>, T1, T2, T3, T4, T5, ValueTuple<T6, T7>>(asyncSubject, action, first, second, third, fourth, fifth, new ValueTuple<T6, T7>(sixth, seventh)), delegate([TupleElementNames(new string[]
				{
					"subject", "action", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", null,
					null
				})] ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6, T7>, T1, T2, T3, T4, T5, ValueTuple<T6, T7>> state)
				{
					try
					{
						state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1, state.Rest.Item2);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(Unit.Default);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<Unit>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8>(Action<T1, T2, T3, T4, T5, T6, T7, T8> action)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, T7, T8>(action, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8>(Action<T1, T2, T3, T4, T5, T6, T7, T8> action, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth, T7 seventh, T8 eighth)
			{
				AsyncSubject<Unit> asyncSubject = new AsyncSubject<Unit>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6, T7, T8>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8>>(asyncSubject, action, first, second, third, fourth, fifth, new ValueTuple<T6, T7, T8>(sixth, seventh, eighth)), delegate([TupleElementNames(new string[]
				{
					"subject", "action", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth",
					null, null, null
				})] ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6, T7, T8>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8>> state)
				{
					try
					{
						state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1, state.Rest.Item2, state.Rest.Item3);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(Unit.Default);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<Unit>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9>(Action<T1, T2, T3, T4, T5, T6, T7, T8, T9> action)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9>(action, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9>(Action<T1, T2, T3, T4, T5, T6, T7, T8, T9> action, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth, T7 seventh, T8 eighth, T9 ninth)
			{
				AsyncSubject<Unit> asyncSubject = new AsyncSubject<Unit>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6, T7, T8, T9>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9>>(asyncSubject, action, first, second, third, fourth, fifth, new ValueTuple<T6, T7, T8, T9>(sixth, seventh, eighth, ninth)), delegate([TupleElementNames(new string[]
				{
					"subject", "action", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth",
					"ninth", null, null, null, null
				})] ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6, T7, T8, T9>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9>> state)
				{
					try
					{
						state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1, state.Rest.Item2, state.Rest.Item3, state.Rest.Item4);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(Unit.Default);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<Unit>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>(Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> action)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>(action, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>(Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> action, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth, T7 seventh, T8 eighth, T9 ninth, T10 tenth)
			{
				AsyncSubject<Unit> asyncSubject = new AsyncSubject<Unit>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10>>(asyncSubject, action, first, second, third, fourth, fifth, new ValueTuple<T6, T7, T8, T9, T10>(sixth, seventh, eighth, ninth, tenth)), delegate([TupleElementNames(new string[]
				{
					"subject", "action", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth",
					"ninth", "tenth", null, null, null, null, null
				})] ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10>> state)
				{
					try
					{
						state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1, state.Rest.Item2, state.Rest.Item3, state.Rest.Item4, state.Rest.Item5);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(Unit.Default);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<Unit>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>(Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> action)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>(action, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>(Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> action, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth, T7 seventh, T8 eighth, T9 ninth, T10 tenth, T11 eleventh)
			{
				AsyncSubject<Unit> asyncSubject = new AsyncSubject<Unit>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11>>(asyncSubject, action, first, second, third, fourth, fifth, new ValueTuple<T6, T7, T8, T9, T10, T11>(sixth, seventh, eighth, ninth, tenth, eleventh)), delegate([TupleElementNames(new string[]
				{
					"subject", "action", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth",
					"ninth", "tenth", "eleventh", null, null, null, null, null, null
				})] ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11>> state)
				{
					try
					{
						state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1, state.Rest.Item2, state.Rest.Item3, state.Rest.Item4, state.Rest.Item5, state.Rest.Item6);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(Unit.Default);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<Unit>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>(Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> action)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>(action, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>(Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> action, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth, T7 seventh, T8 eighth, T9 ninth, T10 tenth, T11 eleventh, T12 twelfth)
			{
				AsyncSubject<Unit> asyncSubject = new AsyncSubject<Unit>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11, T12>>(asyncSubject, action, first, second, third, fourth, fifth, new ValueTuple<T6, T7, T8, T9, T10, T11, T12>(sixth, seventh, eighth, ninth, tenth, eleventh, twelfth)), delegate([TupleElementNames(new string[]
				{
					"subject", "action", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth",
					"ninth", "tenth", "eleventh", "twelfth", null, null, null, null, null, null,
					null
				})] ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11, T12>> state)
				{
					try
					{
						state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1, state.Rest.Item2, state.Rest.Item3, state.Rest.Item4, state.Rest.Item5, state.Rest.Item6, state.Rest.Item7);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(Unit.Default);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<Unit>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>(Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> action)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>(action, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>(Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> action, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth, T7 seventh, T8 eighth, T9 ninth, T10 tenth, T11 eleventh, T12 twelfth, T13 thirteenth)
			{
				AsyncSubject<Unit> asyncSubject = new AsyncSubject<Unit>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13>>>(asyncSubject, action, first, second, third, fourth, fifth, new ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13>>(sixth, seventh, eighth, ninth, tenth, eleventh, twelfth, new ValueTuple<T13>(thirteenth))), delegate([TupleElementNames(new string[]
				{
					"subject", "action", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth",
					"ninth", "tenth", "eleventh", "twelfth", "thirteenth", null, null, null, null, null,
					null, null, null, null
				})] ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13>>> state)
				{
					try
					{
						state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1, state.Rest.Item2, state.Rest.Item3, state.Rest.Item4, state.Rest.Item5, state.Rest.Item6, state.Rest.Item7, state.Rest.Rest.Item1);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(Unit.Default);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<Unit>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>(Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> action)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>(action, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>(Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> action, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth, T7 seventh, T8 eighth, T9 ninth, T10 tenth, T11 eleventh, T12 twelfth, T13 thirteenth, T14 fourteenth)
			{
				AsyncSubject<Unit> asyncSubject = new AsyncSubject<Unit>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13, T14>>>(asyncSubject, action, first, second, third, fourth, fifth, new ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13, T14>>(sixth, seventh, eighth, ninth, tenth, eleventh, twelfth, new ValueTuple<T13, T14>(thirteenth, fourteenth))), delegate([TupleElementNames(new string[]
				{
					"subject", "action", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth",
					"ninth", "tenth", "eleventh", "twelfth", "thirteenth", "fourteenth", null, null, null, null,
					null, null, null, null, null, null, null
				})] ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13, T14>>> state)
				{
					try
					{
						state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1, state.Rest.Item2, state.Rest.Item3, state.Rest.Item4, state.Rest.Item5, state.Rest.Item6, state.Rest.Item7, state.Rest.Rest.Item1, state.Rest.Rest.Item2);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(Unit.Default);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<Unit>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>(Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> action)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>(action, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>(Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> action, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth, T7 seventh, T8 eighth, T9 ninth, T10 tenth, T11 eleventh, T12 twelfth, T13 thirteenth, T14 fourteenth, T15 fifteenth)
			{
				AsyncSubject<Unit> asyncSubject = new AsyncSubject<Unit>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13, T14, T15>>>(asyncSubject, action, first, second, third, fourth, fifth, new ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13, T14, T15>>(sixth, seventh, eighth, ninth, tenth, eleventh, twelfth, new ValueTuple<T13, T14, T15>(thirteenth, fourteenth, fifteenth))), delegate([TupleElementNames(new string[]
				{
					"subject", "action", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth",
					"ninth", "tenth", "eleventh", "twelfth", "thirteenth", "fourteenth", "fifteenth", null, null, null,
					null, null, null, null, null, null, null, null, null, null
				})] ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13, T14, T15>>> state)
				{
					try
					{
						state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1, state.Rest.Item2, state.Rest.Item3, state.Rest.Item4, state.Rest.Item5, state.Rest.Item6, state.Rest.Item7, state.Rest.Rest.Item1, state.Rest.Rest.Item2, state.Rest.Rest.Item3);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(Unit.Default);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<Unit>();
			};
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>(Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> action)
		{
			return this.ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>(action, SchedulerDefaults.AsyncConversions);
		}

		public virtual Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, IObservable<Unit>> ToAsync<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>(Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> action, IScheduler scheduler)
		{
			return delegate(T1 first, T2 second, T3 third, T4 fourth, T5 fifth, T6 sixth, T7 seventh, T8 eighth, T9 ninth, T10 tenth, T11 eleventh, T12 twelfth, T13 thirteenth, T14 fourteenth, T15 fifteenth, T16 sixteenth)
			{
				AsyncSubject<Unit> asyncSubject = new AsyncSubject<Unit>();
				scheduler.ScheduleAction(new ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13, T14, T15, T16>>>(asyncSubject, action, first, second, third, fourth, fifth, new ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13, T14, T15, T16>>(sixth, seventh, eighth, ninth, tenth, eleventh, twelfth, new ValueTuple<T13, T14, T15, T16>(thirteenth, fourteenth, fifteenth, sixteenth))), delegate([TupleElementNames(new string[]
				{
					"subject", "action", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth",
					"ninth", "tenth", "eleventh", "twelfth", "thirteenth", "fourteenth", "fifteenth", "sixteenth", null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null
				})] ValueTuple<AsyncSubject<Unit>, Action<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>, T1, T2, T3, T4, T5, ValueTuple<T6, T7, T8, T9, T10, T11, T12, ValueTuple<T13, T14, T15, T16>>> state)
				{
					try
					{
						state.Item2(state.Item3, state.Item4, state.Item5, state.Item6, state.Item7, state.Rest.Item1, state.Rest.Item2, state.Rest.Item3, state.Rest.Item4, state.Rest.Item5, state.Rest.Item6, state.Rest.Item7, state.Rest.Rest.Item1, state.Rest.Rest.Item2, state.Rest.Rest.Item3, state.Rest.Rest.Item4);
					}
					catch (Exception ex)
					{
						state.Item1.OnError(ex);
						return;
					}
					state.Item1.OnNext(Unit.Default);
					state.Item1.OnCompleted();
				});
				return asyncSubject.AsObservable<Unit>();
			};
		}

		public virtual AsyncSubject<TSource> GetAwaiter<TSource>(IObservable<TSource> source)
		{
			return this.RunAsync<TSource>(source, CancellationToken.None);
		}

		public virtual AsyncSubject<TSource> GetAwaiter<TSource>(IConnectableObservable<TSource> source)
		{
			return this.RunAsync<TSource>(source, CancellationToken.None);
		}

		public virtual AsyncSubject<TSource> RunAsync<TSource>(IObservable<TSource> source, CancellationToken cancellationToken)
		{
			AsyncSubject<TSource> asyncSubject = new AsyncSubject<TSource>();
			if (cancellationToken.IsCancellationRequested)
			{
				return QueryLanguage.Cancel<TSource>(asyncSubject, cancellationToken);
			}
			IDisposable disposable = source.SubscribeSafe(asyncSubject);
			if (cancellationToken.CanBeCanceled)
			{
				QueryLanguage.RegisterCancelation<TSource>(asyncSubject, disposable, cancellationToken);
			}
			return asyncSubject;
		}

		public virtual AsyncSubject<TSource> RunAsync<TSource>(IConnectableObservable<TSource> source, CancellationToken cancellationToken)
		{
			AsyncSubject<TSource> asyncSubject = new AsyncSubject<TSource>();
			if (cancellationToken.IsCancellationRequested)
			{
				return QueryLanguage.Cancel<TSource>(asyncSubject, cancellationToken);
			}
			IDisposable disposable = source.SubscribeSafe(asyncSubject);
			IDisposable disposable2 = source.Connect();
			if (cancellationToken.CanBeCanceled)
			{
				QueryLanguage.RegisterCancelation<TSource>(asyncSubject, StableCompositeDisposable.Create(disposable, disposable2), cancellationToken);
			}
			return asyncSubject;
		}

		private static AsyncSubject<T> Cancel<T>(AsyncSubject<T> subject, CancellationToken cancellationToken)
		{
			subject.OnError(new OperationCanceledException(cancellationToken));
			return subject;
		}

		private static void RegisterCancelation<T>(AsyncSubject<T> subject, object subscription, CancellationToken token)
		{
			CancellationTokenRegistration ctr = token.Register(delegate
			{
				subscription.Dispose();
				QueryLanguage.Cancel<T>(subject, token);
			});
			subject.Subscribe(Stubs<T>.Ignore, delegate(Exception _)
			{
				ctr.Dispose();
			}, new Action(ctr.Dispose));
		}

		public virtual IConnectableObservable<TResult> Multicast<TSource, TResult>(IObservable<TSource> source, ISubject<TSource, TResult> subject)
		{
			return new ConnectableObservable<TSource, TResult>(source, subject);
		}

		public virtual IObservable<TResult> Multicast<TSource, TIntermediate, TResult>(IObservable<TSource> source, Func<ISubject<TSource, TIntermediate>> subjectSelector, Func<IObservable<TIntermediate>, IObservable<TResult>> selector)
		{
			return new Multicast<TSource, TIntermediate, TResult>(source, subjectSelector, selector);
		}

		public virtual IConnectableObservable<TSource> Publish<TSource>(IObservable<TSource> source)
		{
			return source.Multicast(new Subject<TSource>());
		}

		public virtual IObservable<TResult> Publish<TSource, TResult>(IObservable<TSource> source, Func<IObservable<TSource>, IObservable<TResult>> selector)
		{
			return source.Multicast(() => new Subject<TSource>(), selector);
		}

		public virtual IConnectableObservable<TSource> Publish<TSource>(IObservable<TSource> source, TSource initialValue)
		{
			return source.Multicast(new BehaviorSubject<TSource>(initialValue));
		}

		public virtual IObservable<TResult> Publish<TSource, TResult>(IObservable<TSource> source, Func<IObservable<TSource>, IObservable<TResult>> selector, TSource initialValue)
		{
			return source.Multicast(() => new BehaviorSubject<TSource>(initialValue), selector);
		}

		public virtual IConnectableObservable<TSource> PublishLast<TSource>(IObservable<TSource> source)
		{
			return source.Multicast(new AsyncSubject<TSource>());
		}

		public virtual IObservable<TResult> PublishLast<TSource, TResult>(IObservable<TSource> source, Func<IObservable<TSource>, IObservable<TResult>> selector)
		{
			return source.Multicast(() => new AsyncSubject<TSource>(), selector);
		}

		public virtual IObservable<TSource> RefCount<TSource>(IConnectableObservable<TSource> source)
		{
			return new RefCount<TSource>.Eager(source);
		}

		public virtual IObservable<TSource> RefCount<TSource>(IConnectableObservable<TSource> source, TimeSpan disconnectTime)
		{
			return this.RefCount<TSource>(source, disconnectTime, Scheduler.Default);
		}

		public virtual IObservable<TSource> RefCount<TSource>(IConnectableObservable<TSource> source, TimeSpan disconnectTime, IScheduler scheduler)
		{
			return new RefCount<TSource>.Lazy(source, disconnectTime, scheduler);
		}

		public virtual IObservable<TSource> AutoConnect<TSource>(IConnectableObservable<TSource> source, int minObservers = 1, Action<IDisposable> onConnect = null)
		{
			if (minObservers <= 0)
			{
				IDisposable disposable = source.Connect();
				if (onConnect != null)
				{
					onConnect(disposable);
				}
				return source;
			}
			return new AutoConnect<TSource>(source, minObservers, onConnect);
		}

		public virtual IConnectableObservable<TSource> Replay<TSource>(IObservable<TSource> source)
		{
			return source.Multicast(new ReplaySubject<TSource>());
		}

		public virtual IConnectableObservable<TSource> Replay<TSource>(IObservable<TSource> source, IScheduler scheduler)
		{
			return source.Multicast(new ReplaySubject<TSource>(scheduler));
		}

		public virtual IObservable<TResult> Replay<TSource, TResult>(IObservable<TSource> source, Func<IObservable<TSource>, IObservable<TResult>> selector)
		{
			return source.Multicast(() => new ReplaySubject<TSource>(), selector);
		}

		public virtual IObservable<TResult> Replay<TSource, TResult>(IObservable<TSource> source, Func<IObservable<TSource>, IObservable<TResult>> selector, IScheduler scheduler)
		{
			return source.Multicast(() => new ReplaySubject<TSource>(scheduler), selector);
		}

		public virtual IConnectableObservable<TSource> Replay<TSource>(IObservable<TSource> source, TimeSpan window)
		{
			return source.Multicast(new ReplaySubject<TSource>(window));
		}

		public virtual IObservable<TResult> Replay<TSource, TResult>(IObservable<TSource> source, Func<IObservable<TSource>, IObservable<TResult>> selector, TimeSpan window)
		{
			return source.Multicast(() => new ReplaySubject<TSource>(window), selector);
		}

		public virtual IConnectableObservable<TSource> Replay<TSource>(IObservable<TSource> source, TimeSpan window, IScheduler scheduler)
		{
			return source.Multicast(new ReplaySubject<TSource>(window, scheduler));
		}

		public virtual IObservable<TResult> Replay<TSource, TResult>(IObservable<TSource> source, Func<IObservable<TSource>, IObservable<TResult>> selector, TimeSpan window, IScheduler scheduler)
		{
			return source.Multicast(() => new ReplaySubject<TSource>(window, scheduler), selector);
		}

		public virtual IConnectableObservable<TSource> Replay<TSource>(IObservable<TSource> source, int bufferSize, IScheduler scheduler)
		{
			return source.Multicast(new ReplaySubject<TSource>(bufferSize, scheduler));
		}

		public virtual IObservable<TResult> Replay<TSource, TResult>(IObservable<TSource> source, Func<IObservable<TSource>, IObservable<TResult>> selector, int bufferSize, IScheduler scheduler)
		{
			return source.Multicast(() => new ReplaySubject<TSource>(bufferSize, scheduler), selector);
		}

		public virtual IConnectableObservable<TSource> Replay<TSource>(IObservable<TSource> source, int bufferSize)
		{
			return source.Multicast(new ReplaySubject<TSource>(bufferSize));
		}

		public virtual IObservable<TResult> Replay<TSource, TResult>(IObservable<TSource> source, Func<IObservable<TSource>, IObservable<TResult>> selector, int bufferSize)
		{
			return source.Multicast(() => new ReplaySubject<TSource>(bufferSize), selector);
		}

		public virtual IConnectableObservable<TSource> Replay<TSource>(IObservable<TSource> source, int bufferSize, TimeSpan window)
		{
			return source.Multicast(new ReplaySubject<TSource>(bufferSize, window));
		}

		public virtual IObservable<TResult> Replay<TSource, TResult>(IObservable<TSource> source, Func<IObservable<TSource>, IObservable<TResult>> selector, int bufferSize, TimeSpan window)
		{
			return source.Multicast(() => new ReplaySubject<TSource>(bufferSize, window), selector);
		}

		public virtual IConnectableObservable<TSource> Replay<TSource>(IObservable<TSource> source, int bufferSize, TimeSpan window, IScheduler scheduler)
		{
			return source.Multicast(new ReplaySubject<TSource>(bufferSize, window, scheduler));
		}

		public virtual IObservable<TResult> Replay<TSource, TResult>(IObservable<TSource> source, Func<IObservable<TSource>, IObservable<TResult>> selector, int bufferSize, TimeSpan window, IScheduler scheduler)
		{
			return source.Multicast(() => new ReplaySubject<TSource>(bufferSize, window, scheduler), selector);
		}

		public virtual IEnumerable<IList<TSource>> Chunkify<TSource>(IObservable<TSource> source)
		{
			return source.Collect(() => new List<TSource>(), delegate(IList<TSource> lst, TSource x)
			{
				lst.Add(x);
				return lst;
			}, (IList<TSource> _) => new List<TSource>());
		}

		public virtual IEnumerable<TResult> Collect<TSource, TResult>(IObservable<TSource> source, Func<TResult> newCollector, Func<TResult, TSource, TResult> merge)
		{
			return QueryLanguage.Collect_<TSource, TResult>(source, newCollector, merge, (TResult _) => newCollector());
		}

		public virtual IEnumerable<TResult> Collect<TSource, TResult>(IObservable<TSource> source, Func<TResult> getInitialCollector, Func<TResult, TSource, TResult> merge, Func<TResult, TResult> getNewCollector)
		{
			return QueryLanguage.Collect_<TSource, TResult>(source, getInitialCollector, merge, getNewCollector);
		}

		private static IEnumerable<TResult> Collect_<TSource, TResult>(IObservable<TSource> source, Func<TResult> getInitialCollector, Func<TResult, TSource, TResult> merge, Func<TResult, TResult> getNewCollector)
		{
			return new Collect<TSource, TResult>(source, getInitialCollector, merge, getNewCollector);
		}

		public virtual TSource First<TSource>(IObservable<TSource> source)
		{
			return QueryLanguage.FirstOrDefaultInternal<TSource>(source, true);
		}

		public virtual TSource First<TSource>(IObservable<TSource> source, Func<TSource, bool> predicate)
		{
			return this.First<TSource>(this.Where<TSource>(source, predicate));
		}

		public virtual TSource FirstOrDefault<TSource>(IObservable<TSource> source)
		{
			return QueryLanguage.FirstOrDefaultInternal<TSource>(source, false);
		}

		public virtual TSource FirstOrDefault<TSource>(IObservable<TSource> source, Func<TSource, bool> predicate)
		{
			return this.FirstOrDefault<TSource>(this.Where<TSource>(source, predicate));
		}

		private static TSource FirstOrDefaultInternal<TSource>(IObservable<TSource> source, bool throwOnEmpty)
		{
			TSource value;
			using (FirstBlocking<TSource> firstBlocking = new FirstBlocking<TSource>())
			{
				using (source.Subscribe(firstBlocking))
				{
					firstBlocking.Wait();
				}
				firstBlocking._error.ThrowIfNotNull();
				if (throwOnEmpty && !firstBlocking._hasValue)
				{
					throw new InvalidOperationException(Strings_Linq.NO_ELEMENTS);
				}
				value = firstBlocking._value;
			}
			return value;
		}

		public virtual void ForEach<TSource>(IObservable<TSource> source, Action<TSource> onNext)
		{
			using (QueryLanguage.WaitAndSetOnce evt = new QueryLanguage.WaitAndSetOnce())
			{
				ForEach<TSource>.Observer observer = new ForEach<TSource>.Observer(onNext, delegate
				{
					evt.Set();
				});
				using (source.SubscribeSafe(observer))
				{
					evt.WaitOne();
				}
				observer.Error.ThrowIfNotNull();
			}
		}

		public virtual void ForEach<TSource>(IObservable<TSource> source, Action<TSource, int> onNext)
		{
			using (QueryLanguage.WaitAndSetOnce evt = new QueryLanguage.WaitAndSetOnce())
			{
				ForEach<TSource>.ObserverIndexed observerIndexed = new ForEach<TSource>.ObserverIndexed(onNext, delegate
				{
					evt.Set();
				});
				using (source.SubscribeSafe(observerIndexed))
				{
					evt.WaitOne();
				}
				observerIndexed.Error.ThrowIfNotNull();
			}
		}

		public virtual IEnumerator<TSource> GetEnumerator<TSource>(IObservable<TSource> source)
		{
			return new GetEnumerator<TSource>().Run(source);
		}

		public virtual TSource Last<TSource>(IObservable<TSource> source)
		{
			return QueryLanguage.LastOrDefaultInternal<TSource>(source, true);
		}

		public virtual TSource Last<TSource>(IObservable<TSource> source, Func<TSource, bool> predicate)
		{
			return this.Last<TSource>(this.Where<TSource>(source, predicate));
		}

		public virtual TSource LastOrDefault<TSource>(IObservable<TSource> source)
		{
			return QueryLanguage.LastOrDefaultInternal<TSource>(source, false);
		}

		public virtual TSource LastOrDefault<TSource>(IObservable<TSource> source, Func<TSource, bool> predicate)
		{
			return this.LastOrDefault<TSource>(this.Where<TSource>(source, predicate));
		}

		private static TSource LastOrDefaultInternal<TSource>(IObservable<TSource> source, bool throwOnEmpty)
		{
			TSource value;
			using (LastBlocking<TSource> lastBlocking = new LastBlocking<TSource>())
			{
				using (source.Subscribe(lastBlocking))
				{
					lastBlocking.Wait();
				}
				lastBlocking._error.ThrowIfNotNull();
				if (throwOnEmpty && !lastBlocking._hasValue)
				{
					throw new InvalidOperationException(Strings_Linq.NO_ELEMENTS);
				}
				value = lastBlocking._value;
			}
			return value;
		}

		public virtual IEnumerable<TSource> Latest<TSource>(IObservable<TSource> source)
		{
			return new Latest<TSource>(source);
		}

		public virtual IEnumerable<TSource> MostRecent<TSource>(IObservable<TSource> source, TSource initialValue)
		{
			return new MostRecent<TSource>(source, initialValue);
		}

		public virtual IEnumerable<TSource> Next<TSource>(IObservable<TSource> source)
		{
			return new Next<TSource>(source);
		}

		public virtual TSource Single<TSource>(IObservable<TSource> source)
		{
			return QueryLanguage.SingleOrDefaultInternal<TSource>(source, true);
		}

		public virtual TSource Single<TSource>(IObservable<TSource> source, Func<TSource, bool> predicate)
		{
			return this.Single<TSource>(this.Where<TSource>(source, predicate));
		}

		public virtual TSource SingleOrDefault<TSource>(IObservable<TSource> source)
		{
			return QueryLanguage.SingleOrDefaultInternal<TSource>(source, false);
		}

		public virtual TSource SingleOrDefault<TSource>(IObservable<TSource> source, Func<TSource, bool> predicate)
		{
			return this.SingleOrDefault<TSource>(this.Where<TSource>(source, predicate));
		}

		private static TSource SingleOrDefaultInternal<TSource>(IObservable<TSource> source, bool throwOnEmpty)
		{
			TSource value = default(TSource);
			bool seenValue = false;
			Exception ex = null;
			using (QueryLanguage.WaitAndSetOnce evt = new QueryLanguage.WaitAndSetOnce())
			{
				using (source.Subscribe(new AnonymousObserver<TSource>(delegate(TSource v)
				{
					if (seenValue)
					{
						ex = new InvalidOperationException(Strings_Linq.MORE_THAN_ONE_ELEMENT);
						evt.Set();
					}
					value = v;
					seenValue = true;
				}, delegate(Exception e)
				{
					ex = e;
					evt.Set();
				}, delegate
				{
					evt.Set();
				})))
				{
					evt.WaitOne();
				}
			}
			ex.ThrowIfNotNull();
			if (throwOnEmpty && !seenValue)
			{
				throw new InvalidOperationException(Strings_Linq.NO_ELEMENTS);
			}
			return value;
		}

		public virtual TSource Wait<TSource>(IObservable<TSource> source)
		{
			return QueryLanguage.LastOrDefaultInternal<TSource>(source, true);
		}

		public virtual IObservable<TSource> ObserveOn<TSource>(IObservable<TSource> source, IScheduler scheduler)
		{
			return Synchronization.ObserveOn<TSource>(source, scheduler);
		}

		public virtual IObservable<TSource> ObserveOn<TSource>(IObservable<TSource> source, SynchronizationContext context)
		{
			return Synchronization.ObserveOn<TSource>(source, context);
		}

		public virtual IObservable<TSource> SubscribeOn<TSource>(IObservable<TSource> source, IScheduler scheduler)
		{
			return Synchronization.SubscribeOn<TSource>(source, scheduler);
		}

		public virtual IObservable<TSource> SubscribeOn<TSource>(IObservable<TSource> source, SynchronizationContext context)
		{
			return Synchronization.SubscribeOn<TSource>(source, context);
		}

		public virtual IObservable<TSource> Synchronize<TSource>(IObservable<TSource> source)
		{
			return Synchronization.Synchronize<TSource>(source);
		}

		public virtual IObservable<TSource> Synchronize<TSource>(IObservable<TSource> source, object gate)
		{
			return Synchronization.Synchronize<TSource>(source, gate);
		}

		public virtual IDisposable Subscribe<TSource>(IEnumerable<TSource> source, IObserver<TSource> observer)
		{
			return QueryLanguage.Subscribe_<TSource>(source, observer, SchedulerDefaults.Iteration);
		}

		public virtual IDisposable Subscribe<TSource>(IEnumerable<TSource> source, IObserver<TSource> observer, IScheduler scheduler)
		{
			return QueryLanguage.Subscribe_<TSource>(source, observer, scheduler);
		}

		private static IDisposable Subscribe_<TSource>(IEnumerable<TSource> source, IObserver<TSource> observer, object scheduler)
		{
			ISchedulerLongRunning schedulerLongRunning = scheduler.AsLongRunning();
			if (schedulerLongRunning != null)
			{
				return new ToObservableLongRunning<TSource>(source, schedulerLongRunning).Subscribe(observer);
			}
			return new ToObservableRecursive<TSource>(source, scheduler).Subscribe(observer);
		}

		public virtual IEnumerable<TSource> ToEnumerable<TSource>(IObservable<TSource> source)
		{
			return new AnonymousEnumerable<TSource>(() => source.GetEnumerator<TSource>());
		}

		public virtual IEventSource<Unit> ToEvent(IObservable<Unit> source)
		{
			return new EventSource<Unit>(source, delegate(Action<Unit> h, Unit _)
			{
				h(Unit.Default);
			});
		}

		public virtual IEventSource<TSource> ToEvent<TSource>(IObservable<TSource> source)
		{
			return new EventSource<TSource>(source, delegate(Action<TSource> h, TSource value)
			{
				h(value);
			});
		}

		public virtual GInterface3<T> ToEventPattern<T>(IObservable<EventPattern<T>> source)
		{
			return new EventPatternSource<T>(source, delegate(Action<object, T> h, EventPattern<object, T> evt)
			{
				h(evt.Sender, evt.EventArgs);
			});
		}

		public virtual IObservable<TSource> ToObservable<TSource>(IEnumerable<TSource> source)
		{
			return QueryLanguage.ToObservable_<TSource>(source, SchedulerDefaults.Iteration);
		}

		public virtual IObservable<TSource> ToObservable<TSource>(IEnumerable<TSource> source, IScheduler scheduler)
		{
			return QueryLanguage.ToObservable_<TSource>(source, scheduler);
		}

		private static IObservable<TSource> ToObservable_<TSource>(IEnumerable<TSource> source, object scheduler)
		{
			ISchedulerLongRunning schedulerLongRunning = scheduler.AsLongRunning();
			if (schedulerLongRunning != null)
			{
				return new ToObservableLongRunning<TSource>(source, schedulerLongRunning);
			}
			return new ToObservableRecursive<TSource>(source, scheduler);
		}

		public virtual IObservable<TSource> Create<TSource>(Func<IObserver<TSource>, IDisposable> subscribe)
		{
			return new QueryLanguage.CreateWithDisposableObservable<TSource>(subscribe);
		}

		public virtual IObservable<TSource> Create<TSource>(Func<IObserver<TSource>, Action> subscribe)
		{
			return new QueryLanguage.CreateWithActionDisposable<TSource>(subscribe);
		}

		public virtual IObservable<TResult> Create<TResult>(Func<IObserver<TResult>, CancellationToken, Task> subscribeAsync)
		{
			return new QueryLanguage.CreateWithTaskTokenObservable<TResult>(subscribeAsync);
		}

		public virtual IObservable<TResult> Create<TResult>(Func<IObserver<TResult>, Task> subscribeAsync)
		{
			return this.Create<TResult>((IObserver<TResult> observer, CancellationToken token) => subscribeAsync(observer));
		}

		public virtual IObservable<TResult> Create<TResult>(Func<IObserver<TResult>, CancellationToken, Task<IDisposable>> subscribeAsync)
		{
			return new QueryLanguage.CreateWithTaskDisposable<TResult>(subscribeAsync);
		}

		public virtual IObservable<TResult> Create<TResult>(Func<IObserver<TResult>, Task<IDisposable>> subscribeAsync)
		{
			return this.Create<TResult>((IObserver<TResult> observer, CancellationToken token) => subscribeAsync(observer));
		}

		public virtual IObservable<TResult> Create<TResult>(Func<IObserver<TResult>, CancellationToken, Task<Action>> subscribeAsync)
		{
			return new QueryLanguage.CreateWithTaskActionObservable<TResult>(subscribeAsync);
		}

		public virtual IObservable<TResult> Create<TResult>(Func<IObserver<TResult>, Task<Action>> subscribeAsync)
		{
			return this.Create<TResult>((IObserver<TResult> observer, CancellationToken token) => subscribeAsync(observer));
		}

		public virtual IObservable<TValue> Defer<TValue>(Func<IObservable<TValue>> observableFactory)
		{
			return new Defer<TValue>(observableFactory);
		}

		public virtual IObservable<TValue> Defer<TValue>(Func<Task<IObservable<TValue>>> observableFactoryAsync)
		{
			return this.Defer<TValue>(() => this.StartAsync<IObservable<TValue>>(observableFactoryAsync).Merge<TValue>());
		}

		public virtual IObservable<TValue> Defer<TValue>(Func<CancellationToken, Task<IObservable<TValue>>> observableFactoryAsync)
		{
			return this.Defer<TValue>(() => this.StartAsync<IObservable<TValue>>(observableFactoryAsync).Merge<TValue>());
		}

		public virtual IObservable<TResult> Empty<TResult>()
		{
			return EmptyDirect<TResult>.Instance;
		}

		public virtual IObservable<TResult> Empty<TResult>(IScheduler scheduler)
		{
			return new Empty<TResult>(scheduler);
		}

		public virtual IObservable<TResult> Generate<TState, TResult>(TState initialState, Func<TState, bool> condition, Func<TState, TState> iterate, Func<TState, TResult> resultSelector)
		{
			return new Generate<TState, TResult>.NoTime(initialState, condition, iterate, resultSelector, SchedulerDefaults.Iteration);
		}

		public virtual IObservable<TResult> Generate<TState, TResult>(TState initialState, Func<TState, bool> condition, Func<TState, TState> iterate, Func<TState, TResult> resultSelector, IScheduler scheduler)
		{
			return new Generate<TState, TResult>.NoTime(initialState, condition, iterate, resultSelector, scheduler);
		}

		public virtual IObservable<TResult> Never<TResult>()
		{
			return Never<TResult>.Default;
		}

		public virtual IObservable<int> Range(int start, int count)
		{
			return QueryLanguage.Range_(start, count, SchedulerDefaults.Iteration);
		}

		public virtual IObservable<int> Range(int start, int count, IScheduler scheduler)
		{
			return QueryLanguage.Range_(start, count, scheduler);
		}

		private static IObservable<int> Range_(int start, int count, object scheduler)
		{
			ISchedulerLongRunning schedulerLongRunning = scheduler.AsLongRunning();
			if (schedulerLongRunning != null)
			{
				return new RangeLongRunning(start, count, schedulerLongRunning);
			}
			return new RangeRecursive(start, count, scheduler);
		}

		public virtual IObservable<TResult> Repeat<TResult>(TResult value)
		{
			return this.Repeat_<TResult>(value, SchedulerDefaults.Iteration);
		}

		public virtual IObservable<TResult> Repeat<TResult>(TResult value, IScheduler scheduler)
		{
			return this.Repeat_<TResult>(value, scheduler);
		}

		private IObservable<TResult> Repeat_<TResult>(TResult value, IScheduler scheduler)
		{
			ISchedulerLongRunning schedulerLongRunning = scheduler.AsLongRunning();
			if (schedulerLongRunning != null)
			{
				return new Repeat<TResult>.ForeverLongRunning(value, schedulerLongRunning);
			}
			return new Repeat<TResult>.ForeverRecursive(value, scheduler);
		}

		public virtual IObservable<TResult> Repeat<TResult>(TResult value, int repeatCount)
		{
			return this.Repeat_<TResult>(value, repeatCount, SchedulerDefaults.Iteration);
		}

		public virtual IObservable<TResult> Repeat<TResult>(TResult value, int repeatCount, IScheduler scheduler)
		{
			return this.Repeat_<TResult>(value, repeatCount, scheduler);
		}

		private IObservable<TResult> Repeat_<TResult>(TResult value, int repeatCount, IScheduler scheduler)
		{
			ISchedulerLongRunning schedulerLongRunning = scheduler.AsLongRunning();
			if (schedulerLongRunning != null)
			{
				return new Repeat<TResult>.CountLongRunning(value, repeatCount, schedulerLongRunning);
			}
			return new Repeat<TResult>.CountRecursive(value, repeatCount, scheduler);
		}

		public virtual IObservable<TResult> Return<TResult>(TResult value)
		{
			return this.Return<TResult>(value, SchedulerDefaults.ConstantTimeOperations);
		}

		public virtual IObservable<TResult> Return<TResult>(TResult value, IScheduler scheduler)
		{
			if (scheduler == ImmediateScheduler.Instance)
			{
				return new ReturnImmediate<TResult>(value);
			}
			return new Return<TResult>(value, scheduler);
		}

		public virtual IObservable<TResult> Throw<TResult>(Exception exception)
		{
			return this.Throw<TResult>(exception, SchedulerDefaults.ConstantTimeOperations);
		}

		public virtual IObservable<TResult> Throw<TResult>(Exception exception, IScheduler scheduler)
		{
			if (scheduler == ImmediateScheduler.Instance)
			{
				return new ThrowImmediate<TResult>(exception);
			}
			return new Throw<TResult>(exception, scheduler);
		}

		public virtual IObservable<TSource> Using<TSource, T>(Func<T> resourceFactory, Func<T, IObservable<TSource>> observableFactory) where T : IDisposable
		{
			return new Using<TSource, T>(resourceFactory, observableFactory);
		}

		public virtual IObservable<TSource> Using<TSource, T>(Func<CancellationToken, Task<T>> resourceFactoryAsync, Func<T, CancellationToken, Task<IObservable<TSource>>> observableFactoryAsync) where T : IDisposable
		{
			Func<T, IObservable<TSource>> <>9__2;
			return Observable.FromAsync<T>(resourceFactoryAsync).SelectMany(delegate(T resource)
			{
				Func<T> func = () => resource;
				Func<T, IObservable<TSource>> func2;
				if ((func2 = <>9__2) == null)
				{
					func2 = (<>9__2 = (T resource_) => Observable.FromAsync<IObservable<TSource>>((CancellationToken ct) => observableFactoryAsync(resource_, ct)).Merge<TSource>());
				}
				return Observable.Using<TSource, T>(func, func2);
			});
		}

		public virtual IObservable<EventPattern<object>> FromEventPattern(Action<EventHandler> addHandler, Action<EventHandler> removeHandler)
		{
			return QueryLanguage.FromEventPattern_(addHandler, removeHandler, QueryLanguage.GetSchedulerForCurrentContext());
		}

		public virtual IObservable<EventPattern<object>> FromEventPattern(Action<EventHandler> addHandler, Action<EventHandler> removeHandler, IScheduler scheduler)
		{
			return QueryLanguage.FromEventPattern_(addHandler, removeHandler, scheduler);
		}

		private static IObservable<EventPattern<object>> FromEventPattern_(Action<EventHandler> addHandler, Action<EventHandler> removeHandler, object scheduler)
		{
			return new FromEventPattern.Impl<EventHandler, object>((EventHandler<object> e) => new EventHandler(e.Invoke), addHandler, removeHandler, scheduler);
		}

		public virtual IObservable<EventPattern<U>> FromEventPattern<T, U>(Action<T> addHandler, Action<T> removeHandler)
		{
			return QueryLanguage.FromEventPattern_<T, U>(addHandler, removeHandler, QueryLanguage.GetSchedulerForCurrentContext());
		}

		public virtual IObservable<EventPattern<U>> FromEventPattern<T, U>(Action<T> addHandler, Action<T> removeHandler, IScheduler scheduler)
		{
			return QueryLanguage.FromEventPattern_<T, U>(addHandler, removeHandler, scheduler);
		}

		private static IObservable<EventPattern<U>> FromEventPattern_<T, U>(Action<T> addHandler, Action<T> removeHandler, object scheduler)
		{
			return new FromEventPattern.Impl<T, U>(addHandler, removeHandler, scheduler);
		}

		public virtual IObservable<EventPattern<U>> FromEventPattern<T, U>(Func<EventHandler<U>, T> conversion, Action<T> addHandler, Action<T> removeHandler)
		{
			return QueryLanguage.FromEventPattern_<T, U>(conversion, addHandler, removeHandler, QueryLanguage.GetSchedulerForCurrentContext());
		}

		public virtual IObservable<EventPattern<U>> FromEventPattern<T, U>(Func<EventHandler<U>, T> conversion, Action<T> addHandler, Action<T> removeHandler, IScheduler scheduler)
		{
			return QueryLanguage.FromEventPattern_<T, U>(conversion, addHandler, removeHandler, scheduler);
		}

		private static IObservable<EventPattern<U>> FromEventPattern_<T, U>(Func<EventHandler<U>, T> conversion, Action<T> addHandler, Action<T> removeHandler, object scheduler)
		{
			return new FromEventPattern.Impl<T, U>(conversion, addHandler, removeHandler, scheduler);
		}

		public virtual IObservable<EventPattern<TSender, U>> FromEventPattern<T, TSender, U>(Action<T> addHandler, Action<T> removeHandler)
		{
			return QueryLanguage.FromEventPattern_<T, TSender, U>(addHandler, removeHandler, QueryLanguage.GetSchedulerForCurrentContext());
		}

		public virtual IObservable<EventPattern<TSender, U>> FromEventPattern<T, TSender, U>(Action<T> addHandler, Action<T> removeHandler, IScheduler scheduler)
		{
			return QueryLanguage.FromEventPattern_<T, TSender, U>(addHandler, removeHandler, scheduler);
		}

		private static IObservable<EventPattern<TSender, U>> FromEventPattern_<T, TSender, U>(Action<T> addHandler, Action<T> removeHandler, object scheduler)
		{
			return new FromEventPattern.Impl<T, TSender, U>(addHandler, removeHandler, scheduler);
		}

		public virtual IObservable<EventPattern<T>> FromEventPattern<T>(Action<EventHandler<T>> addHandler, Action<EventHandler<T>> removeHandler)
		{
			return QueryLanguage.FromEventPattern_<T>(addHandler, removeHandler, QueryLanguage.GetSchedulerForCurrentContext());
		}

		public virtual IObservable<EventPattern<T>> FromEventPattern<T>(Action<EventHandler<T>> addHandler, Action<EventHandler<T>> removeHandler, IScheduler scheduler)
		{
			return QueryLanguage.FromEventPattern_<T>(addHandler, removeHandler, scheduler);
		}

		private static IObservable<EventPattern<T>> FromEventPattern_<T>(Action<EventHandler<T>> addHandler, Action<EventHandler<T>> removeHandler, object scheduler)
		{
			return new FromEventPattern.Impl<EventHandler<T>, T>((EventHandler<T> handler) => handler, addHandler, removeHandler, scheduler);
		}

		public virtual IObservable<EventPattern<object>> FromEventPattern(object target, string eventName)
		{
			return QueryLanguage.FromEventPattern_(target, eventName, QueryLanguage.GetSchedulerForCurrentContext());
		}

		public virtual IObservable<EventPattern<object>> FromEventPattern(object target, string eventName, IScheduler scheduler)
		{
			return QueryLanguage.FromEventPattern_(target, eventName, scheduler);
		}

		private static IObservable<EventPattern<object>> FromEventPattern_(object target, object eventName, object scheduler)
		{
			return QueryLanguage.FromEventPattern_<object, object, EventPattern<object>>(target.GetType(), target, eventName, (object sender, object args) => new EventPattern<object>(sender, args), scheduler);
		}

		public virtual IObservable<EventPattern<T>> FromEventPattern<T>(object target, string eventName)
		{
			return QueryLanguage.FromEventPattern_<T>(target, eventName, QueryLanguage.GetSchedulerForCurrentContext());
		}

		public virtual IObservable<EventPattern<T>> FromEventPattern<T>(object target, string eventName, IScheduler scheduler)
		{
			return QueryLanguage.FromEventPattern_<T>(target, eventName, scheduler);
		}

		private static IObservable<EventPattern<T>> FromEventPattern_<T>(object target, object eventName, object scheduler)
		{
			return QueryLanguage.FromEventPattern_<object, T, EventPattern<T>>(target.GetType(), target, eventName, (object sender, T args) => new EventPattern<T>(sender, args), scheduler);
		}

		public virtual IObservable<EventPattern<TSender, T>> FromEventPattern<TSender, T>(object target, string eventName)
		{
			return QueryLanguage.FromEventPattern_<TSender, T>(target, eventName, QueryLanguage.GetSchedulerForCurrentContext());
		}

		public virtual IObservable<EventPattern<TSender, T>> FromEventPattern<TSender, T>(object target, string eventName, IScheduler scheduler)
		{
			return QueryLanguage.FromEventPattern_<TSender, T>(target, eventName, scheduler);
		}

		private static IObservable<EventPattern<TSender, T>> FromEventPattern_<TSender, T>(object target, object eventName, object scheduler)
		{
			return QueryLanguage.FromEventPattern_<TSender, T, EventPattern<TSender, T>>(target.GetType(), target, eventName, (TSender sender, T args) => new EventPattern<TSender, T>(sender, args), scheduler);
		}

		public virtual IObservable<EventPattern<object>> FromEventPattern(Type type, string eventName)
		{
			return QueryLanguage.FromEventPattern_(type, eventName, QueryLanguage.GetSchedulerForCurrentContext());
		}

		public virtual IObservable<EventPattern<object>> FromEventPattern(Type type, string eventName, IScheduler scheduler)
		{
			return QueryLanguage.FromEventPattern_(type, eventName, scheduler);
		}

		private static IObservable<EventPattern<object>> FromEventPattern_(Type type, object eventName, object scheduler)
		{
			return QueryLanguage.FromEventPattern_<object, object, EventPattern<object>>(type, null, eventName, (object sender, object args) => new EventPattern<object>(sender, args), scheduler);
		}

		public virtual IObservable<EventPattern<T>> FromEventPattern<T>(Type type, string eventName)
		{
			return QueryLanguage.FromEventPattern_<T>(type, eventName, QueryLanguage.GetSchedulerForCurrentContext());
		}

		public virtual IObservable<EventPattern<T>> FromEventPattern<T>(Type type, string eventName, IScheduler scheduler)
		{
			return QueryLanguage.FromEventPattern_<T>(type, eventName, scheduler);
		}

		private static IObservable<EventPattern<T>> FromEventPattern_<T>(Type type, object eventName, object scheduler)
		{
			return QueryLanguage.FromEventPattern_<object, T, EventPattern<T>>(type, null, eventName, (object sender, T args) => new EventPattern<T>(sender, args), scheduler);
		}

		public virtual IObservable<EventPattern<TSender, T>> FromEventPattern<TSender, T>(Type type, string eventName)
		{
			return QueryLanguage.FromEventPattern_<TSender, T>(type, eventName, QueryLanguage.GetSchedulerForCurrentContext());
		}

		public virtual IObservable<EventPattern<TSender, T>> FromEventPattern<TSender, T>(Type type, string eventName, IScheduler scheduler)
		{
			return QueryLanguage.FromEventPattern_<TSender, T>(type, eventName, scheduler);
		}

		private static IObservable<EventPattern<TSender, T>> FromEventPattern_<TSender, T>(Type type, object eventName, object scheduler)
		{
			return QueryLanguage.FromEventPattern_<TSender, T, EventPattern<TSender, T>>(type, null, eventName, (TSender sender, T args) => new EventPattern<TSender, T>(sender, args), scheduler);
		}

		private static IObservable<TResult> FromEventPattern_<TSender, T, TResult>(Type targetType, object target, object eventName, Func<TSender, T, TResult> getResult, object scheduler)
		{
			MethodInfo methodInfo;
			MethodInfo methodInfo2;
			Type type;
			bool flag;
			ReflectionUtils.GetEventMethods<TSender, T>(targetType, target, eventName, out methodInfo, out methodInfo2, out type, out flag);
			if (flag)
			{
				return new FromEventPattern.Handler<TSender, T, TResult>(target, type, methodInfo, methodInfo2, getResult, true, scheduler);
			}
			return new FromEventPattern.Handler<TSender, T, TResult>(target, type, methodInfo, methodInfo2, getResult, false, scheduler);
		}

		public virtual IObservable<U> FromEvent<T, U>(Func<Action<U>, T> conversion, Action<T> addHandler, Action<T> removeHandler)
		{
			return QueryLanguage.FromEvent_<T, U>(conversion, addHandler, removeHandler, QueryLanguage.GetSchedulerForCurrentContext());
		}

		public virtual IObservable<U> FromEvent<T, U>(Func<Action<U>, T> conversion, Action<T> addHandler, Action<T> removeHandler, IScheduler scheduler)
		{
			return QueryLanguage.FromEvent_<T, U>(conversion, addHandler, removeHandler, scheduler);
		}

		private static IObservable<U> FromEvent_<T, U>(Func<Action<U>, T> conversion, Action<T> addHandler, Action<T> removeHandler, object scheduler)
		{
			return new FromEvent<T, U>(conversion, addHandler, removeHandler, scheduler);
		}

		public virtual IObservable<U> FromEvent<T, U>(Action<T> addHandler, Action<T> removeHandler)
		{
			return QueryLanguage.FromEvent_<T, U>(addHandler, removeHandler, QueryLanguage.GetSchedulerForCurrentContext());
		}

		public virtual IObservable<U> FromEvent<T, U>(Action<T> addHandler, Action<T> removeHandler, IScheduler scheduler)
		{
			return QueryLanguage.FromEvent_<T, U>(addHandler, removeHandler, scheduler);
		}

		private static IObservable<U> FromEvent_<T, U>(Action<T> addHandler, Action<T> removeHandler, object scheduler)
		{
			return new FromEvent<T, U>(addHandler, removeHandler, scheduler);
		}

		public virtual IObservable<T> FromEvent<T>(Action<Action<T>> addHandler, Action<Action<T>> removeHandler)
		{
			return QueryLanguage.FromEvent_<T>(addHandler, removeHandler, QueryLanguage.GetSchedulerForCurrentContext());
		}

		public virtual IObservable<T> FromEvent<T>(Action<Action<T>> addHandler, Action<Action<T>> removeHandler, IScheduler scheduler)
		{
			return QueryLanguage.FromEvent_<T>(addHandler, removeHandler, scheduler);
		}

		private static IObservable<T> FromEvent_<T>(Action<Action<T>> addHandler, Action<Action<T>> removeHandler, object scheduler)
		{
			return new FromEvent<Action<T>, T>((Action<T> h) => h, addHandler, removeHandler, scheduler);
		}

		public virtual IObservable<Unit> FromEvent(Action<Action> addHandler, Action<Action> removeHandler)
		{
			return QueryLanguage.FromEvent_(addHandler, removeHandler, QueryLanguage.GetSchedulerForCurrentContext());
		}

		public virtual IObservable<Unit> FromEvent(Action<Action> addHandler, Action<Action> removeHandler, IScheduler scheduler)
		{
			return QueryLanguage.FromEvent_(addHandler, removeHandler, scheduler);
		}

		private static IObservable<Unit> FromEvent_(Action<Action> addHandler, Action<Action> removeHandler, object scheduler)
		{
			return new FromEvent<Action, Unit>((Action<Unit> h) => delegate
			{
				h(default(Unit));
			}, addHandler, removeHandler, scheduler);
		}

		private static IScheduler GetSchedulerForCurrentContext()
		{
			SynchronizationContext synchronizationContext = SynchronizationContext.Current;
			if (synchronizationContext != null)
			{
				return new SynchronizationContextScheduler(synchronizationContext, false);
			}
			return SchedulerDefaults.ConstantTimeOperations;
		}

		public virtual Task ForEachAsync<TSource>(IObservable<TSource> source, Action<TSource> onNext)
		{
			return QueryLanguage.ForEachAsync_<TSource>(source, onNext, CancellationToken.None);
		}

		public virtual Task ForEachAsync<TSource>(IObservable<TSource> source, Action<TSource> onNext, CancellationToken cancellationToken)
		{
			return QueryLanguage.ForEachAsync_<TSource>(source, onNext, cancellationToken);
		}

		public virtual Task ForEachAsync<TSource>(IObservable<TSource> source, Action<TSource, int> onNext)
		{
			int i = 0;
			return QueryLanguage.ForEachAsync_<TSource>(source, delegate(TSource x)
			{
				Action<TSource, int> onNext2 = onNext;
				int j = i;
				i = checked(j + 1);
				onNext2(x, j);
			}, CancellationToken.None);
		}

		public virtual Task ForEachAsync<TSource>(IObservable<TSource> source, Action<TSource, int> onNext, CancellationToken cancellationToken)
		{
			int i = 0;
			return QueryLanguage.ForEachAsync_<TSource>(source, delegate(TSource x)
			{
				Action<TSource, int> onNext2 = onNext;
				int j = i;
				i = checked(j + 1);
				onNext2(x, j);
			}, cancellationToken);
		}

		private static Task ForEachAsync_<TSource>(IObservable<TSource> source, Action<TSource> onNext, CancellationToken cancellationToken)
		{
			TaskCompletionSource<object> tcs = new TaskCompletionSource<object>();
			SingleAssignmentDisposable subscription = new SingleAssignmentDisposable();
			CancellationTokenRegistration ctr = default(CancellationTokenRegistration);
			if (cancellationToken.CanBeCanceled)
			{
				ctr = cancellationToken.Register(delegate
				{
					tcs.TrySetCanceled(cancellationToken);
					subscription.Dispose();
				});
			}
			if (!cancellationToken.IsCancellationRequested)
			{
				Action<Action> dispose = delegate(Action action)
				{
					try
					{
						ctr.Dispose();
						subscription.Dispose();
					}
					catch (Exception ex2)
					{
						tcs.TrySetException(ex2);
						return;
					}
					action();
				};
				Action <>9__7;
				AnonymousObserver<TSource> anonymousObserver = new AnonymousObserver<TSource>(delegate(TSource x)
				{
					if (!subscription.IsDisposed)
					{
						try
						{
							onNext(x);
						}
						catch (Exception ex3)
						{
							Exception ex4 = ex3;
							Exception exception2 = ex4;
							dispose(delegate
							{
								tcs.TrySetException(exception2);
							});
						}
					}
				}, delegate(Exception exception)
				{
					dispose(delegate
					{
						tcs.TrySetException(exception);
					});
				}, delegate
				{
					Action<Action> dispose2 = dispose;
					Action action;
					if ((action = <>9__7) == null)
					{
						action = (<>9__7 = delegate
						{
							tcs.TrySetResult(null);
						});
					}
					dispose2(action);
				});
				try
				{
					subscription.Disposable = source.Subscribe(anonymousObserver);
				}
				catch (Exception ex)
				{
					tcs.TrySetException(ex);
				}
			}
			return tcs.Task;
		}

		public virtual IObservable<TResult> Case<TValue, TResult>(Func<TValue> selector, IDictionary<TValue, IObservable<TResult>> sources)
		{
			return this.Case<TValue, TResult>(selector, sources, this.Empty<TResult>());
		}

		public virtual IObservable<TResult> Case<TValue, TResult>(Func<TValue> selector, IDictionary<TValue, IObservable<TResult>> sources, IScheduler scheduler)
		{
			return this.Case<TValue, TResult>(selector, sources, this.Empty<TResult>(scheduler));
		}

		public virtual IObservable<TResult> Case<TValue, TResult>(Func<TValue> selector, IDictionary<TValue, IObservable<TResult>> sources, IObservable<TResult> defaultSource)
		{
			return new Case<TValue, TResult>(selector, sources, defaultSource);
		}

		public virtual IObservable<TSource> DoWhile<TSource>(IObservable<TSource> source, Func<bool> condition)
		{
			return new DoWhile<TSource>(source, condition);
		}

		public virtual IObservable<TResult> For<TSource, TResult>(IEnumerable<TSource> source, Func<TSource, IObservable<TResult>> resultSelector)
		{
			return new For<TSource, TResult>(source, resultSelector);
		}

		public virtual IObservable<TResult> If<TResult>(Func<bool> condition, IObservable<TResult> thenSource)
		{
			return this.If<TResult>(condition, thenSource, this.Empty<TResult>());
		}

		public virtual IObservable<TResult> If<TResult>(Func<bool> condition, IObservable<TResult> thenSource, IScheduler scheduler)
		{
			return this.If<TResult>(condition, thenSource, this.Empty<TResult>(scheduler));
		}

		public virtual IObservable<TResult> If<TResult>(Func<bool> condition, IObservable<TResult> thenSource, IObservable<TResult> elseSource)
		{
			return new If<TResult>(condition, thenSource, elseSource);
		}

		public virtual IObservable<TSource> While<TSource>(Func<bool> condition, IObservable<TSource> source)
		{
			return new While<TSource>(condition, source);
		}

		public virtual Pattern<TLeft, TRight> And<TLeft, TRight>(IObservable<TLeft> left, IObservable<TRight> right)
		{
			return new Pattern<TLeft, TRight>(left, right);
		}

		public virtual Plan<TResult> Then<TSource, TResult>(IObservable<TSource> source, Func<TSource, TResult> selector)
		{
			return new Pattern<TSource>(source).Then<TResult>(selector);
		}

		public virtual IObservable<TResult> When<TResult>(params Plan<TResult>[] plans)
		{
			return this.When<TResult>(plans);
		}

		public virtual IObservable<TResult> When<TResult>(IEnumerable<Plan<TResult>> plans)
		{
			return new QueryLanguage.WhenObservable<TResult>(plans);
		}

		public virtual IObservable<TSource> Amb<TSource>(IObservable<TSource> first, IObservable<TSource> second)
		{
			return new Amb<TSource>(first, second);
		}

		public virtual IObservable<TSource> Amb<TSource>(params IObservable<TSource>[] sources)
		{
			return new AmbManyArray<TSource>(sources);
		}

		public virtual IObservable<TSource> Amb<TSource>(IEnumerable<IObservable<TSource>> sources)
		{
			return new AmbManyEnumerable<TSource>(sources);
		}

		public virtual IObservable<IList<TSource>> Buffer<TSource, TBufferClosing>(IObservable<TSource> source, Func<IObservable<TBufferClosing>> bufferClosingSelector)
		{
			return new Buffer<TSource, TBufferClosing>.Selector(source, bufferClosingSelector);
		}

		public virtual IObservable<IList<TSource>> Buffer<TSource, TBufferOpening, TBufferClosing>(IObservable<TSource> source, IObservable<TBufferOpening> bufferOpenings, Func<TBufferOpening, IObservable<TBufferClosing>> bufferClosingSelector)
		{
			return source.Window(bufferOpenings, bufferClosingSelector).SelectMany(new Func<IObservable<TSource>, IObservable<IList<TSource>>>(this.ToList<TSource>));
		}

		public virtual IObservable<IList<TSource>> Buffer<TSource, TBufferBoundary>(IObservable<TSource> source, IObservable<TBufferBoundary> bufferBoundaries)
		{
			return new Buffer<TSource, TBufferBoundary>.Boundaries(source, bufferBoundaries);
		}

		public virtual IObservable<TSource> Catch<TSource, T>(IObservable<TSource> source, Func<T, IObservable<TSource>> handler) where T : Exception
		{
			return new Catch<TSource, T>(source, handler);
		}

		public virtual IObservable<TSource> Catch<TSource>(IObservable<TSource> first, IObservable<TSource> second)
		{
			return QueryLanguage.Catch_<TSource>(new IObservable<TSource>[] { first, second });
		}

		public virtual IObservable<TSource> Catch<TSource>(params IObservable<TSource>[] sources)
		{
			return QueryLanguage.Catch_<TSource>(sources);
		}

		public virtual IObservable<TSource> Catch<TSource>(IEnumerable<IObservable<TSource>> sources)
		{
			return QueryLanguage.Catch_<TSource>(sources);
		}

		private static IObservable<TSource> Catch_<TSource>(IEnumerable<IObservable<TSource>> sources)
		{
			return new Catch<TSource>(sources);
		}

		public virtual IObservable<TResult> CombineLatest<TFirst, TSecond, TResult>(IObservable<TFirst> first, IObservable<TSecond> second, Func<TFirst, TSecond, TResult> resultSelector)
		{
			return new CombineLatest<TFirst, TSecond, TResult>(first, second, resultSelector);
		}

		public virtual IObservable<TResult> CombineLatest<TSource1, TSource2, TSource3, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, Func<TSource1, TSource2, TSource3, TResult> resultSelector)
		{
			return new CombineLatest<TSource1, TSource2, TSource3, TResult>(source1, source2, source3, resultSelector);
		}

		public virtual IObservable<TResult> CombineLatest<TSource1, TSource2, TSource3, TSource4, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, Func<TSource1, TSource2, TSource3, TSource4, TResult> resultSelector)
		{
			return new CombineLatest<TSource1, TSource2, TSource3, TSource4, TResult>(source1, source2, source3, source4, resultSelector);
		}

		public virtual IObservable<TResult> CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TResult> resultSelector)
		{
			return new CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TResult>(source1, source2, source3, source4, source5, resultSelector);
		}

		public virtual IObservable<TResult> CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TResult> resultSelector)
		{
			return new CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TResult>(source1, source2, source3, source4, source5, source6, resultSelector);
		}

		public virtual IObservable<TResult> CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, IObservable<TSource7> source7, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TResult> resultSelector)
		{
			return new CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TResult>(source1, source2, source3, source4, source5, source6, source7, resultSelector);
		}

		public virtual IObservable<TResult> CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, IObservable<TSource7> source7, IObservable<TSource8> source8, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TResult> resultSelector)
		{
			return new CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TResult>(source1, source2, source3, source4, source5, source6, source7, source8, resultSelector);
		}

		public virtual IObservable<TResult> CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, IObservable<TSource7> source7, IObservable<TSource8> source8, IObservable<TSource9> source9, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TResult> resultSelector)
		{
			return new CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TResult>(source1, source2, source3, source4, source5, source6, source7, source8, source9, resultSelector);
		}

		public virtual IObservable<TResult> CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, IObservable<TSource7> source7, IObservable<TSource8> source8, IObservable<TSource9> source9, IObservable<T> source10, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, TResult> resultSelector)
		{
			return new CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, TResult>(source1, source2, source3, source4, source5, source6, source7, source8, source9, source10, resultSelector);
		}

		public virtual IObservable<TResult> CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, IObservable<TSource7> source7, IObservable<TSource8> source8, IObservable<TSource9> source9, IObservable<T> source10, IObservable<U> source11, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, TResult> resultSelector)
		{
			return new CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, TResult>(source1, source2, source3, source4, source5, source6, source7, source8, source9, source10, source11, resultSelector);
		}

		public virtual IObservable<TResult> CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, IObservable<TSource7> source7, IObservable<TSource8> source8, IObservable<TSource9> source9, IObservable<T> source10, IObservable<U> source11, IObservable<V> source12, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, TResult> resultSelector)
		{
			return new CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, TResult>(source1, source2, source3, source4, source5, source6, source7, source8, source9, source10, source11, source12, resultSelector);
		}

		public virtual IObservable<TResult> CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, IObservable<TSource7> source7, IObservable<TSource8> source8, IObservable<TSource9> source9, IObservable<T> source10, IObservable<U> source11, IObservable<V> source12, IObservable<W> source13, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, TResult> resultSelector)
		{
			return new CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, TResult>(source1, source2, source3, source4, source5, source6, source7, source8, source9, source10, source11, source12, source13, resultSelector);
		}

		public virtual IObservable<TResult> CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, IObservable<TSource7> source7, IObservable<TSource8> source8, IObservable<TSource9> source9, IObservable<T> source10, IObservable<U> source11, IObservable<V> source12, IObservable<W> source13, IObservable<X> source14, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, TResult> resultSelector)
		{
			return new CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, TResult>(source1, source2, source3, source4, source5, source6, source7, source8, source9, source10, source11, source12, source13, source14, resultSelector);
		}

		public virtual IObservable<TResult> CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, Y, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, IObservable<TSource7> source7, IObservable<TSource8> source8, IObservable<TSource9> source9, IObservable<T> source10, IObservable<U> source11, IObservable<V> source12, IObservable<W> source13, IObservable<X> source14, IObservable<Y> source15, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, Y, TResult> resultSelector)
		{
			return new CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, Y, TResult>(source1, source2, source3, source4, source5, source6, source7, source8, source9, source10, source11, source12, source13, source14, source15, resultSelector);
		}

		public virtual IObservable<TResult> CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, Y, Z, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, IObservable<TSource7> source7, IObservable<TSource8> source8, IObservable<TSource9> source9, IObservable<T> source10, IObservable<U> source11, IObservable<V> source12, IObservable<W> source13, IObservable<X> source14, IObservable<Y> source15, IObservable<Z> source16, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, Y, Z, TResult> resultSelector)
		{
			return new CombineLatest<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, Y, Z, TResult>(source1, source2, source3, source4, source5, source6, source7, source8, source9, source10, source11, source12, source13, source14, source15, source16, resultSelector);
		}

		public virtual IObservable<TResult> CombineLatest<TSource, TResult>(IEnumerable<IObservable<TSource>> sources, Func<IList<TSource>, TResult> resultSelector)
		{
			return QueryLanguage.CombineLatest_<TSource, TResult>(sources, resultSelector);
		}

		public virtual IObservable<IList<TSource>> CombineLatest<TSource>(IEnumerable<IObservable<TSource>> sources)
		{
			return QueryLanguage.CombineLatest_<TSource, List<TSource>>(sources, (IList<TSource> res) => res.ToList<TSource>());
		}

		public virtual IObservable<IList<TSource>> CombineLatest<TSource>(params IObservable<TSource>[] sources)
		{
			return QueryLanguage.CombineLatest_<TSource, List<TSource>>(sources, (IList<TSource> res) => res.ToList<TSource>());
		}

		private static IObservable<TResult> CombineLatest_<TSource, TResult>(IEnumerable<IObservable<TSource>> sources, Func<IList<TSource>, TResult> resultSelector)
		{
			return new CombineLatest<TSource, TResult>(sources, resultSelector);
		}

		public virtual IObservable<TSource> Concat<TSource>(IObservable<TSource> first, IObservable<TSource> second)
		{
			return QueryLanguage.Concat_<TSource>(new IObservable<TSource>[] { first, second });
		}

		public virtual IObservable<TSource> Concat<TSource>(params IObservable<TSource>[] sources)
		{
			return QueryLanguage.Concat_<TSource>(sources);
		}

		public virtual IObservable<TSource> Concat<TSource>(IEnumerable<IObservable<TSource>> sources)
		{
			return QueryLanguage.Concat_<TSource>(sources);
		}

		private static IObservable<TSource> Concat_<TSource>(IEnumerable<IObservable<TSource>> sources)
		{
			return new Concat<TSource>(sources);
		}

		public virtual IObservable<TSource> Concat<TSource>(IObservable<IObservable<TSource>> sources)
		{
			return this.Concat_<TSource>(sources);
		}

		public virtual IObservable<TSource> Concat<TSource>(IObservable<Task<TSource>> sources)
		{
			return this.Concat_<TSource>(this.Select<Task<TSource>, IObservable<TSource>>(sources, new Func<Task<TSource>, IObservable<TSource>>(TaskObservableExtensions.ToObservable<TSource>)));
		}

		private IObservable<TSource> Concat_<TSource>(IObservable<IObservable<TSource>> sources)
		{
			return new ConcatMany<TSource>(sources);
		}

		public virtual IObservable<TSource> Merge<TSource>(IObservable<IObservable<TSource>> sources)
		{
			return QueryLanguage.Merge_<TSource>(sources);
		}

		public virtual IObservable<TSource> Merge<TSource>(IObservable<Task<TSource>> sources)
		{
			return new Merge<TSource>.Tasks(sources);
		}

		public virtual IObservable<TSource> Merge<TSource>(IObservable<IObservable<TSource>> sources, int maxConcurrent)
		{
			return QueryLanguage.Merge_<TSource>(sources, maxConcurrent);
		}

		public virtual IObservable<TSource> Merge<TSource>(IEnumerable<IObservable<TSource>> sources, int maxConcurrent)
		{
			return QueryLanguage.Merge_<TSource>(sources.ToObservable(SchedulerDefaults.ConstantTimeOperations), maxConcurrent);
		}

		public virtual IObservable<TSource> Merge<TSource>(IEnumerable<IObservable<TSource>> sources, int maxConcurrent, IScheduler scheduler)
		{
			return QueryLanguage.Merge_<TSource>(sources.ToObservable(scheduler), maxConcurrent);
		}

		public virtual IObservable<TSource> Merge<TSource>(IObservable<TSource> first, IObservable<TSource> second)
		{
			return QueryLanguage.Merge_<TSource>(new IObservable<TSource>[] { first, second }.ToObservable(SchedulerDefaults.ConstantTimeOperations));
		}

		public virtual IObservable<TSource> Merge<TSource>(IObservable<TSource> first, IObservable<TSource> second, IScheduler scheduler)
		{
			return QueryLanguage.Merge_<TSource>(new IObservable<TSource>[] { first, second }.ToObservable(scheduler));
		}

		public virtual IObservable<TSource> Merge<TSource>(params IObservable<TSource>[] sources)
		{
			return QueryLanguage.Merge_<TSource>(sources.ToObservable(SchedulerDefaults.ConstantTimeOperations));
		}

		public virtual IObservable<TSource> Merge<TSource>(IScheduler scheduler, params IObservable<TSource>[] sources)
		{
			return QueryLanguage.Merge_<TSource>(sources.ToObservable(scheduler));
		}

		public virtual IObservable<TSource> Merge<TSource>(IEnumerable<IObservable<TSource>> sources)
		{
			return QueryLanguage.Merge_<TSource>(sources.ToObservable(SchedulerDefaults.ConstantTimeOperations));
		}

		public virtual IObservable<TSource> Merge<TSource>(IEnumerable<IObservable<TSource>> sources, IScheduler scheduler)
		{
			return QueryLanguage.Merge_<TSource>(sources.ToObservable(scheduler));
		}

		private static IObservable<TSource> Merge_<TSource>(IObservable<IObservable<TSource>> sources)
		{
			return new Merge<TSource>.Observables(sources);
		}

		private static IObservable<TSource> Merge_<TSource>(IObservable<IObservable<TSource>> sources, int maxConcurrent)
		{
			return new Merge<TSource>.ObservablesMaxConcurrency(sources, maxConcurrent);
		}

		public virtual IObservable<TSource> OnErrorResumeNext<TSource>(IObservable<TSource> first, IObservable<TSource> second)
		{
			return QueryLanguage.OnErrorResumeNext_<TSource>(new IObservable<TSource>[] { first, second });
		}

		public virtual IObservable<TSource> OnErrorResumeNext<TSource>(params IObservable<TSource>[] sources)
		{
			return QueryLanguage.OnErrorResumeNext_<TSource>(sources);
		}

		public virtual IObservable<TSource> OnErrorResumeNext<TSource>(IEnumerable<IObservable<TSource>> sources)
		{
			return QueryLanguage.OnErrorResumeNext_<TSource>(sources);
		}

		private static IObservable<TSource> OnErrorResumeNext_<TSource>(IEnumerable<IObservable<TSource>> sources)
		{
			return new OnErrorResumeNext<TSource>(sources);
		}

		public virtual IObservable<TSource> SkipUntil<TSource, TOther>(IObservable<TSource> source, IObservable<TOther> other)
		{
			return new SkipUntil<TSource, TOther>(source, other);
		}

		public virtual IObservable<TSource> Switch<TSource>(IObservable<IObservable<TSource>> sources)
		{
			return this.Switch_<TSource>(sources);
		}

		public virtual IObservable<TSource> Switch<TSource>(IObservable<Task<TSource>> sources)
		{
			return this.Switch_<TSource>(this.Select<Task<TSource>, IObservable<TSource>>(sources, new Func<Task<TSource>, IObservable<TSource>>(TaskObservableExtensions.ToObservable<TSource>)));
		}

		private IObservable<TSource> Switch_<TSource>(IObservable<IObservable<TSource>> sources)
		{
			return new Switch<TSource>(sources);
		}

		public virtual IObservable<TSource> TakeUntil<TSource, TOther>(IObservable<TSource> source, IObservable<TOther> other)
		{
			return new TakeUntil<TSource, TOther>(source, other);
		}

		public virtual IObservable<TSource> TakeUntil<TSource>(IObservable<TSource> source, Func<TSource, bool> stopPredicate)
		{
			return new TakeUntilPredicate<TSource>(source, stopPredicate);
		}

		public virtual IObservable<IObservable<TSource>> Window<TSource, TWindowClosing>(IObservable<TSource> source, Func<IObservable<TWindowClosing>> windowClosingSelector)
		{
			return new Window<TSource, TWindowClosing>.Selector(source, windowClosingSelector);
		}

		public virtual IObservable<IObservable<TSource>> Window<TSource, TWindowOpening, TWindowClosing>(IObservable<TSource> source, IObservable<TWindowOpening> windowOpenings, Func<TWindowOpening, IObservable<TWindowClosing>> windowClosingSelector)
		{
			return windowOpenings.GroupJoin(source, windowClosingSelector, (TSource _) => Observable.Empty<Unit>(), (TWindowOpening _, IObservable<TSource> window) => window);
		}

		public virtual IObservable<IObservable<TSource>> Window<TSource, TWindowBoundary>(IObservable<TSource> source, IObservable<TWindowBoundary> windowBoundaries)
		{
			return new Window<TSource, TWindowBoundary>.Boundaries(source, windowBoundaries);
		}

		public virtual IObservable<TResult> WithLatestFrom<TFirst, TSecond, TResult>(IObservable<TFirst> first, IObservable<TSecond> second, Func<TFirst, TSecond, TResult> resultSelector)
		{
			return new WithLatestFrom<TFirst, TSecond, TResult>(first, second, resultSelector);
		}

		public virtual IObservable<TResult> Zip<TFirst, TSecond, TResult>(IObservable<TFirst> first, IObservable<TSecond> second, Func<TFirst, TSecond, TResult> resultSelector)
		{
			return new Zip<TFirst, TSecond, TResult>.Observable(first, second, resultSelector);
		}

		public virtual IObservable<TResult> Zip<TSource, TResult>(IEnumerable<IObservable<TSource>> sources, Func<IList<TSource>, TResult> resultSelector)
		{
			return QueryLanguage.Zip_<TSource>(sources).Select(resultSelector);
		}

		public virtual IObservable<IList<TSource>> Zip<TSource>(IEnumerable<IObservable<TSource>> sources)
		{
			return QueryLanguage.Zip_<TSource>(sources);
		}

		public virtual IObservable<IList<TSource>> Zip<TSource>(params IObservable<TSource>[] sources)
		{
			return QueryLanguage.Zip_<TSource>(sources);
		}

		private static IObservable<IList<TSource>> Zip_<TSource>(IEnumerable<IObservable<TSource>> sources)
		{
			return new Zip<TSource>(sources);
		}

		public virtual IObservable<TResult> Zip<TSource1, TSource2, TSource3, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, Func<TSource1, TSource2, TSource3, TResult> resultSelector)
		{
			return new Zip<TSource1, TSource2, TSource3, TResult>(source1, source2, source3, resultSelector);
		}

		public virtual IObservable<TResult> Zip<TSource1, TSource2, TSource3, TSource4, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, Func<TSource1, TSource2, TSource3, TSource4, TResult> resultSelector)
		{
			return new Zip<TSource1, TSource2, TSource3, TSource4, TResult>(source1, source2, source3, source4, resultSelector);
		}

		public virtual IObservable<TResult> Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TResult> resultSelector)
		{
			return new Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TResult>(source1, source2, source3, source4, source5, resultSelector);
		}

		public virtual IObservable<TResult> Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TResult> resultSelector)
		{
			return new Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TResult>(source1, source2, source3, source4, source5, source6, resultSelector);
		}

		public virtual IObservable<TResult> Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, IObservable<TSource7> source7, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TResult> resultSelector)
		{
			return new Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TResult>(source1, source2, source3, source4, source5, source6, source7, resultSelector);
		}

		public virtual IObservable<TResult> Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, IObservable<TSource7> source7, IObservable<TSource8> source8, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TResult> resultSelector)
		{
			return new Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TResult>(source1, source2, source3, source4, source5, source6, source7, source8, resultSelector);
		}

		public virtual IObservable<TResult> Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, IObservable<TSource7> source7, IObservable<TSource8> source8, IObservable<TSource9> source9, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TResult> resultSelector)
		{
			return new Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TResult>(source1, source2, source3, source4, source5, source6, source7, source8, source9, resultSelector);
		}

		public virtual IObservable<TResult> Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, IObservable<TSource7> source7, IObservable<TSource8> source8, IObservable<TSource9> source9, IObservable<T> source10, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, TResult> resultSelector)
		{
			return new Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, TResult>(source1, source2, source3, source4, source5, source6, source7, source8, source9, source10, resultSelector);
		}

		public virtual IObservable<TResult> Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, IObservable<TSource7> source7, IObservable<TSource8> source8, IObservable<TSource9> source9, IObservable<T> source10, IObservable<U> source11, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, TResult> resultSelector)
		{
			return new Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, TResult>(source1, source2, source3, source4, source5, source6, source7, source8, source9, source10, source11, resultSelector);
		}

		public virtual IObservable<TResult> Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, IObservable<TSource7> source7, IObservable<TSource8> source8, IObservable<TSource9> source9, IObservable<T> source10, IObservable<U> source11, IObservable<V> source12, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, TResult> resultSelector)
		{
			return new Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, TResult>(source1, source2, source3, source4, source5, source6, source7, source8, source9, source10, source11, source12, resultSelector);
		}

		public virtual IObservable<TResult> Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, IObservable<TSource7> source7, IObservable<TSource8> source8, IObservable<TSource9> source9, IObservable<T> source10, IObservable<U> source11, IObservable<V> source12, IObservable<W> source13, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, TResult> resultSelector)
		{
			return new Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, TResult>(source1, source2, source3, source4, source5, source6, source7, source8, source9, source10, source11, source12, source13, resultSelector);
		}

		public virtual IObservable<TResult> Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, IObservable<TSource7> source7, IObservable<TSource8> source8, IObservable<TSource9> source9, IObservable<T> source10, IObservable<U> source11, IObservable<V> source12, IObservable<W> source13, IObservable<X> source14, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, TResult> resultSelector)
		{
			return new Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, TResult>(source1, source2, source3, source4, source5, source6, source7, source8, source9, source10, source11, source12, source13, source14, resultSelector);
		}

		public virtual IObservable<TResult> Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, Y, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, IObservable<TSource7> source7, IObservable<TSource8> source8, IObservable<TSource9> source9, IObservable<T> source10, IObservable<U> source11, IObservable<V> source12, IObservable<W> source13, IObservable<X> source14, IObservable<Y> source15, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, Y, TResult> resultSelector)
		{
			return new Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, Y, TResult>(source1, source2, source3, source4, source5, source6, source7, source8, source9, source10, source11, source12, source13, source14, source15, resultSelector);
		}

		public virtual IObservable<TResult> Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, Y, Z, TResult>(IObservable<TSource1> source1, IObservable<TSource2> source2, IObservable<TSource3> source3, IObservable<TSource4> source4, IObservable<TSource5> source5, IObservable<TSource6> source6, IObservable<TSource7> source7, IObservable<TSource8> source8, IObservable<TSource9> source9, IObservable<T> source10, IObservable<U> source11, IObservable<V> source12, IObservable<W> source13, IObservable<X> source14, IObservable<Y> source15, IObservable<Z> source16, Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, Y, Z, TResult> resultSelector)
		{
			return new Zip<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, Y, Z, TResult>(source1, source2, source3, source4, source5, source6, source7, source8, source9, source10, source11, source12, source13, source14, source15, source16, resultSelector);
		}

		public virtual IObservable<TResult> Zip<TFirst, TSecond, TResult>(IObservable<TFirst> first, IEnumerable<TSecond> second, Func<TFirst, TSecond, TResult> resultSelector)
		{
			return new Zip<TFirst, TSecond, TResult>.Enumerable(first, second, resultSelector);
		}

		public virtual IObservable<TSource> Append<TSource>(IObservable<TSource> source, TSource value)
		{
			return QueryLanguage.Append_<TSource>(source, value, SchedulerDefaults.ConstantTimeOperations);
		}

		public virtual IObservable<TSource> Append<TSource>(IObservable<TSource> source, TSource value, IScheduler scheduler)
		{
			return QueryLanguage.Append_<TSource>(source, value, scheduler);
		}

		private static IObservable<TSource> Append_<TSource>(IObservable<TSource> source, TSource value, object scheduler)
		{
			AppendPrepend<TSource>.IAppendPrepend appendPrepend = source as AppendPrepend<TSource>.IAppendPrepend;
			if (appendPrepend != null && appendPrepend.Scheduler == scheduler)
			{
				return appendPrepend.Append(value);
			}
			if (scheduler == ImmediateScheduler.Instance)
			{
				return new AppendPrepend<TSource>.SingleImmediate(source, value, true);
			}
			return new AppendPrepend<TSource>.SingleValue(source, value, scheduler, true);
		}

		public virtual IObservable<TSource> AsObservable<TSource>(IObservable<TSource> source)
		{
			AsObservable<TSource> asObservable = source as AsObservable<TSource>;
			if (asObservable != null)
			{
				return asObservable;
			}
			return new AsObservable<TSource>(source);
		}

		public virtual IObservable<IList<TSource>> Buffer<TSource>(IObservable<TSource> source, int count)
		{
			return new Buffer<TSource>.CountExact(source, count);
		}

		public virtual IObservable<IList<TSource>> Buffer<TSource>(IObservable<TSource> source, int count, int skip)
		{
			if (count > skip)
			{
				return new Buffer<TSource>.CountOverlap(source, count, skip);
			}
			if (count < skip)
			{
				return new Buffer<TSource>.CountSkip(source, count, skip);
			}
			return new Buffer<TSource>.CountExact(source, count);
		}

		public virtual IObservable<TSource> Dematerialize<TSource>(IObservable<Notification<TSource>> source)
		{
			Materialize<TSource> materialize = source as Materialize<TSource>;
			if (materialize != null)
			{
				return materialize.Dematerialize();
			}
			return new Dematerialize<TSource>(source);
		}

		public virtual IObservable<TSource> DistinctUntilChanged<TSource>(IObservable<TSource> source)
		{
			return QueryLanguage.DistinctUntilChanged_<TSource, TSource>(source, (TSource x) => x, EqualityComparer<TSource>.Default);
		}

		public virtual IObservable<TSource> DistinctUntilChanged<TSource>(IObservable<TSource> source, IEqualityComparer<TSource> comparer)
		{
			return QueryLanguage.DistinctUntilChanged_<TSource, TSource>(source, (TSource x) => x, comparer);
		}

		public virtual IObservable<TSource> DistinctUntilChanged<TSource, TKey>(IObservable<TSource> source, Func<TSource, TKey> keySelector)
		{
			return QueryLanguage.DistinctUntilChanged_<TSource, TKey>(source, keySelector, EqualityComparer<TKey>.Default);
		}

		public virtual IObservable<TSource> DistinctUntilChanged<TSource, TKey>(IObservable<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer)
		{
			return QueryLanguage.DistinctUntilChanged_<TSource, TKey>(source, keySelector, comparer);
		}

		private static IObservable<TSource> DistinctUntilChanged_<TSource, TKey>(IObservable<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer)
		{
			return new DistinctUntilChanged<TSource, TKey>(source, keySelector, comparer);
		}

		public virtual IObservable<TSource> Do<TSource>(IObservable<TSource> source, Action<TSource> onNext)
		{
			return new Do<TSource>.OnNext(source, onNext);
		}

		public virtual IObservable<TSource> Do<TSource>(IObservable<TSource> source, Action<TSource> onNext, Action onCompleted)
		{
			return QueryLanguage.Do_<TSource>(source, onNext, Stubs<Exception>.Ignore, onCompleted);
		}

		public virtual IObservable<TSource> Do<TSource>(IObservable<TSource> source, Action<TSource> onNext, Action<Exception> onError)
		{
			return QueryLanguage.Do_<TSource>(source, onNext, onError, Stubs.Nop);
		}

		public virtual IObservable<TSource> Do<TSource>(IObservable<TSource> source, Action<TSource> onNext, Action<Exception> onError, Action onCompleted)
		{
			return QueryLanguage.Do_<TSource>(source, onNext, onError, onCompleted);
		}

		public virtual IObservable<TSource> Do<TSource>(IObservable<TSource> source, IObserver<TSource> observer)
		{
			return new Do<TSource>.Observer(source, observer);
		}

		private static IObservable<TSource> Do_<TSource>(IObservable<TSource> source, Action<TSource> onNext, Action<Exception> onError, object onCompleted)
		{
			return new Do<TSource>.Actions(source, onNext, onError, onCompleted);
		}

		public virtual IObservable<TSource> Finally<TSource>(IObservable<TSource> source, Action finallyAction)
		{
			return new Finally<TSource>(source, finallyAction);
		}

		public virtual IObservable<TSource> IgnoreElements<TSource>(IObservable<TSource> source)
		{
			IgnoreElements<TSource> ignoreElements = source as IgnoreElements<TSource>;
			if (ignoreElements != null)
			{
				return ignoreElements;
			}
			return new IgnoreElements<TSource>(source);
		}

		public virtual IObservable<Notification<TSource>> Materialize<TSource>(IObservable<TSource> source)
		{
			return new Materialize<TSource>(source);
		}

		public virtual IObservable<TSource> Prepend<TSource>(IObservable<TSource> source, TSource value)
		{
			return QueryLanguage.Prepend_<TSource>(source, value, SchedulerDefaults.ConstantTimeOperations);
		}

		public virtual IObservable<TSource> Prepend<TSource>(IObservable<TSource> source, TSource value, IScheduler scheduler)
		{
			return QueryLanguage.Prepend_<TSource>(source, value, scheduler);
		}

		private static IObservable<TSource> Prepend_<TSource>(IObservable<TSource> source, TSource value, object scheduler)
		{
			AppendPrepend<TSource>.IAppendPrepend appendPrepend = source as AppendPrepend<TSource>.IAppendPrepend;
			if (appendPrepend != null && appendPrepend.Scheduler == scheduler)
			{
				return appendPrepend.Prepend(value);
			}
			if (scheduler == ImmediateScheduler.Instance)
			{
				return new AppendPrepend<TSource>.SingleImmediate(source, value, false);
			}
			return new AppendPrepend<TSource>.SingleValue(source, value, scheduler, false);
		}

		public virtual IObservable<TSource> Repeat<TSource>(IObservable<TSource> source)
		{
			return QueryLanguage.RepeatInfinite<IObservable<TSource>>(source).Concat<TSource>();
		}

		private static IEnumerable<T> RepeatInfinite<T>(T value)
		{
			QueryLanguage.<RepeatInfinite>d__544<T> <RepeatInfinite>d__ = new QueryLanguage.<RepeatInfinite>d__544<T>(-2);
			<RepeatInfinite>d__.<>3__value = value;
			return <RepeatInfinite>d__;
		}

		public virtual IObservable<TSource> Repeat<TSource>(IObservable<TSource> source, int repeatCount)
		{
			return Enumerable.Repeat<IObservable<TSource>>(source, repeatCount).Concat<TSource>();
		}

		public virtual IObservable<TSource> RepeatWhen<TSource, TSignal>(IObservable<TSource> source, Func<IObservable<object>, IObservable<TSignal>> handler)
		{
			return new RepeatWhen<TSource, TSignal>(source, handler);
		}

		public virtual IObservable<TSource> Retry<TSource>(IObservable<TSource> source)
		{
			return QueryLanguage.RepeatInfinite<IObservable<TSource>>(source).Catch<TSource>();
		}

		public virtual IObservable<TSource> Retry<TSource>(IObservable<TSource> source, int retryCount)
		{
			return Enumerable.Repeat<IObservable<TSource>>(source, retryCount).Catch<TSource>();
		}

		public virtual IObservable<TSource> RetryWhen<TSource, TSignal>(IObservable<TSource> source, Func<IObservable<Exception>, IObservable<TSignal>> handler)
		{
			return new RetryWhen<TSource, TSignal>(source, handler);
		}

		public virtual IObservable<T> Scan<TSource, T>(IObservable<TSource> source, T seed, Func<T, TSource, T> accumulator)
		{
			return new Scan<TSource, T>(source, seed, accumulator);
		}

		public virtual IObservable<TSource> Scan<TSource>(IObservable<TSource> source, Func<TSource, TSource, TSource> accumulator)
		{
			return new Scan<TSource>(source, accumulator);
		}

		public virtual IObservable<TSource> SkipLast<TSource>(IObservable<TSource> source, int count)
		{
			return new SkipLast<TSource>.Count(source, count);
		}

		public virtual IObservable<TSource> StartWith<TSource>(IObservable<TSource> source, params TSource[] values)
		{
			return QueryLanguage.StartWith_<TSource>(source, SchedulerDefaults.ConstantTimeOperations, values);
		}

		public virtual IObservable<TSource> StartWith<TSource>(IObservable<TSource> source, IScheduler scheduler, params TSource[] values)
		{
			return QueryLanguage.StartWith_<TSource>(source, scheduler, values);
		}

		public virtual IObservable<TSource> StartWith<TSource>(IObservable<TSource> source, IEnumerable<TSource> values)
		{
			return this.StartWith<TSource>(source, SchedulerDefaults.ConstantTimeOperations, values);
		}

		public virtual IObservable<TSource> StartWith<TSource>(IObservable<TSource> source, IScheduler scheduler, IEnumerable<TSource> values)
		{
			TSource[] array = values as TSource[];
			if (array == null)
			{
				array = new List<TSource>(values).ToArray();
			}
			return QueryLanguage.StartWith_<TSource>(source, scheduler, array);
		}

		private static IObservable<TSource> StartWith_<TSource>(IObservable<TSource> source, object scheduler, params TSource[] values)
		{
			return values.ToObservable(scheduler).Concat(source);
		}

		public virtual IObservable<TSource> TakeLast<TSource>(IObservable<TSource> source, int count)
		{
			return QueryLanguage.TakeLast_<TSource>(source, count, SchedulerDefaults.Iteration);
		}

		public virtual IObservable<TSource> TakeLast<TSource>(IObservable<TSource> source, int count, IScheduler scheduler)
		{
			return QueryLanguage.TakeLast_<TSource>(source, count, scheduler);
		}

		private static IObservable<TSource> TakeLast_<TSource>(IObservable<TSource> source, int count, object scheduler)
		{
			return new TakeLast<TSource>.Count(source, count, scheduler);
		}

		public virtual IObservable<IList<TSource>> TakeLastBuffer<TSource>(IObservable<TSource> source, int count)
		{
			return new TakeLastBuffer<TSource>.Count(source, count);
		}

		public virtual IObservable<IObservable<TSource>> Window<TSource>(IObservable<TSource> source, int count, int skip)
		{
			return QueryLanguage.Window_<TSource>(source, count, skip);
		}

		public virtual IObservable<IObservable<TSource>> Window<TSource>(IObservable<TSource> source, int count)
		{
			return QueryLanguage.Window_<TSource>(source, count, count);
		}

		private static IObservable<IObservable<TSource>> Window_<TSource>(IObservable<TSource> source, int count, int skip)
		{
			return new Window<TSource>.Count(source, count, skip);
		}

		public virtual IObservable<TResult> Cast<TResult>(IObservable<object> source)
		{
			return new Cast<object, TResult>(source);
		}

		public virtual IObservable<TSource> DefaultIfEmpty<TSource>(IObservable<TSource> source)
		{
			return new DefaultIfEmpty<TSource>(source, default(TSource));
		}

		public virtual IObservable<TSource> DefaultIfEmpty<TSource>(IObservable<TSource> source, TSource defaultValue)
		{
			return new DefaultIfEmpty<TSource>(source, defaultValue);
		}

		public virtual IObservable<TSource> Distinct<TSource>(IObservable<TSource> source)
		{
			return new Distinct<TSource, TSource>(source, (TSource x) => x, EqualityComparer<TSource>.Default);
		}

		public virtual IObservable<TSource> Distinct<TSource>(IObservable<TSource> source, IEqualityComparer<TSource> comparer)
		{
			return new Distinct<TSource, TSource>(source, (TSource x) => x, comparer);
		}

		public virtual IObservable<TSource> Distinct<TSource, TKey>(IObservable<TSource> source, Func<TSource, TKey> keySelector)
		{
			return new Distinct<TSource, TKey>(source, keySelector, EqualityComparer<TKey>.Default);
		}

		public virtual IObservable<TSource> Distinct<TSource, TKey>(IObservable<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer)
		{
			return new Distinct<TSource, TKey>(source, keySelector, comparer);
		}

		public virtual IObservable<GInterface4<TKey, TElement>> GroupBy<TSource, TKey, TElement>(IObservable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector)
		{
			return QueryLanguage.GroupBy_<TSource, TKey, TElement>(source, keySelector, elementSelector, null, EqualityComparer<TKey>.Default);
		}

		public virtual IObservable<GInterface4<TKey, TSource>> GroupBy<TSource, TKey>(IObservable<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer)
		{
			return QueryLanguage.GroupBy_<TSource, TKey, TSource>(source, keySelector, (TSource x) => x, null, comparer);
		}

		public virtual IObservable<GInterface4<TKey, TSource>> GroupBy<TSource, TKey>(IObservable<TSource> source, Func<TSource, TKey> keySelector)
		{
			return QueryLanguage.GroupBy_<TSource, TKey, TSource>(source, keySelector, (TSource x) => x, null, EqualityComparer<TKey>.Default);
		}

		public virtual IObservable<GInterface4<TKey, TElement>> GroupBy<TSource, TKey, TElement>(IObservable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, IEqualityComparer<TKey> comparer)
		{
			return QueryLanguage.GroupBy_<TSource, TKey, TElement>(source, keySelector, elementSelector, null, comparer);
		}

		public virtual IObservable<GInterface4<TKey, TElement>> GroupBy<TSource, TKey, TElement>(IObservable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, int capacity)
		{
			return QueryLanguage.GroupBy_<TSource, TKey, TElement>(source, keySelector, elementSelector, new int?(capacity), EqualityComparer<TKey>.Default);
		}

		public virtual IObservable<GInterface4<TKey, TSource>> GroupBy<TSource, TKey>(IObservable<TSource> source, Func<TSource, TKey> keySelector, int capacity, IEqualityComparer<TKey> comparer)
		{
			return QueryLanguage.GroupBy_<TSource, TKey, TSource>(source, keySelector, (TSource x) => x, new int?(capacity), comparer);
		}

		public virtual IObservable<GInterface4<TKey, TSource>> GroupBy<TSource, TKey>(IObservable<TSource> source, Func<TSource, TKey> keySelector, int capacity)
		{
			return QueryLanguage.GroupBy_<TSource, TKey, TSource>(source, keySelector, (TSource x) => x, new int?(capacity), EqualityComparer<TKey>.Default);
		}

		public virtual IObservable<GInterface4<TKey, TElement>> GroupBy<TSource, TKey, TElement>(IObservable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, int capacity, IEqualityComparer<TKey> comparer)
		{
			return QueryLanguage.GroupBy_<TSource, TKey, TElement>(source, keySelector, elementSelector, new int?(capacity), comparer);
		}

		private static IObservable<GInterface4<TKey, TElement>> GroupBy_<TSource, TKey, TElement>(IObservable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, int? capacity, IEqualityComparer<TKey> comparer)
		{
			return new GroupBy<TSource, TKey, TElement>(source, keySelector, elementSelector, capacity, comparer);
		}

		public virtual IObservable<GInterface4<TKey, TElement>> GroupByUntil<TSource, TKey, TElement, T>(IObservable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, Func<GInterface4<TKey, TElement>, IObservable<T>> durationSelector, IEqualityComparer<TKey> comparer)
		{
			return QueryLanguage.GroupByUntil_<TSource, TKey, TElement, T>(source, keySelector, elementSelector, durationSelector, null, comparer);
		}

		public virtual IObservable<GInterface4<TKey, TElement>> GroupByUntil<TSource, TKey, TElement, T>(IObservable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, Func<GInterface4<TKey, TElement>, IObservable<T>> durationSelector)
		{
			return QueryLanguage.GroupByUntil_<TSource, TKey, TElement, T>(source, keySelector, elementSelector, durationSelector, null, EqualityComparer<TKey>.Default);
		}

		public virtual IObservable<GInterface4<TKey, TSource>> GroupByUntil<TSource, TKey, T>(IObservable<TSource> source, Func<TSource, TKey> keySelector, Func<GInterface4<TKey, TSource>, IObservable<T>> durationSelector, IEqualityComparer<TKey> comparer)
		{
			return QueryLanguage.GroupByUntil_<TSource, TKey, TSource, T>(source, keySelector, (TSource x) => x, durationSelector, null, comparer);
		}

		public virtual IObservable<GInterface4<TKey, TSource>> GroupByUntil<TSource, TKey, T>(IObservable<TSource> source, Func<TSource, TKey> keySelector, Func<GInterface4<TKey, TSource>, IObservable<T>> durationSelector)
		{
			return QueryLanguage.GroupByUntil_<TSource, TKey, TSource, T>(source, keySelector, (TSource x) => x, durationSelector, null, EqualityComparer<TKey>.Default);
		}

		public virtual IObservable<GInterface4<TKey, TElement>> GroupByUntil<TSource, TKey, TElement, T>(IObservable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, Func<GInterface4<TKey, TElement>, IObservable<T>> durationSelector, int capacity, IEqualityComparer<TKey> comparer)
		{
			return QueryLanguage.GroupByUntil_<TSource, TKey, TElement, T>(source, keySelector, elementSelector, durationSelector, new int?(capacity), comparer);
		}

		public virtual IObservable<GInterface4<TKey, TElement>> GroupByUntil<TSource, TKey, TElement, T>(IObservable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, Func<GInterface4<TKey, TElement>, IObservable<T>> durationSelector, int capacity)
		{
			return QueryLanguage.GroupByUntil_<TSource, TKey, TElement, T>(source, keySelector, elementSelector, durationSelector, new int?(capacity), EqualityComparer<TKey>.Default);
		}

		public virtual IObservable<GInterface4<TKey, TSource>> GroupByUntil<TSource, TKey, T>(IObservable<TSource> source, Func<TSource, TKey> keySelector, Func<GInterface4<TKey, TSource>, IObservable<T>> durationSelector, int capacity, IEqualityComparer<TKey> comparer)
		{
			return QueryLanguage.GroupByUntil_<TSource, TKey, TSource, T>(source, keySelector, (TSource x) => x, durationSelector, new int?(capacity), comparer);
		}

		public virtual IObservable<GInterface4<TKey, TSource>> GroupByUntil<TSource, TKey, T>(IObservable<TSource> source, Func<TSource, TKey> keySelector, Func<GInterface4<TKey, TSource>, IObservable<T>> durationSelector, int capacity)
		{
			return QueryLanguage.GroupByUntil_<TSource, TKey, TSource, T>(source, keySelector, (TSource x) => x, durationSelector, new int?(capacity), EqualityComparer<TKey>.Default);
		}

		private static IObservable<GInterface4<TKey, TElement>> GroupByUntil_<TSource, TKey, TElement, T>(IObservable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, Func<GInterface4<TKey, TElement>, IObservable<T>> durationSelector, int? capacity, IEqualityComparer<TKey> comparer)
		{
			return new GroupByUntil<TSource, TKey, TElement, T>(source, keySelector, elementSelector, durationSelector, capacity, comparer);
		}

		public virtual IObservable<TResult> GroupJoin<TLeft, TRight, TLeftDuration, TRightDuration, TResult>(IObservable<TLeft> left, IObservable<TRight> right, Func<TLeft, IObservable<TLeftDuration>> leftDurationSelector, Func<TRight, IObservable<TRightDuration>> rightDurationSelector, Func<TLeft, IObservable<TRight>, TResult> resultSelector)
		{
			return QueryLanguage.GroupJoin_<TLeft, TRight, TLeftDuration, TRightDuration, TResult>(left, right, leftDurationSelector, rightDurationSelector, resultSelector);
		}

		private static IObservable<TResult> GroupJoin_<TLeft, TRight, TLeftDuration, TRightDuration, TResult>(IObservable<TLeft> left, IObservable<TRight> right, Func<TLeft, IObservable<TLeftDuration>> leftDurationSelector, Func<TRight, IObservable<TRightDuration>> rightDurationSelector, Func<TLeft, IObservable<TRight>, TResult> resultSelector)
		{
			return new GroupJoin<TLeft, TRight, TLeftDuration, TRightDuration, TResult>(left, right, leftDurationSelector, rightDurationSelector, resultSelector);
		}

		public virtual IObservable<TResult> Join<TLeft, TRight, TLeftDuration, TRightDuration, TResult>(IObservable<TLeft> left, IObservable<TRight> right, Func<TLeft, IObservable<TLeftDuration>> leftDurationSelector, Func<TRight, IObservable<TRightDuration>> rightDurationSelector, Func<TLeft, TRight, TResult> resultSelector)
		{
			return QueryLanguage.Join_<TLeft, TRight, TLeftDuration, TRightDuration, TResult>(left, right, leftDurationSelector, rightDurationSelector, resultSelector);
		}

		private static IObservable<TResult> Join_<TLeft, TRight, TLeftDuration, TRightDuration, TResult>(IObservable<TLeft> left, IObservable<TRight> right, Func<TLeft, IObservable<TLeftDuration>> leftDurationSelector, Func<TRight, IObservable<TRightDuration>> rightDurationSelector, Func<TLeft, TRight, TResult> resultSelector)
		{
			return new Join<TLeft, TRight, TLeftDuration, TRightDuration, TResult>(left, right, leftDurationSelector, rightDurationSelector, resultSelector);
		}

		public virtual IObservable<TResult> OfType<TResult>(IObservable<object> source)
		{
			return new OfType<object, TResult>(source);
		}

		public virtual IObservable<TResult> Select<TSource, TResult>(IObservable<TSource> source, Func<TSource, TResult> selector)
		{
			return new Select<TSource, TResult>.Selector(source, selector);
		}

		public virtual IObservable<TResult> Select<TSource, TResult>(IObservable<TSource> source, Func<TSource, int, TResult> selector)
		{
			return new Select<TSource, TResult>.SelectorIndexed(source, selector);
		}

		public virtual IObservable<TOther> SelectMany<TSource, TOther>(IObservable<TSource> source, IObservable<TOther> other)
		{
			return QueryLanguage.SelectMany_<TSource, TOther>(source, (TSource _) => other);
		}

		public virtual IObservable<TResult> SelectMany<TSource, TResult>(IObservable<TSource> source, Func<TSource, IObservable<TResult>> selector)
		{
			return QueryLanguage.SelectMany_<TSource, TResult>(source, selector);
		}

		public virtual IObservable<TResult> SelectMany<TSource, TResult>(IObservable<TSource> source, Func<TSource, int, IObservable<TResult>> selector)
		{
			return QueryLanguage.SelectMany_<TSource, TResult>(source, selector);
		}

		public virtual IObservable<TResult> SelectMany<TSource, TResult>(IObservable<TSource> source, Func<TSource, Task<TResult>> selector)
		{
			return new SelectMany<TSource, TResult>.TaskSelector(source, (TSource x, CancellationToken token) => selector(x));
		}

		public virtual IObservable<TResult> SelectMany<TSource, TResult>(IObservable<TSource> source, Func<TSource, int, Task<TResult>> selector)
		{
			return new SelectMany<TSource, TResult>.TaskSelectorIndexed(source, (TSource x, int i, CancellationToken token) => selector(x, i));
		}

		public virtual IObservable<TResult> SelectMany<TSource, TResult>(IObservable<TSource> source, Func<TSource, CancellationToken, Task<TResult>> selector)
		{
			return new SelectMany<TSource, TResult>.TaskSelector(source, selector);
		}

		public virtual IObservable<TResult> SelectMany<TSource, TResult>(IObservable<TSource> source, Func<TSource, int, CancellationToken, Task<TResult>> selector)
		{
			return new SelectMany<TSource, TResult>.TaskSelectorIndexed(source, selector);
		}

		public virtual IObservable<TResult> SelectMany<TSource, T, TResult>(IObservable<TSource> source, Func<TSource, IObservable<T>> collectionSelector, Func<TSource, T, TResult> resultSelector)
		{
			return QueryLanguage.SelectMany_<TSource, T, TResult>(source, collectionSelector, resultSelector);
		}

		public virtual IObservable<TResult> SelectMany<TSource, T, TResult>(IObservable<TSource> source, Func<TSource, int, IObservable<T>> collectionSelector, Func<TSource, int, T, int, TResult> resultSelector)
		{
			return QueryLanguage.SelectMany_<TSource, T, TResult>(source, collectionSelector, resultSelector);
		}

		public virtual IObservable<TResult> SelectMany<TSource, T, TResult>(IObservable<TSource> source, Func<TSource, Task<T>> taskSelector, Func<TSource, T, TResult> resultSelector)
		{
			return new SelectMany<TSource, T, TResult>.TaskSelector(source, (TSource x, CancellationToken token) => taskSelector(x), resultSelector);
		}

		public virtual IObservable<TResult> SelectMany<TSource, T, TResult>(IObservable<TSource> source, Func<TSource, int, Task<T>> taskSelector, Func<TSource, int, T, TResult> resultSelector)
		{
			return new SelectMany<TSource, T, TResult>.TaskSelectorIndexed(source, (TSource x, int i, CancellationToken token) => taskSelector(x, i), resultSelector);
		}

		public virtual IObservable<TResult> SelectMany<TSource, T, TResult>(IObservable<TSource> source, Func<TSource, CancellationToken, Task<T>> taskSelector, Func<TSource, T, TResult> resultSelector)
		{
			return new SelectMany<TSource, T, TResult>.TaskSelector(source, taskSelector, resultSelector);
		}

		public virtual IObservable<TResult> SelectMany<TSource, T, TResult>(IObservable<TSource> source, Func<TSource, int, CancellationToken, Task<T>> taskSelector, Func<TSource, int, T, TResult> resultSelector)
		{
			return new SelectMany<TSource, T, TResult>.TaskSelectorIndexed(source, taskSelector, resultSelector);
		}

		private static IObservable<TResult> SelectMany_<TSource, TResult>(IObservable<TSource> source, Func<TSource, IObservable<TResult>> selector)
		{
			return new SelectMany<TSource, TResult>.ObservableSelector(source, selector);
		}

		private static IObservable<TResult> SelectMany_<TSource, TResult>(IObservable<TSource> source, Func<TSource, int, IObservable<TResult>> selector)
		{
			return new SelectMany<TSource, TResult>.ObservableSelectorIndexed(source, selector);
		}

		private static IObservable<TResult> SelectMany_<TSource, T, TResult>(IObservable<TSource> source, Func<TSource, IObservable<T>> collectionSelector, Func<TSource, T, TResult> resultSelector)
		{
			return new SelectMany<TSource, T, TResult>.ObservableSelector(source, collectionSelector, resultSelector);
		}

		private static IObservable<TResult> SelectMany_<TSource, T, TResult>(IObservable<TSource> source, Func<TSource, int, IObservable<T>> collectionSelector, Func<TSource, int, T, int, TResult> resultSelector)
		{
			return new SelectMany<TSource, T, TResult>.ObservableSelectorIndexed(source, collectionSelector, resultSelector);
		}

		public virtual IObservable<TResult> SelectMany<TSource, TResult>(IObservable<TSource> source, Func<TSource, IObservable<TResult>> onNext, Func<Exception, IObservable<TResult>> onError, Func<IObservable<TResult>> onCompleted)
		{
			return new SelectMany<TSource, TResult>.ObservableSelectors(source, onNext, onError, onCompleted);
		}

		public virtual IObservable<TResult> SelectMany<TSource, TResult>(IObservable<TSource> source, Func<TSource, int, IObservable<TResult>> onNext, Func<Exception, IObservable<TResult>> onError, Func<IObservable<TResult>> onCompleted)
		{
			return new SelectMany<TSource, TResult>.ObservableSelectorsIndexed(source, onNext, onError, onCompleted);
		}

		public virtual IObservable<TResult> SelectMany<TSource, TResult>(IObservable<TSource> source, Func<TSource, IEnumerable<TResult>> selector)
		{
			return new SelectMany<TSource, TResult>.EnumerableSelector(source, selector);
		}

		public virtual IObservable<TResult> SelectMany<TSource, TResult>(IObservable<TSource> source, Func<TSource, int, IEnumerable<TResult>> selector)
		{
			return new SelectMany<TSource, TResult>.EnumerableSelectorIndexed(source, selector);
		}

		public virtual IObservable<TResult> SelectMany<TSource, T, TResult>(IObservable<TSource> source, Func<TSource, IEnumerable<T>> collectionSelector, Func<TSource, T, TResult> resultSelector)
		{
			return QueryLanguage.SelectMany_<TSource, T, TResult>(source, collectionSelector, resultSelector);
		}

		public virtual IObservable<TResult> SelectMany<TSource, T, TResult>(IObservable<TSource> source, Func<TSource, int, IEnumerable<T>> collectionSelector, Func<TSource, int, T, int, TResult> resultSelector)
		{
			return QueryLanguage.SelectMany_<TSource, T, TResult>(source, collectionSelector, resultSelector);
		}

		private static IObservable<TResult> SelectMany_<TSource, T, TResult>(IObservable<TSource> source, Func<TSource, IEnumerable<T>> collectionSelector, Func<TSource, T, TResult> resultSelector)
		{
			return new SelectMany<TSource, T, TResult>.EnumerableSelector(source, collectionSelector, resultSelector);
		}

		private static IObservable<TResult> SelectMany_<TSource, T, TResult>(IObservable<TSource> source, Func<TSource, int, IEnumerable<T>> collectionSelector, Func<TSource, int, T, int, TResult> resultSelector)
		{
			return new SelectMany<TSource, T, TResult>.EnumerableSelectorIndexed(source, collectionSelector, resultSelector);
		}

		public virtual IObservable<TSource> Skip<TSource>(IObservable<TSource> source, int count)
		{
			Skip<TSource>.Count count2 = source as Skip<TSource>.Count;
			if (count2 != null)
			{
				return count2.Combine(count);
			}
			return new Skip<TSource>.Count(source, count);
		}

		public virtual IObservable<TSource> SkipWhile<TSource>(IObservable<TSource> source, Func<TSource, bool> predicate)
		{
			return new SkipWhile<TSource>.Predicate(source, predicate);
		}

		public virtual IObservable<TSource> SkipWhile<TSource>(IObservable<TSource> source, Func<TSource, int, bool> predicate)
		{
			return new SkipWhile<TSource>.PredicateIndexed(source, predicate);
		}

		public virtual IObservable<TSource> Take<TSource>(IObservable<TSource> source, int count)
		{
			if (count == 0)
			{
				return this.Empty<TSource>();
			}
			return QueryLanguage.Take_<TSource>(source, count);
		}

		public virtual IObservable<TSource> Take<TSource>(IObservable<TSource> source, int count, IScheduler scheduler)
		{
			if (count == 0)
			{
				return this.Empty<TSource>(scheduler);
			}
			return QueryLanguage.Take_<TSource>(source, count);
		}

		private static IObservable<TSource> Take_<TSource>(IObservable<TSource> source, int count)
		{
			Take<TSource>.Count count2 = source as Take<TSource>.Count;
			if (count2 != null)
			{
				return count2.Combine(count);
			}
			return new Take<TSource>.Count(source, count);
		}

		public virtual IObservable<TSource> TakeWhile<TSource>(IObservable<TSource> source, Func<TSource, bool> predicate)
		{
			return new TakeWhile<TSource>.Predicate(source, predicate);
		}

		public virtual IObservable<TSource> TakeWhile<TSource>(IObservable<TSource> source, Func<TSource, int, bool> predicate)
		{
			return new TakeWhile<TSource>.PredicateIndexed(source, predicate);
		}

		public virtual IObservable<TSource> Where<TSource>(IObservable<TSource> source, Func<TSource, bool> predicate)
		{
			Where<TSource>.Predicate predicate2 = source as Where<TSource>.Predicate;
			if (predicate2 != null)
			{
				return predicate2.Combine(predicate);
			}
			return new Where<TSource>.Predicate(source, predicate);
		}

		public virtual IObservable<TSource> Where<TSource>(IObservable<TSource> source, Func<TSource, int, bool> predicate)
		{
			return new Where<TSource>.PredicateIndexed(source, predicate);
		}

		public virtual IObservable<IList<TSource>> Buffer<TSource>(IObservable<TSource> source, TimeSpan timeSpan)
		{
			return QueryLanguage.Buffer_<TSource>(source, timeSpan, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<IList<TSource>> Buffer<TSource>(IObservable<TSource> source, TimeSpan timeSpan, IScheduler scheduler)
		{
			return QueryLanguage.Buffer_<TSource>(source, timeSpan, scheduler);
		}

		private static IObservable<IList<TSource>> Buffer_<TSource>(IObservable<TSource> source, TimeSpan timeSpan, object scheduler)
		{
			return new Buffer<TSource>.TimeHopping(source, timeSpan, scheduler);
		}

		public virtual IObservable<IList<TSource>> Buffer<TSource>(IObservable<TSource> source, TimeSpan timeSpan, TimeSpan timeShift)
		{
			return QueryLanguage.Buffer_<TSource>(source, timeSpan, timeShift, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<IList<TSource>> Buffer<TSource>(IObservable<TSource> source, TimeSpan timeSpan, TimeSpan timeShift, IScheduler scheduler)
		{
			return QueryLanguage.Buffer_<TSource>(source, timeSpan, timeShift, scheduler);
		}

		private static IObservable<IList<TSource>> Buffer_<TSource>(IObservable<TSource> source, TimeSpan timeSpan, TimeSpan timeShift, object scheduler)
		{
			return new Buffer<TSource>.TimeSliding(source, timeSpan, timeShift, scheduler);
		}

		public virtual IObservable<IList<TSource>> Buffer<TSource>(IObservable<TSource> source, TimeSpan timeSpan, int count)
		{
			return QueryLanguage.Buffer_<TSource>(source, timeSpan, count, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<IList<TSource>> Buffer<TSource>(IObservable<TSource> source, TimeSpan timeSpan, int count, IScheduler scheduler)
		{
			return QueryLanguage.Buffer_<TSource>(source, timeSpan, count, scheduler);
		}

		private static IObservable<IList<TSource>> Buffer_<TSource>(IObservable<TSource> source, TimeSpan timeSpan, int count, object scheduler)
		{
			return new Buffer<TSource>.Ferry(source, timeSpan, count, scheduler);
		}

		public virtual IObservable<TSource> Delay<TSource>(IObservable<TSource> source, TimeSpan dueTime)
		{
			return QueryLanguage.Delay_<TSource>(source, dueTime, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<TSource> Delay<TSource>(IObservable<TSource> source, TimeSpan dueTime, IScheduler scheduler)
		{
			return QueryLanguage.Delay_<TSource>(source, dueTime, scheduler);
		}

		private static IObservable<TSource> Delay_<TSource>(IObservable<TSource> source, TimeSpan dueTime, object scheduler)
		{
			return new Delay<TSource>.Relative(source, dueTime, scheduler);
		}

		public virtual IObservable<TSource> Delay<TSource>(IObservable<TSource> source, DateTimeOffset dueTime)
		{
			return QueryLanguage.Delay_<TSource>(source, dueTime, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<TSource> Delay<TSource>(IObservable<TSource> source, DateTimeOffset dueTime, IScheduler scheduler)
		{
			return QueryLanguage.Delay_<TSource>(source, dueTime, scheduler);
		}

		private static IObservable<TSource> Delay_<TSource>(IObservable<TSource> source, DateTimeOffset dueTime, object scheduler)
		{
			return new Delay<TSource>.Absolute(source, dueTime, scheduler);
		}

		public virtual IObservable<TSource> Delay<TSource, TDelay>(IObservable<TSource> source, Func<TSource, IObservable<TDelay>> delayDurationSelector)
		{
			return new Delay<TSource, TDelay>.Selector(source, delayDurationSelector);
		}

		public virtual IObservable<TSource> Delay<TSource, TDelay>(IObservable<TSource> source, IObservable<TDelay> subscriptionDelay, Func<TSource, IObservable<TDelay>> delayDurationSelector)
		{
			return new Delay<TSource, TDelay>.SelectorWithSubscriptionDelay(source, subscriptionDelay, delayDurationSelector);
		}

		public virtual IObservable<TSource> DelaySubscription<TSource>(IObservable<TSource> source, TimeSpan dueTime)
		{
			return QueryLanguage.DelaySubscription_<TSource>(source, dueTime, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<TSource> DelaySubscription<TSource>(IObservable<TSource> source, TimeSpan dueTime, IScheduler scheduler)
		{
			return QueryLanguage.DelaySubscription_<TSource>(source, dueTime, scheduler);
		}

		private static IObservable<TSource> DelaySubscription_<TSource>(IObservable<TSource> source, TimeSpan dueTime, object scheduler)
		{
			return new DelaySubscription<TSource>.Relative(source, dueTime, scheduler);
		}

		public virtual IObservable<TSource> DelaySubscription<TSource>(IObservable<TSource> source, DateTimeOffset dueTime)
		{
			return QueryLanguage.DelaySubscription_<TSource>(source, dueTime, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<TSource> DelaySubscription<TSource>(IObservable<TSource> source, DateTimeOffset dueTime, IScheduler scheduler)
		{
			return QueryLanguage.DelaySubscription_<TSource>(source, dueTime, scheduler);
		}

		private static IObservable<TSource> DelaySubscription_<TSource>(IObservable<TSource> source, DateTimeOffset dueTime, object scheduler)
		{
			return new DelaySubscription<TSource>.Absolute(source, dueTime, scheduler);
		}

		public virtual IObservable<TResult> Generate<TState, TResult>(TState initialState, Func<TState, bool> condition, Func<TState, TState> iterate, Func<TState, TResult> resultSelector, Func<TState, TimeSpan> timeSelector)
		{
			return QueryLanguage.Generate_<TState, TResult>(initialState, condition, iterate, resultSelector, timeSelector, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<TResult> Generate<TState, TResult>(TState initialState, Func<TState, bool> condition, Func<TState, TState> iterate, Func<TState, TResult> resultSelector, Func<TState, TimeSpan> timeSelector, IScheduler scheduler)
		{
			return QueryLanguage.Generate_<TState, TResult>(initialState, condition, iterate, resultSelector, timeSelector, scheduler);
		}

		private static IObservable<TResult> Generate_<TState, TResult>(TState initialState, Func<TState, bool> condition, Func<TState, TState> iterate, Func<TState, TResult> resultSelector, Func<TState, TimeSpan> timeSelector, object scheduler)
		{
			return new Generate<TState, TResult>.Relative(initialState, condition, iterate, resultSelector, timeSelector, scheduler);
		}

		public virtual IObservable<TResult> Generate<TState, TResult>(TState initialState, Func<TState, bool> condition, Func<TState, TState> iterate, Func<TState, TResult> resultSelector, Func<TState, DateTimeOffset> timeSelector)
		{
			return QueryLanguage.Generate_<TState, TResult>(initialState, condition, iterate, resultSelector, timeSelector, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<TResult> Generate<TState, TResult>(TState initialState, Func<TState, bool> condition, Func<TState, TState> iterate, Func<TState, TResult> resultSelector, Func<TState, DateTimeOffset> timeSelector, IScheduler scheduler)
		{
			return QueryLanguage.Generate_<TState, TResult>(initialState, condition, iterate, resultSelector, timeSelector, scheduler);
		}

		private static IObservable<TResult> Generate_<TState, TResult>(TState initialState, Func<TState, bool> condition, Func<TState, TState> iterate, Func<TState, TResult> resultSelector, Func<TState, DateTimeOffset> timeSelector, object scheduler)
		{
			return new Generate<TState, TResult>.Absolute(initialState, condition, iterate, resultSelector, timeSelector, scheduler);
		}

		public virtual IObservable<long> Interval(TimeSpan period)
		{
			return new global::System.Reactive.Linq.ObservableImpl.Timer.Periodic.Relative(period, period, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<long> Interval(TimeSpan period, IScheduler scheduler)
		{
			return new global::System.Reactive.Linq.ObservableImpl.Timer.Periodic.Relative(period, period, scheduler);
		}

		public virtual IObservable<TSource> Sample<TSource>(IObservable<TSource> source, TimeSpan interval)
		{
			return QueryLanguage.Sample_<TSource>(source, interval, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<TSource> Sample<TSource>(IObservable<TSource> source, TimeSpan interval, IScheduler scheduler)
		{
			return QueryLanguage.Sample_<TSource>(source, interval, scheduler);
		}

		private static IObservable<TSource> Sample_<TSource>(IObservable<TSource> source, TimeSpan interval, object scheduler)
		{
			return new Sample<TSource>(source, interval, scheduler);
		}

		public virtual IObservable<TSource> Sample<TSource, TSample>(IObservable<TSource> source, IObservable<TSample> sampler)
		{
			return QueryLanguage.Sample_<TSource, TSample>(source, sampler);
		}

		private static IObservable<TSource> Sample_<TSource, TSample>(IObservable<TSource> source, IObservable<TSample> sampler)
		{
			return new Sample<TSource, TSample>(source, sampler);
		}

		public virtual IObservable<TSource> Skip<TSource>(IObservable<TSource> source, TimeSpan duration)
		{
			return QueryLanguage.Skip_<TSource>(source, duration, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<TSource> Skip<TSource>(IObservable<TSource> source, TimeSpan duration, IScheduler scheduler)
		{
			return QueryLanguage.Skip_<TSource>(source, duration, scheduler);
		}

		private static IObservable<TSource> Skip_<TSource>(IObservable<TSource> source, TimeSpan duration, object scheduler)
		{
			Skip<TSource>.Time time = source as Skip<TSource>.Time;
			if (time != null && time._scheduler == scheduler)
			{
				return time.Combine(duration);
			}
			return new Skip<TSource>.Time(source, duration, scheduler);
		}

		public virtual IObservable<TSource> SkipLast<TSource>(IObservable<TSource> source, TimeSpan duration)
		{
			return QueryLanguage.SkipLast_<TSource>(source, duration, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<TSource> SkipLast<TSource>(IObservable<TSource> source, TimeSpan duration, IScheduler scheduler)
		{
			return QueryLanguage.SkipLast_<TSource>(source, duration, scheduler);
		}

		private static IObservable<TSource> SkipLast_<TSource>(IObservable<TSource> source, TimeSpan duration, object scheduler)
		{
			return new SkipLast<TSource>.Time(source, duration, scheduler);
		}

		public virtual IObservable<TSource> SkipUntil<TSource>(IObservable<TSource> source, DateTimeOffset startTime)
		{
			return QueryLanguage.SkipUntil_<TSource>(source, startTime, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<TSource> SkipUntil<TSource>(IObservable<TSource> source, DateTimeOffset startTime, IScheduler scheduler)
		{
			return QueryLanguage.SkipUntil_<TSource>(source, startTime, scheduler);
		}

		private static IObservable<TSource> SkipUntil_<TSource>(IObservable<TSource> source, DateTimeOffset startTime, object scheduler)
		{
			SkipUntil<TSource> skipUntil = source as SkipUntil<TSource>;
			if (skipUntil != null && skipUntil._scheduler == scheduler)
			{
				return skipUntil.Combine(startTime);
			}
			return new SkipUntil<TSource>(source, startTime, scheduler);
		}

		public virtual IObservable<TSource> Take<TSource>(IObservable<TSource> source, TimeSpan duration)
		{
			return QueryLanguage.Take_<TSource>(source, duration, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<TSource> Take<TSource>(IObservable<TSource> source, TimeSpan duration, IScheduler scheduler)
		{
			return QueryLanguage.Take_<TSource>(source, duration, scheduler);
		}

		private static IObservable<TSource> Take_<TSource>(IObservable<TSource> source, TimeSpan duration, object scheduler)
		{
			Take<TSource>.Time time = source as Take<TSource>.Time;
			if (time != null && time._scheduler == scheduler)
			{
				return time.Combine(duration);
			}
			return new Take<TSource>.Time(source, duration, scheduler);
		}

		public virtual IObservable<TSource> TakeLast<TSource>(IObservable<TSource> source, TimeSpan duration)
		{
			return QueryLanguage.TakeLast_<TSource>(source, duration, SchedulerDefaults.TimeBasedOperations, SchedulerDefaults.Iteration);
		}

		public virtual IObservable<TSource> TakeLast<TSource>(IObservable<TSource> source, TimeSpan duration, IScheduler scheduler)
		{
			return QueryLanguage.TakeLast_<TSource>(source, duration, scheduler, SchedulerDefaults.Iteration);
		}

		public virtual IObservable<TSource> TakeLast<TSource>(IObservable<TSource> source, TimeSpan duration, IScheduler timerScheduler, IScheduler loopScheduler)
		{
			return QueryLanguage.TakeLast_<TSource>(source, duration, timerScheduler, loopScheduler);
		}

		private static IObservable<TSource> TakeLast_<TSource>(IObservable<TSource> source, TimeSpan duration, object timerScheduler, object loopScheduler)
		{
			return new TakeLast<TSource>.Time(source, duration, timerScheduler, loopScheduler);
		}

		public virtual IObservable<IList<TSource>> TakeLastBuffer<TSource>(IObservable<TSource> source, TimeSpan duration)
		{
			return QueryLanguage.TakeLastBuffer_<TSource>(source, duration, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<IList<TSource>> TakeLastBuffer<TSource>(IObservable<TSource> source, TimeSpan duration, IScheduler scheduler)
		{
			return QueryLanguage.TakeLastBuffer_<TSource>(source, duration, scheduler);
		}

		private static IObservable<IList<TSource>> TakeLastBuffer_<TSource>(IObservable<TSource> source, TimeSpan duration, object scheduler)
		{
			return new TakeLastBuffer<TSource>.Time(source, duration, scheduler);
		}

		public virtual IObservable<TSource> TakeUntil<TSource>(IObservable<TSource> source, DateTimeOffset endTime)
		{
			return QueryLanguage.TakeUntil_<TSource>(source, endTime, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<TSource> TakeUntil<TSource>(IObservable<TSource> source, DateTimeOffset endTime, IScheduler scheduler)
		{
			return QueryLanguage.TakeUntil_<TSource>(source, endTime, scheduler);
		}

		private static IObservable<TSource> TakeUntil_<TSource>(IObservable<TSource> source, DateTimeOffset endTime, object scheduler)
		{
			TakeUntil<TSource> takeUntil = source as TakeUntil<TSource>;
			if (takeUntil != null && takeUntil._scheduler == scheduler)
			{
				return takeUntil.Combine(endTime);
			}
			return new TakeUntil<TSource>(source, endTime, scheduler);
		}

		public virtual IObservable<TSource> Throttle<TSource>(IObservable<TSource> source, TimeSpan dueTime)
		{
			return QueryLanguage.Throttle_<TSource>(source, dueTime, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<TSource> Throttle<TSource>(IObservable<TSource> source, TimeSpan dueTime, IScheduler scheduler)
		{
			return QueryLanguage.Throttle_<TSource>(source, dueTime, scheduler);
		}

		private static IObservable<TSource> Throttle_<TSource>(IObservable<TSource> source, TimeSpan dueTime, object scheduler)
		{
			return new Throttle<TSource>(source, dueTime, scheduler);
		}

		public virtual IObservable<TSource> Throttle<TSource, T>(IObservable<TSource> source, Func<TSource, IObservable<T>> throttleDurationSelector)
		{
			return new Throttle<TSource, T>(source, throttleDurationSelector);
		}

		public virtual IObservable<TimeInterval<TSource>> TimeInterval<TSource>(IObservable<TSource> source)
		{
			return QueryLanguage.TimeInterval_<TSource>(source, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<TimeInterval<TSource>> TimeInterval<TSource>(IObservable<TSource> source, IScheduler scheduler)
		{
			return QueryLanguage.TimeInterval_<TSource>(source, scheduler);
		}

		private static IObservable<TimeInterval<TSource>> TimeInterval_<TSource>(IObservable<TSource> source, object scheduler)
		{
			return new TimeInterval<TSource>(source, scheduler);
		}

		public virtual IObservable<TSource> Timeout<TSource>(IObservable<TSource> source, TimeSpan dueTime)
		{
			return QueryLanguage.Timeout_<TSource>(source, dueTime, Observable.Throw<TSource>(new TimeoutException()), SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<TSource> Timeout<TSource>(IObservable<TSource> source, TimeSpan dueTime, IScheduler scheduler)
		{
			return QueryLanguage.Timeout_<TSource>(source, dueTime, Observable.Throw<TSource>(new TimeoutException()), scheduler);
		}

		public virtual IObservable<TSource> Timeout<TSource>(IObservable<TSource> source, TimeSpan dueTime, IObservable<TSource> other)
		{
			return QueryLanguage.Timeout_<TSource>(source, dueTime, other, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<TSource> Timeout<TSource>(IObservable<TSource> source, TimeSpan dueTime, IObservable<TSource> other, IScheduler scheduler)
		{
			return QueryLanguage.Timeout_<TSource>(source, dueTime, other, scheduler);
		}

		private static IObservable<TSource> Timeout_<TSource>(IObservable<TSource> source, TimeSpan dueTime, IObservable<TSource> other, object scheduler)
		{
			return new Timeout<TSource>.Relative(source, dueTime, other, scheduler);
		}

		public virtual IObservable<TSource> Timeout<TSource>(IObservable<TSource> source, DateTimeOffset dueTime)
		{
			return QueryLanguage.Timeout_<TSource>(source, dueTime, Observable.Throw<TSource>(new TimeoutException()), SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<TSource> Timeout<TSource>(IObservable<TSource> source, DateTimeOffset dueTime, IScheduler scheduler)
		{
			return QueryLanguage.Timeout_<TSource>(source, dueTime, Observable.Throw<TSource>(new TimeoutException()), scheduler);
		}

		public virtual IObservable<TSource> Timeout<TSource>(IObservable<TSource> source, DateTimeOffset dueTime, IObservable<TSource> other)
		{
			return QueryLanguage.Timeout_<TSource>(source, dueTime, other, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<TSource> Timeout<TSource>(IObservable<TSource> source, DateTimeOffset dueTime, IObservable<TSource> other, IScheduler scheduler)
		{
			return QueryLanguage.Timeout_<TSource>(source, dueTime, other, scheduler);
		}

		private static IObservable<TSource> Timeout_<TSource>(IObservable<TSource> source, DateTimeOffset dueTime, IObservable<TSource> other, object scheduler)
		{
			return new Timeout<TSource>.Absolute(source, dueTime, other, scheduler);
		}

		public virtual IObservable<TSource> Timeout<TSource, TTimeout>(IObservable<TSource> source, Func<TSource, IObservable<TTimeout>> timeoutDurationSelector)
		{
			return QueryLanguage.Timeout_<TSource, TTimeout>(source, Observable.Never<TTimeout>(), timeoutDurationSelector, Observable.Throw<TSource>(new TimeoutException()));
		}

		public virtual IObservable<TSource> Timeout<TSource, TTimeout>(IObservable<TSource> source, Func<TSource, IObservable<TTimeout>> timeoutDurationSelector, IObservable<TSource> other)
		{
			return QueryLanguage.Timeout_<TSource, TTimeout>(source, Observable.Never<TTimeout>(), timeoutDurationSelector, other);
		}

		public virtual IObservable<TSource> Timeout<TSource, TTimeout>(IObservable<TSource> source, IObservable<TTimeout> firstTimeout, Func<TSource, IObservable<TTimeout>> timeoutDurationSelector)
		{
			return QueryLanguage.Timeout_<TSource, TTimeout>(source, firstTimeout, timeoutDurationSelector, Observable.Throw<TSource>(new TimeoutException()));
		}

		public virtual IObservable<TSource> Timeout<TSource, TTimeout>(IObservable<TSource> source, IObservable<TTimeout> firstTimeout, Func<TSource, IObservable<TTimeout>> timeoutDurationSelector, IObservable<TSource> other)
		{
			return QueryLanguage.Timeout_<TSource, TTimeout>(source, firstTimeout, timeoutDurationSelector, other);
		}

		private static IObservable<TSource> Timeout_<TSource, TTimeout>(IObservable<TSource> source, IObservable<TTimeout> firstTimeout, Func<TSource, IObservable<TTimeout>> timeoutDurationSelector, IObservable<TSource> other)
		{
			return new Timeout<TSource, TTimeout>(source, firstTimeout, timeoutDurationSelector, other);
		}

		public virtual IObservable<long> Timer(TimeSpan dueTime)
		{
			return new global::System.Reactive.Linq.ObservableImpl.Timer.Single.Relative(dueTime, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<long> Timer(DateTimeOffset dueTime)
		{
			return new global::System.Reactive.Linq.ObservableImpl.Timer.Single.Absolute(dueTime, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<long> Timer(TimeSpan dueTime, TimeSpan period)
		{
			return new global::System.Reactive.Linq.ObservableImpl.Timer.Periodic.Relative(dueTime, period, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<long> Timer(DateTimeOffset dueTime, TimeSpan period)
		{
			return new global::System.Reactive.Linq.ObservableImpl.Timer.Periodic.Absolute(dueTime, period, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<long> Timer(TimeSpan dueTime, IScheduler scheduler)
		{
			return new global::System.Reactive.Linq.ObservableImpl.Timer.Single.Relative(dueTime, scheduler);
		}

		public virtual IObservable<long> Timer(DateTimeOffset dueTime, IScheduler scheduler)
		{
			return new global::System.Reactive.Linq.ObservableImpl.Timer.Single.Absolute(dueTime, scheduler);
		}

		public virtual IObservable<long> Timer(TimeSpan dueTime, TimeSpan period, IScheduler scheduler)
		{
			return new global::System.Reactive.Linq.ObservableImpl.Timer.Periodic.Relative(dueTime, period, scheduler);
		}

		public virtual IObservable<long> Timer(DateTimeOffset dueTime, TimeSpan period, IScheduler scheduler)
		{
			return new global::System.Reactive.Linq.ObservableImpl.Timer.Periodic.Absolute(dueTime, period, scheduler);
		}

		public virtual IObservable<Timestamped<TSource>> Timestamp<TSource>(IObservable<TSource> source)
		{
			return QueryLanguage.Timestamp_<TSource>(source, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<Timestamped<TSource>> Timestamp<TSource>(IObservable<TSource> source, IScheduler scheduler)
		{
			return QueryLanguage.Timestamp_<TSource>(source, scheduler);
		}

		private static IObservable<Timestamped<TSource>> Timestamp_<TSource>(IObservable<TSource> source, object scheduler)
		{
			return new Timestamp<TSource>(source, scheduler);
		}

		public virtual IObservable<IObservable<TSource>> Window<TSource>(IObservable<TSource> source, TimeSpan timeSpan)
		{
			return QueryLanguage.Window_<TSource>(source, timeSpan, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<IObservable<TSource>> Window<TSource>(IObservable<TSource> source, TimeSpan timeSpan, IScheduler scheduler)
		{
			return QueryLanguage.Window_<TSource>(source, timeSpan, scheduler);
		}

		private static IObservable<IObservable<TSource>> Window_<TSource>(IObservable<TSource> source, TimeSpan timeSpan, object scheduler)
		{
			return new Window<TSource>.TimeHopping(source, timeSpan, scheduler);
		}

		public virtual IObservable<IObservable<TSource>> Window<TSource>(IObservable<TSource> source, TimeSpan timeSpan, TimeSpan timeShift)
		{
			return QueryLanguage.Window_<TSource>(source, timeSpan, timeShift, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<IObservable<TSource>> Window<TSource>(IObservable<TSource> source, TimeSpan timeSpan, TimeSpan timeShift, IScheduler scheduler)
		{
			return QueryLanguage.Window_<TSource>(source, timeSpan, timeShift, scheduler);
		}

		private static IObservable<IObservable<TSource>> Window_<TSource>(IObservable<TSource> source, TimeSpan timeSpan, TimeSpan timeShift, object scheduler)
		{
			return new Window<TSource>.TimeSliding(source, timeSpan, timeShift, scheduler);
		}

		public virtual IObservable<IObservable<TSource>> Window<TSource>(IObservable<TSource> source, TimeSpan timeSpan, int count)
		{
			return QueryLanguage.Window_<TSource>(source, timeSpan, count, SchedulerDefaults.TimeBasedOperations);
		}

		public virtual IObservable<IObservable<TSource>> Window<TSource>(IObservable<TSource> source, TimeSpan timeSpan, int count, IScheduler scheduler)
		{
			return QueryLanguage.Window_<TSource>(source, timeSpan, count, scheduler);
		}

		private static IObservable<IObservable<TSource>> Window_<TSource>(IObservable<TSource> source, TimeSpan timeSpan, int count, object scheduler)
		{
			return new Window<TSource>.Ferry(source, timeSpan, count, scheduler);
		}

		private sealed class StartAsyncObservable<TSource> : ObservableBase<TSource>
		{
			public StartAsyncObservable(CancellationDisposable cancellable, IObservable<TSource> result)
			{
				this._cancellable = cancellable;
				this._result = result;
			}

			protected override IDisposable SubscribeCore(IObserver<TSource> observer)
			{
				IDisposable disposable = this._result.Subscribe(observer);
				return StableCompositeDisposable.Create(this._cancellable, disposable);
			}

			private readonly CancellationDisposable _cancellable;

			private readonly IObservable<TSource> _result;
		}

		private class WaitAndSetOnce : IDisposable
		{
			public WaitAndSetOnce()
			{
				this._evt = new ManualResetEvent(false);
			}

			public void Set()
			{
				if (Interlocked.Exchange(ref this._hasSet, 1) == 0)
				{
					this._evt.Set();
				}
			}

			public void WaitOne()
			{
				this._evt.WaitOne();
			}

			public void Dispose()
			{
				this._evt.Dispose();
			}

			private readonly object _evt;

			private int _hasSet;
		}

		private sealed class CreateWithDisposableObservable<TSource> : ObservableBase<TSource>
		{
			public CreateWithDisposableObservable(Func<IObserver<TSource>, IDisposable> subscribe)
			{
				this._subscribe = subscribe;
			}

			protected override IDisposable SubscribeCore(IObserver<TSource> observer)
			{
				return this._subscribe(observer) ?? Disposable.Empty;
			}

			private readonly Func<IObserver<TSource>, IDisposable> _subscribe;
		}

		private sealed class CreateWithActionDisposable<TSource> : ObservableBase<TSource>
		{
			public CreateWithActionDisposable(Func<IObserver<TSource>, Action> subscribe)
			{
				this._subscribe = subscribe;
			}

			protected override IDisposable SubscribeCore(IObserver<TSource> observer)
			{
				Action action = this._subscribe(observer);
				if (action == null)
				{
					return Disposable.Empty;
				}
				return Disposable.Create(action);
			}

			private readonly Func<IObserver<TSource>, Action> _subscribe;
		}

		private sealed class CreateWithTaskTokenObservable<TResult> : ObservableBase<TResult>
		{
			public CreateWithTaskTokenObservable(Func<IObserver<TResult>, CancellationToken, Task> subscribeAsync)
			{
				this._subscribeAsync = subscribeAsync;
			}

			protected override IDisposable SubscribeCore(IObserver<TResult> observer)
			{
				return new QueryLanguage.CreateWithTaskTokenObservable<TResult>.Subscription(this._subscribeAsync, observer);
			}

			private readonly Func<IObserver<TResult>, CancellationToken, Task> _subscribeAsync;

			private sealed class Subscription : IDisposable
			{
				public Subscription(Func<IObserver<TResult>, CancellationToken, Task> subscribeAsync, IObserver<TResult> observer)
				{
					this._subscription = subscribeAsync(observer, this._cts.Token).Subscribe(new QueryLanguage.CreateWithTaskTokenObservable<TResult>.Subscription.TaskCompletionObserver(observer));
				}

				public void Dispose()
				{
					this._cts.Cancel();
					this._subscription.Dispose();
				}

				private readonly IDisposable _subscription;

				private readonly CancellationTokenSource _cts = new CancellationTokenSource();

				private sealed class TaskCompletionObserver : IObserver<Unit>
				{
					public TaskCompletionObserver(IObserver<TResult> observer)
					{
						this._observer = observer;
					}

					public void OnCompleted()
					{
						this._observer.OnCompleted();
					}

					public void OnError(Exception error)
					{
						this._observer.OnError(error);
					}

					public void OnNext(Unit value)
					{
					}

					private readonly IObserver<TResult> _observer;
				}
			}
		}

		private sealed class CreateWithTaskDisposable<TResult> : ObservableBase<TResult>
		{
			public CreateWithTaskDisposable(Func<IObserver<TResult>, CancellationToken, Task<IDisposable>> subscribeAsync)
			{
				this._subscribeAsync = subscribeAsync;
			}

			protected override IDisposable SubscribeCore(IObserver<TResult> observer)
			{
				return new QueryLanguage.CreateWithTaskDisposable<TResult>.Subscription(this._subscribeAsync, observer);
			}

			private readonly Func<IObserver<TResult>, CancellationToken, Task<IDisposable>> _subscribeAsync;

			private sealed class Subscription : IDisposable
			{
				public Subscription(Func<IObserver<TResult>, CancellationToken, Task<IDisposable>> subscribeAsync, IObserver<TResult> observer)
				{
					subscribeAsync(observer, this._cts.Token).Subscribe(this._observer = new QueryLanguage.CreateWithTaskDisposable<TResult>.Subscription.TaskDisposeCompletionObserver(observer));
				}

				public void Dispose()
				{
					this._cts.Cancel();
					this._observer.Dispose();
				}

				private readonly QueryLanguage.CreateWithTaskDisposable<TResult>.Subscription.TaskDisposeCompletionObserver _observer;

				private readonly CancellationTokenSource _cts = new CancellationTokenSource();

				private sealed class TaskDisposeCompletionObserver : IObserver<IDisposable>, IDisposable
				{
					public TaskDisposeCompletionObserver(IObserver<TResult> observer)
					{
						this._observer = observer;
					}

					public void Dispose()
					{
						Disposable.TryDispose(ref this._disposable);
					}

					public void OnCompleted()
					{
					}

					public void OnError(Exception error)
					{
						this._observer.OnError(error);
					}

					public void OnNext(IDisposable value)
					{
						Disposable.SetSingle(ref this._disposable, value);
					}

					private readonly IObserver<TResult> _observer;

					private IDisposable _disposable;
				}
			}
		}

		private sealed class CreateWithTaskActionObservable<TResult> : ObservableBase<TResult>
		{
			public CreateWithTaskActionObservable(Func<IObserver<TResult>, CancellationToken, Task<Action>> subscribeAsync)
			{
				this._subscribeAsync = subscribeAsync;
			}

			protected override IDisposable SubscribeCore(IObserver<TResult> observer)
			{
				return new QueryLanguage.CreateWithTaskActionObservable<TResult>.Subscription(this._subscribeAsync, observer);
			}

			private readonly Func<IObserver<TResult>, CancellationToken, Task<Action>> _subscribeAsync;

			private sealed class Subscription : IDisposable
			{
				public Subscription(Func<IObserver<TResult>, CancellationToken, Task<Action>> subscribeAsync, IObserver<TResult> observer)
				{
					subscribeAsync(observer, this._cts.Token).Subscribe(this._observer = new QueryLanguage.CreateWithTaskActionObservable<TResult>.Subscription.TaskDisposeCompletionObserver(observer));
				}

				public void Dispose()
				{
					this._cts.Cancel();
					this._observer.Dispose();
				}

				private readonly QueryLanguage.CreateWithTaskActionObservable<TResult>.Subscription.TaskDisposeCompletionObserver _observer;

				private readonly CancellationTokenSource _cts = new CancellationTokenSource();

				private sealed class TaskDisposeCompletionObserver : IObserver<Action>, IDisposable
				{
					public TaskDisposeCompletionObserver(IObserver<TResult> observer)
					{
						this._observer = observer;
					}

					public void Dispose()
					{
						Action action = Interlocked.Exchange<Action>(ref this._disposable, Stubs.Nop);
						if (action == null)
						{
							return;
						}
						action();
					}

					public void OnCompleted()
					{
					}

					public void OnError(Exception error)
					{
						this._observer.OnError(error);
					}

					public void OnNext(Action value)
					{
						if (Interlocked.CompareExchange<Action>(ref this._disposable, value, null) != null && value != null)
						{
							value();
						}
					}

					private readonly IObserver<TResult> _observer;

					private Action _disposable;
				}
			}
		}

		private sealed class WhenObservable<TResult> : ObservableBase<TResult>
		{
			public WhenObservable(IEnumerable<Plan<TResult>> plans)
			{
				this._plans = plans;
			}

			protected override IDisposable SubscribeCore(IObserver<TResult> observer)
			{
				QueryLanguage.WhenObservable<TResult>.<>c__DisplayClass2_0 CS$<>8__locals1 = new QueryLanguage.WhenObservable<TResult>.<>c__DisplayClass2_0();
				Dictionary<object, IJoinObserver> dictionary = new Dictionary<object, IJoinObserver>();
				object obj = new object();
				CS$<>8__locals1.activePlans = new List<ActivePlan>();
				CS$<>8__locals1.outObserver = new QueryLanguage.WhenObservable<TResult>.OutObserver(observer, dictionary);
				IDisposable empty;
				try
				{
					foreach (Plan<TResult> plan in this._plans)
					{
						CS$<>8__locals1.activePlans.Add(plan.Activate(dictionary, CS$<>8__locals1.outObserver, new Action<ActivePlan>(CS$<>8__locals1.method_0)));
					}
					goto IL_0097;
				}
				catch (Exception ex)
				{
					observer.OnError(ex);
					empty = Disposable.Empty;
				}
				return empty;
				IL_0097:
				CompositeDisposable compositeDisposable = new CompositeDisposable(dictionary.Values.Count);
				foreach (IJoinObserver joinObserver in dictionary.Values)
				{
					joinObserver.Subscribe(obj);
					compositeDisposable.Add(joinObserver);
				}
				return compositeDisposable;
			}

			private readonly IEnumerable<Plan<TResult>> _plans;

			private sealed class OutObserver : IObserver<TResult>
			{
				public OutObserver(IObserver<TResult> observer, Dictionary<object, IJoinObserver> externalSubscriptions)
				{
					this._observer = observer;
					this._externalSubscriptions = externalSubscriptions;
				}

				public void OnCompleted()
				{
					this._observer.OnCompleted();
				}

				public void OnError(Exception exception)
				{
					foreach (IJoinObserver joinObserver in this._externalSubscriptions.Values)
					{
						joinObserver.Dispose();
					}
					this._observer.OnError(exception);
				}

				public void OnNext(TResult value)
				{
					this._observer.OnNext(value);
				}

				private readonly IObserver<TResult> _observer;

				private readonly Dictionary<object, IJoinObserver> _externalSubscriptions;
			}
		}
	}
}
