﻿using System;
using System.Reactive.Disposables;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class Zip<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, TResult> : Producer<TResult, Zip<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, TResult>._>
	{
		public Zip(IObservable<T1> source1, IObservable<T2> source2, IObservable<T3> source3, IObservable<T4> source4, IObservable<T5> source5, IObservable<T6> source6, IObservable<T7> source7, IObservable<T8> source8, IObservable<T9> source9, IObservable<T10> source10, IObservable<T11> source11, IObservable<T12> source12, IObservable<T13> source13, Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, TResult> resultSelector)
		{
			this._source1 = source1;
			this._source2 = source2;
			this._source3 = source3;
			this._source4 = source4;
			this._source5 = source5;
			this._source6 = source6;
			this._source7 = source7;
			this._source8 = source8;
			this._source9 = source9;
			this._source10 = source10;
			this._source11 = source11;
			this._source12 = source12;
			this._source13 = source13;
			this._resultSelector = resultSelector;
		}

		protected override Zip<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, TResult>._ CreateSink(IObserver<TResult> observer)
		{
			return new Zip<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, TResult>._(this._resultSelector, observer);
		}

		protected override void Run(Zip<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, TResult>._ sink)
		{
			sink.Run(this._source1, this._source2, this._source3, this._source4, this._source5, this._source6, this._source7, this._source8, this._source9, this._source10, this._source11, this._source12, this._source13);
		}

		private readonly IObservable<T1> _source1;

		private readonly IObservable<T2> _source2;

		private readonly IObservable<T3> _source3;

		private readonly IObservable<T4> _source4;

		private readonly IObservable<T5> _source5;

		private readonly IObservable<T6> _source6;

		private readonly IObservable<T7> _source7;

		private readonly IObservable<T8> _source8;

		private readonly IObservable<T9> _source9;

		private readonly IObservable<T10> _source10;

		private readonly IObservable<T11> _source11;

		private readonly IObservable<T12> _source12;

		private readonly IObservable<T13> _source13;

		private readonly Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, TResult> _resultSelector;

		internal sealed class _ : ZipSink<TResult>
		{
			public _(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, TResult> resultSelector, IObserver<TResult> observer)
				: base(13, observer)
			{
				this._resultSelector = resultSelector;
			}

			public void Run(IObservable<T1> source1, IObservable<T2> source2, IObservable<T3> source3, IObservable<T4> source4, IObservable<T5> source5, IObservable<T6> source6, IObservable<T7> source7, IObservable<T8> source8, IObservable<T9> source9, IObservable<T10> source10, IObservable<T11> source11, IObservable<T12> source12, IObservable<T13> source13)
			{
				IDisposable[] array = new IDisposable[13];
				this._observer1 = new ZipObserver<T1>(this._gate, this, 0);
				array[0] = this._observer1;
				base.Queues[0] = this._observer1.Values;
				this._observer2 = new ZipObserver<T2>(this._gate, this, 1);
				array[1] = this._observer2;
				base.Queues[1] = this._observer2.Values;
				this._observer3 = new ZipObserver<T3>(this._gate, this, 2);
				array[2] = this._observer3;
				base.Queues[2] = this._observer3.Values;
				this._observer4 = new ZipObserver<T4>(this._gate, this, 3);
				array[3] = this._observer4;
				base.Queues[3] = this._observer4.Values;
				this._observer5 = new ZipObserver<T5>(this._gate, this, 4);
				array[4] = this._observer5;
				base.Queues[4] = this._observer5.Values;
				this._observer6 = new ZipObserver<T6>(this._gate, this, 5);
				array[5] = this._observer6;
				base.Queues[5] = this._observer6.Values;
				this._observer7 = new ZipObserver<T7>(this._gate, this, 6);
				array[6] = this._observer7;
				base.Queues[6] = this._observer7.Values;
				this._observer8 = new ZipObserver<T8>(this._gate, this, 7);
				array[7] = this._observer8;
				base.Queues[7] = this._observer8.Values;
				this._observer9 = new ZipObserver<T9>(this._gate, this, 8);
				array[8] = this._observer9;
				base.Queues[8] = this._observer9.Values;
				this._observer10 = new ZipObserver<T10>(this._gate, this, 9);
				array[9] = this._observer10;
				base.Queues[9] = this._observer10.Values;
				this._observer11 = new ZipObserver<T11>(this._gate, this, 10);
				array[10] = this._observer11;
				base.Queues[10] = this._observer11.Values;
				this._observer12 = new ZipObserver<T12>(this._gate, this, 11);
				array[11] = this._observer12;
				base.Queues[11] = this._observer12.Values;
				this._observer13 = new ZipObserver<T13>(this._gate, this, 12);
				array[12] = this._observer13;
				base.Queues[12] = this._observer13.Values;
				this._observer1.SetResource(source1.SubscribeSafe(this._observer1));
				this._observer2.SetResource(source2.SubscribeSafe(this._observer2));
				this._observer3.SetResource(source3.SubscribeSafe(this._observer3));
				this._observer4.SetResource(source4.SubscribeSafe(this._observer4));
				this._observer5.SetResource(source5.SubscribeSafe(this._observer5));
				this._observer6.SetResource(source6.SubscribeSafe(this._observer6));
				this._observer7.SetResource(source7.SubscribeSafe(this._observer7));
				this._observer8.SetResource(source8.SubscribeSafe(this._observer8));
				this._observer9.SetResource(source9.SubscribeSafe(this._observer9));
				this._observer10.SetResource(source10.SubscribeSafe(this._observer10));
				this._observer11.SetResource(source11.SubscribeSafe(this._observer11));
				this._observer12.SetResource(source12.SubscribeSafe(this._observer12));
				this._observer13.SetResource(source13.SubscribeSafe(this._observer13));
				base.SetUpstream(StableCompositeDisposable.CreateTrusted(array));
			}

			protected override TResult GetResult()
			{
				return this._resultSelector(this._observer1.Values.Dequeue(), this._observer2.Values.Dequeue(), this._observer3.Values.Dequeue(), this._observer4.Values.Dequeue(), this._observer5.Values.Dequeue(), this._observer6.Values.Dequeue(), this._observer7.Values.Dequeue(), this._observer8.Values.Dequeue(), this._observer9.Values.Dequeue(), this._observer10.Values.Dequeue(), this._observer11.Values.Dequeue(), this._observer12.Values.Dequeue(), this._observer13.Values.Dequeue());
			}

			private readonly Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, TResult> _resultSelector;

			private ZipObserver<T1> _observer1;

			private ZipObserver<T2> _observer2;

			private ZipObserver<T3> _observer3;

			private ZipObserver<T4> _observer4;

			private ZipObserver<T5> _observer5;

			private ZipObserver<T6> _observer6;

			private ZipObserver<T7> _observer7;

			private ZipObserver<T8> _observer8;

			private ZipObserver<T9> _observer9;

			private ZipObserver<T10> _observer10;

			private ZipObserver<T11> _observer11;

			private ZipObserver<T12> _observer12;

			private ZipObserver<T13> _observer13;
		}
	}
}
