﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class ToLookup<TSource, TKey, TElement> : Producer<ILookup<TKey, TElement>, ToLookup<TSource, TKey, TElement>._>
	{
		public ToLookup(IObservable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, IEqualityComparer<TKey> comparer)
		{
			this._source = source;
			this._keySelector = keySelector;
			this._elementSelector = elementSelector;
			this._comparer = comparer;
		}

		protected override ToLookup<TSource, TKey, TElement>._ CreateSink(IObserver<ILookup<TKey, TElement>> observer)
		{
			return new ToLookup<TSource, TKey, TElement>._(this, observer);
		}

		protected override void Run(ToLookup<TSource, TKey, TElement>._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<TSource> _source;

		private readonly Func<TSource, TKey> _keySelector;

		private readonly Func<TSource, TElement> _elementSelector;

		private readonly IEqualityComparer<TKey> _comparer;

		internal sealed class _ : Sink<TSource, ILookup<TKey, TElement>>
		{
			public _(ToLookup<TSource, TKey, TElement> parent, IObserver<ILookup<TKey, TElement>> observer)
				: base(observer)
			{
				this._keySelector = parent._keySelector;
				this._elementSelector = parent._elementSelector;
				this._lookup = new Lookup<TKey, TElement>(parent._comparer);
			}

			public override void OnNext(TSource value)
			{
				try
				{
					this._lookup.Add(this._keySelector(value), this._elementSelector(value));
				}
				catch (Exception ex)
				{
					this._lookup = null;
					base.ForwardOnError(ex);
				}
			}

			public override void OnError(Exception error)
			{
				this._lookup = null;
				base.ForwardOnError(error);
			}

			public override void OnCompleted()
			{
				Lookup<TKey, TElement> lookup = this._lookup;
				this._lookup = null;
				base.ForwardOnNext(lookup);
				base.ForwardOnCompleted();
			}

			private readonly Func<TSource, TKey> _keySelector;

			private readonly Func<TSource, TElement> _elementSelector;

			private Lookup<TKey, TElement> _lookup;
		}
	}
}
