﻿using System;
using System.Reactive.Disposables;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class ThrowImmediate<TSource> : BasicProducer<TSource>
	{
		public ThrowImmediate(Exception exception)
		{
			this._exception = exception;
		}

		protected override IDisposable Run(IObserver<TSource> observer)
		{
			observer.OnError(this._exception);
			return Disposable.Empty;
		}

		private readonly Exception _exception;
	}
}
