﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class SumSingleNullable : Producer<float?, SumSingleNullable._>
	{
		public SumSingleNullable(IObservable<float?> source)
		{
			this._source = source;
		}

		protected override SumSingleNullable._ CreateSink(IObserver<float?> observer)
		{
			return new SumSingleNullable._(observer);
		}

		protected override void Run(SumSingleNullable._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<float?> _source;

		internal sealed class _ : IdentitySink<float?>
		{
			public _(IObserver<float?> observer)
				: base(observer)
			{
			}

			public override void OnNext(float? value)
			{
				if (value != null)
				{
					this._sum += (double)value.Value;
				}
			}

			public override void OnCompleted()
			{
				base.ForwardOnNext(new float?((float)this._sum));
				base.ForwardOnCompleted();
			}

			private double _sum;
		}
	}
}
