﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class SumSingle : Producer<float, SumSingle._>
	{
		public SumSingle(IObservable<float> source)
		{
			this._source = source;
		}

		protected override SumSingle._ CreateSink(IObserver<float> observer)
		{
			return new SumSingle._(observer);
		}

		protected override void Run(SumSingle._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<float> _source;

		internal sealed class _ : IdentitySink<float>
		{
			public _(IObserver<float> observer)
				: base(observer)
			{
			}

			public override void OnNext(float value)
			{
				this._sum += (double)value;
			}

			public override void OnCompleted()
			{
				base.ForwardOnNext((float)this._sum);
				base.ForwardOnCompleted();
			}

			private double _sum;
		}
	}
}
