﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class SumDoubleNullable : Producer<double?, SumDoubleNullable._>
	{
		public SumDoubleNullable(IObservable<double?> source)
		{
			this._source = source;
		}

		protected override SumDoubleNullable._ CreateSink(IObserver<double?> observer)
		{
			return new SumDoubleNullable._(observer);
		}

		protected override void Run(SumDoubleNullable._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<double?> _source;

		internal sealed class _ : IdentitySink<double?>
		{
			public _(IObserver<double?> observer)
				: base(observer)
			{
			}

			public override void OnNext(double? value)
			{
				if (value != null)
				{
					this._sum += value.Value;
				}
			}

			public override void OnCompleted()
			{
				base.ForwardOnNext(new double?(this._sum));
				base.ForwardOnCompleted();
			}

			private double _sum;
		}
	}
}
