﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class SumDouble : Producer<double, SumDouble._>
	{
		public SumDouble(IObservable<double> source)
		{
			this._source = source;
		}

		protected override SumDouble._ CreateSink(IObserver<double> observer)
		{
			return new SumDouble._(observer);
		}

		protected override void Run(SumDouble._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<double> _source;

		internal sealed class _ : IdentitySink<double>
		{
			public _(IObserver<double> observer)
				: base(observer)
			{
			}

			public override void OnNext(double value)
			{
				this._sum += value;
			}

			public override void OnCompleted()
			{
				base.ForwardOnNext(this._sum);
				base.ForwardOnCompleted();
			}

			private double _sum;
		}
	}
}
