﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class SumDecimalNullable : Producer<decimal?, SumDecimalNullable._>
	{
		public SumDecimalNullable(IObservable<decimal?> source)
		{
			this._source = source;
		}

		protected override SumDecimalNullable._ CreateSink(IObserver<decimal?> observer)
		{
			return new SumDecimalNullable._(observer);
		}

		protected override void Run(SumDecimalNullable._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<decimal?> _source;

		internal sealed class _ : IdentitySink<decimal?>
		{
			public _(IObserver<decimal?> observer)
				: base(observer)
			{
			}

			public override void OnNext(decimal? value)
			{
				if (value != null)
				{
					this._sum += value.Value;
				}
			}

			public override void OnCompleted()
			{
				base.ForwardOnNext(new decimal?(this._sum));
				base.ForwardOnCompleted();
			}

			private decimal _sum;
		}
	}
}
