﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class SumDecimal : Producer<decimal, SumDecimal._>
	{
		public SumDecimal(IObservable<decimal> source)
		{
			this._source = source;
		}

		protected override SumDecimal._ CreateSink(IObserver<decimal> observer)
		{
			return new SumDecimal._(observer);
		}

		protected override void Run(SumDecimal._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<decimal> _source;

		internal sealed class _ : IdentitySink<decimal>
		{
			public _(IObserver<decimal> observer)
				: base(observer)
			{
			}

			public override void OnNext(decimal value)
			{
				this._sum += value;
			}

			public override void OnCompleted()
			{
				base.ForwardOnNext(this._sum);
				base.ForwardOnCompleted();
			}

			private decimal _sum;
		}
	}
}
