﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal static class SkipWhile<TSource>
	{
		internal sealed class Predicate : Producer<TSource, SkipWhile<TSource>.Predicate._>
		{
			public Predicate(IObservable<TSource> source, Func<TSource, bool> predicate)
			{
				this._source = source;
				this._predicate = predicate;
			}

			protected override SkipWhile<TSource>.Predicate._ CreateSink(IObserver<TSource> observer)
			{
				return new SkipWhile<TSource>.Predicate._(this._predicate, observer);
			}

			protected override void Run(SkipWhile<TSource>.Predicate._ sink)
			{
				sink.Run(this._source);
			}

			private readonly IObservable<TSource> _source;

			private readonly Func<TSource, bool> _predicate;

			internal sealed class _ : IdentitySink<TSource>
			{
				public _(Func<TSource, bool> predicate, IObserver<TSource> observer)
					: base(observer)
				{
					this._predicate = predicate;
				}

				public override void OnNext(TSource value)
				{
					if (this._predicate != null)
					{
						bool flag = false;
						try
						{
							flag = !this._predicate(value);
						}
						catch (Exception ex)
						{
							base.ForwardOnError(ex);
							return;
						}
						if (flag)
						{
							this._predicate = null;
							base.ForwardOnNext(value);
							return;
						}
					}
					else
					{
						base.ForwardOnNext(value);
					}
				}

				private Func<TSource, bool> _predicate;
			}
		}

		internal sealed class PredicateIndexed : Producer<TSource, SkipWhile<TSource>.PredicateIndexed._>
		{
			public PredicateIndexed(IObservable<TSource> source, Func<TSource, int, bool> predicate)
			{
				this._source = source;
				this._predicate = predicate;
			}

			protected override SkipWhile<TSource>.PredicateIndexed._ CreateSink(IObserver<TSource> observer)
			{
				return new SkipWhile<TSource>.PredicateIndexed._(this._predicate, observer);
			}

			protected override void Run(SkipWhile<TSource>.PredicateIndexed._ sink)
			{
				sink.Run(this._source);
			}

			private readonly IObservable<TSource> _source;

			private readonly Func<TSource, int, bool> _predicate;

			internal sealed class _ : IdentitySink<TSource>
			{
				public _(Func<TSource, int, bool> predicate, IObserver<TSource> observer)
					: base(observer)
				{
					this._predicate = predicate;
				}

				public override void OnNext(TSource value)
				{
					if (this._predicate != null)
					{
						bool flag = false;
						try
						{
							Func<TSource, int, bool> predicate = this._predicate;
							int index = this._index;
							this._index = checked(index + 1);
							flag = !predicate(value, index);
						}
						catch (Exception ex)
						{
							base.ForwardOnError(ex);
							return;
						}
						if (flag)
						{
							this._predicate = null;
							base.ForwardOnNext(value);
							return;
						}
					}
					else
					{
						base.ForwardOnNext(value);
					}
				}

				private Func<TSource, int, bool> _predicate;

				private int _index;
			}
		}
	}
}
