﻿using System;
using System.Reactive.Disposables;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class ReturnImmediate<TSource> : BasicProducer<TSource>
	{
		public ReturnImmediate(TSource value)
		{
			this._value = value;
		}

		protected override IDisposable Run(IObserver<TSource> observer)
		{
			observer.OnNext(this._value);
			observer.OnCompleted();
			return Disposable.Empty;
		}

		private readonly TSource _value;
	}
}
