﻿using System;
using System.Reactive.Concurrency;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class Return<TResult> : Producer<TResult, Return<TResult>._>
	{
		public Return(TResult value, IScheduler scheduler)
		{
			this._value = value;
			this._scheduler = scheduler;
		}

		protected override Return<TResult>._ CreateSink(IObserver<TResult> observer)
		{
			return new Return<TResult>._(this._value, observer);
		}

		protected override void Run(Return<TResult>._ sink)
		{
			sink.Run(this._scheduler);
		}

		private readonly TResult _value;

		private readonly IScheduler _scheduler;

		internal sealed class _ : IdentitySink<TResult>
		{
			public _(TResult value, IObserver<TResult> observer)
				: base(observer)
			{
				this._value = value;
			}

			public void Run(IScheduler scheduler)
			{
				base.SetUpstream(scheduler.ScheduleAction(this, delegate(Return<TResult>._ @this)
				{
					@this.Invoke();
				}));
			}

			private void Invoke()
			{
				base.ForwardOnNext(this._value);
				base.ForwardOnCompleted();
			}

			private readonly TResult _value;
		}
	}
}
