﻿using System;
using System.Collections;
using System.Collections.Generic;

namespace System.Reactive.Linq.ObservableImpl
{
	internal abstract class PushToPullAdapter<TSource, TResult> : IEnumerable<TResult>, IEnumerable
	{
		protected PushToPullAdapter(IObservable<TSource> source)
		{
			this._source = source;
		}

		IEnumerator IEnumerable.GetEnumerator()
		{
			return this.GetEnumerator();
		}

		public IEnumerator<TResult> GetEnumerator()
		{
			PushToPullSink<TSource, TResult> pushToPullSink = this.Run();
			pushToPullSink.SetUpstream(this._source.SubscribeSafe(pushToPullSink));
			return pushToPullSink;
		}

		protected abstract PushToPullSink<TSource, TResult> Run();

		private readonly IObservable<TSource> _source;
	}
}
