﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class OfType<TSource, TResult> : Producer<TResult, OfType<TSource, TResult>._>
	{
		public OfType(IObservable<TSource> source)
		{
			this._source = source;
		}

		protected override OfType<TSource, TResult>._ CreateSink(IObserver<TResult> observer)
		{
			return new OfType<TSource, TResult>._(observer);
		}

		protected override void Run(OfType<TSource, TResult>._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<TSource> _source;

		internal sealed class _ : Sink<TSource, TResult>
		{
			public _(IObserver<TResult> observer)
				: base(observer)
			{
			}

			public override void OnNext(TSource value)
			{
				if (value is TResult)
				{
					TResult tresult = value as TResult;
					base.ForwardOnNext(tresult);
				}
			}
		}
	}
}
