﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class MinInt64Nullable : Producer<long?, MinInt64Nullable._>
	{
		public MinInt64Nullable(IObservable<long?> source)
		{
			this._source = source;
		}

		protected override MinInt64Nullable._ CreateSink(IObserver<long?> observer)
		{
			return new MinInt64Nullable._(observer);
		}

		protected override void Run(MinInt64Nullable._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<long?> _source;

		internal sealed class _ : IdentitySink<long?>
		{
			public _(IObserver<long?> observer)
				: base(observer)
			{
			}

			public override void OnNext(long? value)
			{
				if (value == null)
				{
					return;
				}
				if (this._lastValue != null)
				{
					long? num = value;
					long? lastValue = this._lastValue;
					if ((num.GetValueOrDefault() < lastValue.GetValueOrDefault()) & ((num != null) & (lastValue != null)))
					{
						this._lastValue = value;
						return;
					}
				}
				else
				{
					this._lastValue = value;
				}
			}

			public override void OnCompleted()
			{
				base.ForwardOnNext(this._lastValue);
				base.ForwardOnCompleted();
			}

			private long? _lastValue;
		}
	}
}
