﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class MinInt32Nullable : Producer<int?, MinInt32Nullable._>
	{
		public MinInt32Nullable(IObservable<int?> source)
		{
			this._source = source;
		}

		protected override MinInt32Nullable._ CreateSink(IObserver<int?> observer)
		{
			return new MinInt32Nullable._(observer);
		}

		protected override void Run(MinInt32Nullable._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<int?> _source;

		internal sealed class _ : IdentitySink<int?>
		{
			public _(IObserver<int?> observer)
				: base(observer)
			{
			}

			public override void OnNext(int? value)
			{
				if (value == null)
				{
					return;
				}
				if (this._lastValue != null)
				{
					int? num = value;
					int? lastValue = this._lastValue;
					if ((num.GetValueOrDefault() < lastValue.GetValueOrDefault()) & ((num != null) & (lastValue != null)))
					{
						this._lastValue = value;
						return;
					}
				}
				else
				{
					this._lastValue = value;
				}
			}

			public override void OnCompleted()
			{
				base.ForwardOnNext(this._lastValue);
				base.ForwardOnCompleted();
			}

			private int? _lastValue;
		}
	}
}
