﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class MinDoubleNullable : Producer<double?, MinDoubleNullable._>
	{
		public MinDoubleNullable(IObservable<double?> source)
		{
			this._source = source;
		}

		protected override MinDoubleNullable._ CreateSink(IObserver<double?> observer)
		{
			return new MinDoubleNullable._(observer);
		}

		protected override void Run(MinDoubleNullable._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<double?> _source;

		internal sealed class _ : IdentitySink<double?>
		{
			public _(IObserver<double?> observer)
				: base(observer)
			{
			}

			public override void OnNext(double? value)
			{
				if (value == null)
				{
					return;
				}
				if (this._lastValue != null)
				{
					double? num = value;
					double? lastValue = this._lastValue;
					if (((num.GetValueOrDefault() < lastValue.GetValueOrDefault()) & ((num != null) & (lastValue != null))) || double.IsNaN(value.Value))
					{
						this._lastValue = value;
						return;
					}
				}
				else
				{
					this._lastValue = value;
				}
			}

			public override void OnCompleted()
			{
				base.ForwardOnNext(this._lastValue);
				base.ForwardOnCompleted();
			}

			private double? _lastValue;
		}
	}
}
