﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class MaxSingleNullable : Producer<float?, MaxSingleNullable._>
	{
		public MaxSingleNullable(IObservable<float?> source)
		{
			this._source = source;
		}

		protected override MaxSingleNullable._ CreateSink(IObserver<float?> observer)
		{
			return new MaxSingleNullable._(observer);
		}

		protected override void Run(MaxSingleNullable._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<float?> _source;

		internal sealed class _ : IdentitySink<float?>
		{
			public _(IObserver<float?> observer)
				: base(observer)
			{
			}

			public override void OnNext(float? value)
			{
				if (value == null)
				{
					return;
				}
				if (this._lastValue != null)
				{
					float? num = value;
					float? lastValue = this._lastValue;
					if (((num.GetValueOrDefault() > lastValue.GetValueOrDefault()) & ((num != null) & (lastValue != null))) || float.IsNaN(value.Value))
					{
						this._lastValue = value;
						return;
					}
				}
				else
				{
					this._lastValue = value;
				}
			}

			public override void OnCompleted()
			{
				base.ForwardOnNext(this._lastValue);
				base.ForwardOnCompleted();
			}

			private float? _lastValue;
		}
	}
}
