﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class MaxDecimalNullable : Producer<decimal?, MaxDecimalNullable._>
	{
		public MaxDecimalNullable(IObservable<decimal?> source)
		{
			this._source = source;
		}

		protected override MaxDecimalNullable._ CreateSink(IObserver<decimal?> observer)
		{
			return new MaxDecimalNullable._(observer);
		}

		protected override void Run(MaxDecimalNullable._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<decimal?> _source;

		internal sealed class _ : IdentitySink<decimal?>
		{
			public _(IObserver<decimal?> observer)
				: base(observer)
			{
			}

			public override void OnNext(decimal? value)
			{
				if (value == null)
				{
					return;
				}
				if (this._lastValue != null)
				{
					decimal? num = value;
					decimal? lastValue = this._lastValue;
					if ((num.GetValueOrDefault() > lastValue.GetValueOrDefault()) & ((num != null) & (lastValue != null)))
					{
						this._lastValue = value;
						return;
					}
				}
				else
				{
					this._lastValue = value;
				}
			}

			public override void OnCompleted()
			{
				base.ForwardOnNext(this._lastValue);
				base.ForwardOnCompleted();
			}

			private decimal? _lastValue;
		}
	}
}
