﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal static class LastAsync<TSource>
	{
		internal sealed class Sequence : Producer<TSource, LastAsync<TSource>.Sequence._>
		{
			public Sequence(IObservable<TSource> source)
			{
				this._source = source;
			}

			protected override LastAsync<TSource>.Sequence._ CreateSink(IObserver<TSource> observer)
			{
				return new LastAsync<TSource>.Sequence._(observer);
			}

			protected override void Run(LastAsync<TSource>.Sequence._ sink)
			{
				sink.Run(this._source);
			}

			private readonly IObservable<TSource> _source;

			internal sealed class _ : IdentitySink<TSource>
			{
				public _(IObserver<TSource> observer)
					: base(observer)
				{
				}

				public override void OnNext(TSource value)
				{
					this._value = value;
					this._seenValue = true;
				}

				public override void OnError(Exception error)
				{
					this._value = default(TSource);
					base.ForwardOnError(error);
				}

				public override void OnCompleted()
				{
					if (!this._seenValue)
					{
						base.ForwardOnError(new InvalidOperationException(Strings_Linq.NO_ELEMENTS));
						return;
					}
					TSource value = this._value;
					this._value = default(TSource);
					base.ForwardOnNext(value);
					base.ForwardOnCompleted();
				}

				private TSource _value;

				private bool _seenValue;
			}
		}

		internal sealed class Predicate : Producer<TSource, LastAsync<TSource>.Predicate._>
		{
			public Predicate(IObservable<TSource> source, Func<TSource, bool> predicate)
			{
				this._source = source;
				this._predicate = predicate;
			}

			protected override LastAsync<TSource>.Predicate._ CreateSink(IObserver<TSource> observer)
			{
				return new LastAsync<TSource>.Predicate._(this._predicate, observer);
			}

			protected override void Run(LastAsync<TSource>.Predicate._ sink)
			{
				sink.Run(this._source);
			}

			private readonly IObservable<TSource> _source;

			private readonly Func<TSource, bool> _predicate;

			internal sealed class _ : IdentitySink<TSource>
			{
				public _(Func<TSource, bool> predicate, IObserver<TSource> observer)
					: base(observer)
				{
					this._predicate = predicate;
				}

				public override void OnNext(TSource value)
				{
					bool flag = false;
					try
					{
						flag = this._predicate(value);
					}
					catch (Exception ex)
					{
						this._value = default(TSource);
						base.ForwardOnError(ex);
						return;
					}
					if (flag)
					{
						this._value = value;
						this._seenValue = true;
					}
				}

				public override void OnError(Exception error)
				{
					this._value = default(TSource);
					base.ForwardOnError(error);
				}

				public override void OnCompleted()
				{
					if (!this._seenValue)
					{
						base.ForwardOnError(new InvalidOperationException(Strings_Linq.NO_MATCHING_ELEMENTS));
						return;
					}
					TSource value = this._value;
					this._value = default(TSource);
					base.ForwardOnNext(value);
					base.ForwardOnCompleted();
				}

				private readonly Func<TSource, bool> _predicate;

				private TSource _value;

				private bool _seenValue;
			}
		}
	}
}
