﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class IsEmpty<TSource> : Producer<bool, IsEmpty<TSource>._>
	{
		public IsEmpty(IObservable<TSource> source)
		{
			this._source = source;
		}

		protected override IsEmpty<TSource>._ CreateSink(IObserver<bool> observer)
		{
			return new IsEmpty<TSource>._(observer);
		}

		protected override void Run(IsEmpty<TSource>._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<TSource> _source;

		internal sealed class _ : Sink<TSource, bool>
		{
			public _(IObserver<bool> observer)
				: base(observer)
			{
			}

			public override void OnNext(TSource value)
			{
				base.ForwardOnNext(false);
				base.ForwardOnCompleted();
			}

			public override void OnCompleted()
			{
				base.ForwardOnNext(true);
				base.ForwardOnCompleted();
			}
		}
	}
}
