﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class IgnoreElements<TSource> : Producer<TSource, IgnoreElements<TSource>._>
	{
		public IgnoreElements(IObservable<TSource> source)
		{
			this._source = source;
		}

		protected override IgnoreElements<TSource>._ CreateSink(IObserver<TSource> observer)
		{
			return new IgnoreElements<TSource>._(observer);
		}

		protected override void Run(IgnoreElements<TSource>._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<TSource> _source;

		internal sealed class _ : IdentitySink<TSource>
		{
			public _(IObserver<TSource> observer)
				: base(observer)
			{
			}

			public override void OnNext(TSource value)
			{
			}
		}
	}
}
