﻿using System;
using System.Reactive.Concurrency;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class FromEvent<T, U> : ClassicEventProducer<T, U>
	{
		public FromEvent(Action<T> addHandler, Action<T> removeHandler, IScheduler scheduler)
			: base(addHandler, removeHandler, scheduler)
		{
		}

		public FromEvent(Func<Action<U>, T> conversion, Action<T> addHandler, Action<T> removeHandler, IScheduler scheduler)
			: base(addHandler, removeHandler, scheduler)
		{
			this._conversion = conversion;
		}

		protected override T GetHandler(Action<U> onNext)
		{
			T t;
			if (this._conversion == null)
			{
				t = ReflectionUtils.CreateDelegate<T>(onNext, typeof(Action<U>).GetMethod("Invoke"));
			}
			else
			{
				t = this._conversion(onNext);
			}
			return t;
		}

		private readonly Func<Action<U>, T> _conversion;
	}
}
