﻿using System;
using System.Collections.Generic;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class For<TSource, TResult> : Producer<TResult, For<TSource, TResult>._>, IConcatenatable<TResult>
	{
		public For(IEnumerable<TSource> source, Func<TSource, IObservable<TResult>> resultSelector)
		{
			this._source = source;
			this._resultSelector = resultSelector;
		}

		protected override For<TSource, TResult>._ CreateSink(IObserver<TResult> observer)
		{
			return new For<TSource, TResult>._(observer);
		}

		protected override void Run(For<TSource, TResult>._ sink)
		{
			sink.Run(this.GetSources());
		}

		public IEnumerable<IObservable<TResult>> GetSources()
		{
			For<TSource, TResult>.<GetSources>d__5 <GetSources>d__ = new For<TSource, TResult>.<GetSources>d__5(-2);
			<GetSources>d__.<>4__this = this;
			return <GetSources>d__;
		}

		private readonly IEnumerable<TSource> _source;

		private readonly Func<TSource, IObservable<TResult>> _resultSelector;

		internal sealed class _ : ConcatSink<TResult>
		{
			public _(IObserver<TResult> observer)
				: base(observer)
			{
			}
		}
	}
}
