﻿using System;
using System.Reactive.Concurrency;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class Empty<TResult> : Producer<TResult, Empty<TResult>._>
	{
		public Empty(IScheduler scheduler)
		{
			this._scheduler = scheduler;
		}

		protected override Empty<TResult>._ CreateSink(IObserver<TResult> observer)
		{
			return new Empty<TResult>._(observer);
		}

		protected override void Run(Empty<TResult>._ sink)
		{
			sink.Run(this._scheduler);
		}

		private readonly IScheduler _scheduler;

		internal sealed class _ : IdentitySink<TResult>
		{
			public _(IObserver<TResult> observer)
				: base(observer)
			{
			}

			public void Run(IScheduler scheduler)
			{
				base.SetUpstream(scheduler.ScheduleAction(this, delegate(Empty<TResult>._ target)
				{
					target.OnCompleted();
				}));
			}
		}
	}
}
