﻿using System;
using System.Collections.Generic;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class DoWhile<TSource> : Producer<TSource, DoWhile<TSource>._>, IConcatenatable<TSource>
	{
		public DoWhile(IObservable<TSource> source, Func<bool> condition)
		{
			this._condition = condition;
			this._source = source;
		}

		protected override DoWhile<TSource>._ CreateSink(IObserver<TSource> observer)
		{
			return new DoWhile<TSource>._(observer);
		}

		protected override void Run(DoWhile<TSource>._ sink)
		{
			sink.Run(this.GetSources());
		}

		public IEnumerable<IObservable<TSource>> GetSources()
		{
			DoWhile<TSource>.<GetSources>d__5 <GetSources>d__ = new DoWhile<TSource>.<GetSources>d__5(-2);
			<GetSources>d__.<>4__this = this;
			return <GetSources>d__;
		}

		private readonly IObservable<TSource> _source;

		private readonly Func<bool> _condition;

		internal sealed class _ : ConcatSink<TSource>
		{
			public _(IObserver<TSource> observer)
				: base(observer)
			{
			}
		}
	}
}
