﻿using System;
using System.Collections.Generic;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class Contains<TSource> : Producer<bool, Contains<TSource>._>
	{
		public Contains(IObservable<TSource> source, TSource value, IEqualityComparer<TSource> comparer)
		{
			this._source = source;
			this._value = value;
			this._comparer = comparer;
		}

		protected override Contains<TSource>._ CreateSink(IObserver<bool> observer)
		{
			return new Contains<TSource>._(this, observer);
		}

		protected override void Run(Contains<TSource>._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<TSource> _source;

		private readonly TSource _value;

		private readonly IEqualityComparer<TSource> _comparer;

		internal sealed class _ : Sink<TSource, bool>
		{
			public _(Contains<TSource> parent, IObserver<bool> observer)
				: base(observer)
			{
				this._value = parent._value;
				this._comparer = parent._comparer;
			}

			public override void OnNext(TSource value)
			{
				bool flag;
				try
				{
					flag = this._comparer.Equals(value, this._value);
				}
				catch (Exception ex)
				{
					base.ForwardOnError(ex);
					return;
				}
				if (flag)
				{
					base.ForwardOnNext(true);
					base.ForwardOnCompleted();
				}
			}

			public override void OnCompleted()
			{
				base.ForwardOnNext(false);
				base.ForwardOnCompleted();
			}

			private readonly TSource _value;

			private readonly IEqualityComparer<TSource> _comparer;
		}
	}
}
