﻿using System;
using System.Collections.Generic;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class Concat<TSource> : Producer<TSource, Concat<TSource>._>, IConcatenatable<TSource>
	{
		public Concat(IEnumerable<IObservable<TSource>> sources)
		{
			this._sources = sources;
		}

		protected override Concat<TSource>._ CreateSink(IObserver<TSource> observer)
		{
			return new Concat<TSource>._(observer);
		}

		protected override void Run(Concat<TSource>._ sink)
		{
			sink.Run(this._sources);
		}

		public IEnumerable<IObservable<TSource>> GetSources()
		{
			return this._sources;
		}

		private readonly IEnumerable<IObservable<TSource>> _sources;

		internal sealed class _ : ConcatSink<TSource>
		{
			public _(IObserver<TSource> observer)
				: base(observer)
			{
			}
		}
	}
}
