﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class CombineLatestObserver<T> : SafeObserver<T>
	{
		public CombineLatestObserver(object gate, ICombineLatest parent, int index)
		{
			this._gate = gate;
			this._parent = parent;
			this._index = index;
		}

		public T Value
		{
			get
			{
				return this._value;
			}
		}

		public override void OnNext(T value)
		{
			object gate = this._gate;
			lock (gate)
			{
				this._value = value;
				this._parent.Next(this._index);
			}
		}

		public override void OnError(Exception error)
		{
			base.Dispose();
			object gate = this._gate;
			lock (gate)
			{
				this._parent.Fail(error);
			}
		}

		public override void OnCompleted()
		{
			base.Dispose();
			object gate = this._gate;
			lock (gate)
			{
				this._parent.Done(this._index);
			}
		}

		private readonly object _gate;

		private readonly ICombineLatest _parent;

		private readonly int _index;

		private T _value;
	}
}
