﻿using System;
using System.Reactive.Disposables;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class CombineLatest<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, TResult> : Producer<TResult, CombineLatest<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, TResult>._>
	{
		public CombineLatest(IObservable<T1> source1, IObservable<T2> source2, IObservable<T3> source3, IObservable<T4> source4, IObservable<T5> source5, IObservable<T6> source6, IObservable<T7> source7, IObservable<T8> source8, IObservable<T9> source9, IObservable<T10> source10, IObservable<T11> source11, IObservable<T12> source12, IObservable<T13> source13, IObservable<T14> source14, IObservable<T15> source15, Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, TResult> resultSelector)
		{
			this._source1 = source1;
			this._source2 = source2;
			this._source3 = source3;
			this._source4 = source4;
			this._source5 = source5;
			this._source6 = source6;
			this._source7 = source7;
			this._source8 = source8;
			this._source9 = source9;
			this._source10 = source10;
			this._source11 = source11;
			this._source12 = source12;
			this._source13 = source13;
			this._source14 = source14;
			this._source15 = source15;
			this._resultSelector = resultSelector;
		}

		protected override CombineLatest<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, TResult>._ CreateSink(IObserver<TResult> observer)
		{
			return new CombineLatest<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, TResult>._(this._resultSelector, observer);
		}

		protected override void Run(CombineLatest<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, TResult>._ sink)
		{
			sink.Run(this._source1, this._source2, this._source3, this._source4, this._source5, this._source6, this._source7, this._source8, this._source9, this._source10, this._source11, this._source12, this._source13, this._source14, this._source15);
		}

		private readonly IObservable<T1> _source1;

		private readonly IObservable<T2> _source2;

		private readonly IObservable<T3> _source3;

		private readonly IObservable<T4> _source4;

		private readonly IObservable<T5> _source5;

		private readonly IObservable<T6> _source6;

		private readonly IObservable<T7> _source7;

		private readonly IObservable<T8> _source8;

		private readonly IObservable<T9> _source9;

		private readonly IObservable<T10> _source10;

		private readonly IObservable<T11> _source11;

		private readonly IObservable<T12> _source12;

		private readonly IObservable<T13> _source13;

		private readonly IObservable<T14> _source14;

		private readonly IObservable<T15> _source15;

		private readonly Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, TResult> _resultSelector;

		internal sealed class _ : CombineLatestSink<TResult>
		{
			public _(Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, TResult> resultSelector, IObserver<TResult> observer)
				: base(15, observer)
			{
				this._resultSelector = resultSelector;
			}

			public void Run(IObservable<T1> source1, IObservable<T2> source2, IObservable<T3> source3, IObservable<T4> source4, IObservable<T5> source5, IObservable<T6> source6, IObservable<T7> source7, IObservable<T8> source8, IObservable<T9> source9, IObservable<T10> source10, IObservable<T11> source11, IObservable<T12> source12, IObservable<T13> source13, IObservable<T14> source14, IObservable<T15> source15)
			{
				IDisposable[] array = new IDisposable[]
				{
					this._observer1 = new CombineLatestObserver<T1>(this._gate, this, 0),
					this._observer2 = new CombineLatestObserver<T2>(this._gate, this, 1),
					this._observer3 = new CombineLatestObserver<T3>(this._gate, this, 2),
					this._observer4 = new CombineLatestObserver<T4>(this._gate, this, 3),
					this._observer5 = new CombineLatestObserver<T5>(this._gate, this, 4),
					this._observer6 = new CombineLatestObserver<T6>(this._gate, this, 5),
					this._observer7 = new CombineLatestObserver<T7>(this._gate, this, 6),
					this._observer8 = new CombineLatestObserver<T8>(this._gate, this, 7),
					this._observer9 = new CombineLatestObserver<T9>(this._gate, this, 8),
					this._observer10 = new CombineLatestObserver<T10>(this._gate, this, 9),
					this._observer11 = new CombineLatestObserver<T11>(this._gate, this, 10),
					this._observer12 = new CombineLatestObserver<T12>(this._gate, this, 11),
					this._observer13 = new CombineLatestObserver<T13>(this._gate, this, 12),
					this._observer14 = new CombineLatestObserver<T14>(this._gate, this, 13),
					this._observer15 = new CombineLatestObserver<T15>(this._gate, this, 14)
				};
				this._observer1.SetResource(source1.SubscribeSafe(this._observer1));
				this._observer2.SetResource(source2.SubscribeSafe(this._observer2));
				this._observer3.SetResource(source3.SubscribeSafe(this._observer3));
				this._observer4.SetResource(source4.SubscribeSafe(this._observer4));
				this._observer5.SetResource(source5.SubscribeSafe(this._observer5));
				this._observer6.SetResource(source6.SubscribeSafe(this._observer6));
				this._observer7.SetResource(source7.SubscribeSafe(this._observer7));
				this._observer8.SetResource(source8.SubscribeSafe(this._observer8));
				this._observer9.SetResource(source9.SubscribeSafe(this._observer9));
				this._observer10.SetResource(source10.SubscribeSafe(this._observer10));
				this._observer11.SetResource(source11.SubscribeSafe(this._observer11));
				this._observer12.SetResource(source12.SubscribeSafe(this._observer12));
				this._observer13.SetResource(source13.SubscribeSafe(this._observer13));
				this._observer14.SetResource(source14.SubscribeSafe(this._observer14));
				this._observer15.SetResource(source15.SubscribeSafe(this._observer15));
				base.SetUpstream(StableCompositeDisposable.CreateTrusted(array));
			}

			protected override TResult GetResult()
			{
				return this._resultSelector(this._observer1.Value, this._observer2.Value, this._observer3.Value, this._observer4.Value, this._observer5.Value, this._observer6.Value, this._observer7.Value, this._observer8.Value, this._observer9.Value, this._observer10.Value, this._observer11.Value, this._observer12.Value, this._observer13.Value, this._observer14.Value, this._observer15.Value);
			}

			private readonly Func<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, TResult> _resultSelector;

			private CombineLatestObserver<T1> _observer1;

			private CombineLatestObserver<T2> _observer2;

			private CombineLatestObserver<T3> _observer3;

			private CombineLatestObserver<T4> _observer4;

			private CombineLatestObserver<T5> _observer5;

			private CombineLatestObserver<T6> _observer6;

			private CombineLatestObserver<T7> _observer7;

			private CombineLatestObserver<T8> _observer8;

			private CombineLatestObserver<T9> _observer9;

			private CombineLatestObserver<T10> _observer10;

			private CombineLatestObserver<T11> _observer11;

			private CombineLatestObserver<T12> _observer12;

			private CombineLatestObserver<T13> _observer13;

			private CombineLatestObserver<T14> _observer14;

			private CombineLatestObserver<T15> _observer15;
		}
	}
}
