﻿using System;
using System.Reactive.Concurrency;
using System.Reactive.Disposables;
using System.Runtime.CompilerServices;

namespace System.Reactive.Linq.ObservableImpl
{
	internal abstract class ClassicEventProducer<T, TArgs> : EventProducer<T, TArgs>
	{
		protected ClassicEventProducer(Action<T> addHandler, Action<T> removeHandler, IScheduler scheduler)
			: base(scheduler)
		{
			this._addHandler = addHandler;
			this._removeHandler = removeHandler;
		}

		protected override IDisposable AddHandler(T handler)
		{
			this._addHandler(handler);
			return Disposable.Create<ValueTuple<Action<T>, T>>(new ValueTuple<Action<T>, T>(this._removeHandler, handler), delegate([TupleElementNames(new string[] { "_removeHandler", "handler" })] ValueTuple<Action<T>, T> tuple)
			{
				tuple.Item1(tuple.Item2);
			});
		}

		private readonly Action<T> _addHandler;

		private readonly Action<T> _removeHandler;
	}
}
