﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class Class8 : Producer<double?, Class8._>
	{
		public Class8(IObservable<long?> source)
		{
			this._source = source;
		}

		protected override Class8._ CreateSink(IObserver<double?> observer)
		{
			return new Class8._(observer);
		}

		protected override void Run(Class8._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<long?> _source;

		internal sealed class _ : Sink<long?, double?>
		{
			public _(IObserver<double?> observer)
				: base(observer)
			{
				this._sum = 0L;
				this._count = 0L;
			}

			public override void OnNext(long? value)
			{
				checked
				{
					try
					{
						if (value != null)
						{
							this._sum += value.Value;
							this._count += 1L;
						}
					}
					catch (Exception ex)
					{
						base.ForwardOnError(ex);
					}
				}
			}

			public override void OnCompleted()
			{
				if (this._count > 0L)
				{
					base.ForwardOnNext(new double?((double)this._sum / (double)this._count));
				}
				else
				{
					base.ForwardOnNext(null);
				}
				base.ForwardOnCompleted();
			}

			private long _sum;

			private long _count;
		}
	}
}
