﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class Class7 : Producer<double?, Class7._>
	{
		public Class7(IObservable<int?> source)
		{
			this._source = source;
		}

		protected override Class7._ CreateSink(IObserver<double?> observer)
		{
			return new Class7._(observer);
		}

		protected override void Run(Class7._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<int?> _source;

		internal sealed class _ : Sink<int?, double?>
		{
			public _(IObserver<double?> observer)
				: base(observer)
			{
				this._sum = 0L;
				this._count = 0L;
			}

			public override void OnNext(int? value)
			{
				checked
				{
					try
					{
						if (value != null)
						{
							this._sum += unchecked((long)value.Value);
							this._count += 1L;
						}
					}
					catch (Exception ex)
					{
						base.ForwardOnError(ex);
					}
				}
			}

			public override void OnCompleted()
			{
				if (this._count > 0L)
				{
					base.ForwardOnNext(new double?((double)this._sum / (double)this._count));
				}
				else
				{
					base.ForwardOnNext(null);
				}
				base.ForwardOnCompleted();
			}

			private long _sum;

			private long _count;
		}
	}
}
