﻿using System;
using System.Threading;

namespace System.Reactive.Linq.ObservableImpl
{
	internal abstract class BaseBlocking<T> : ManualResetEventSlim, IObserver<T>
	{
		internal BaseBlocking()
		{
		}

		public void OnCompleted()
		{
			base.Set();
		}

		public void OnError(Exception error)
		{
			this._value = default(T);
			this._error = error;
			base.Set();
		}

		public abstract void OnNext(T value);

		internal T _value;

		internal bool _hasValue;

		internal Exception _error;
	}
}
