﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class AsObservable<TSource> : Producer<TSource, AsObservable<TSource>._>, IEvaluatableObservable<TSource>
	{
		public AsObservable(IObservable<TSource> source)
		{
			this._source = source;
		}

		public IObservable<TSource> Eval()
		{
			return this._source;
		}

		protected override AsObservable<TSource>._ CreateSink(IObserver<TSource> observer)
		{
			return new AsObservable<TSource>._(observer);
		}

		protected override void Run(AsObservable<TSource>._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<TSource> _source;

		internal sealed class _ : IdentitySink<TSource>
		{
			public _(IObserver<TSource> observer)
				: base(observer)
			{
			}
		}
	}
}
