﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reactive.Disposables;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class AmbManyEnumerable<T> : BasicProducer<T>
	{
		public AmbManyEnumerable(IEnumerable<IObservable<T>> sources)
		{
			this._sources = sources;
		}

		protected override IDisposable Run(IObserver<T> observer)
		{
			IEnumerable<IObservable<T>> sources = this._sources;
			IObservable<T>[] array;
			IDisposable empty;
			try
			{
				array = sources.ToArray<IObservable<T>>();
				goto IL_0022;
			}
			catch (Exception ex)
			{
				observer.OnError(ex);
				empty = Disposable.Empty;
			}
			return empty;
			IL_0022:
			return AmbCoordinator<T>.Create(observer, array);
		}

		private readonly IEnumerable<IObservable<T>> _sources;
	}
}
