﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class AmbManyArray<T> : BasicProducer<T>
	{
		public AmbManyArray(IObservable<T>[] sources)
		{
			this._sources = sources;
		}

		protected override IDisposable Run(IObserver<T> observer)
		{
			return AmbCoordinator<T>.Create(observer, this._sources);
		}

		private readonly IObservable<T>[] _sources;
	}
}
