﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class All<TSource> : Producer<bool, All<TSource>._>
	{
		public All(IObservable<TSource> source, Func<TSource, bool> predicate)
		{
			this._source = source;
			this._predicate = predicate;
		}

		protected override All<TSource>._ CreateSink(IObserver<bool> observer)
		{
			return new All<TSource>._(this._predicate, observer);
		}

		protected override void Run(All<TSource>._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<TSource> _source;

		private readonly Func<TSource, bool> _predicate;

		internal sealed class _ : Sink<TSource, bool>
		{
			public _(Func<TSource, bool> predicate, IObserver<bool> observer)
				: base(observer)
			{
				this._predicate = predicate;
			}

			public override void OnNext(TSource value)
			{
				bool flag = false;
				try
				{
					flag = this._predicate(value);
				}
				catch (Exception ex)
				{
					base.ForwardOnError(ex);
					return;
				}
				if (!flag)
				{
					base.ForwardOnNext(false);
					base.ForwardOnCompleted();
				}
			}

			public override void OnCompleted()
			{
				base.ForwardOnNext(true);
				base.ForwardOnCompleted();
			}

			private readonly Func<TSource, bool> _predicate;
		}
	}
}
