﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class Aggregate<TSource> : Producer<TSource, Aggregate<TSource>._>
	{
		public Aggregate(IObservable<TSource> source, Func<TSource, TSource, TSource> accumulator)
		{
			this._source = source;
			this._accumulator = accumulator;
		}

		protected override Aggregate<TSource>._ CreateSink(IObserver<TSource> observer)
		{
			return new Aggregate<TSource>._(this._accumulator, observer);
		}

		protected override void Run(Aggregate<TSource>._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<TSource> _source;

		private readonly Func<TSource, TSource, TSource> _accumulator;

		internal sealed class _ : IdentitySink<TSource>
		{
			public _(Func<TSource, TSource, TSource> accumulator, IObserver<TSource> observer)
				: base(observer)
			{
				this._accumulator = accumulator;
			}

			public override void OnNext(TSource value)
			{
				if (!this._hasAccumulation)
				{
					this._accumulation = value;
					this._hasAccumulation = true;
					return;
				}
				try
				{
					this._accumulation = this._accumulator(this._accumulation, value);
				}
				catch (Exception ex)
				{
					this._accumulation = default(TSource);
					base.ForwardOnError(ex);
				}
			}

			public override void OnError(Exception error)
			{
				this._accumulation = default(TSource);
				base.ForwardOnError(error);
			}

			public override void OnCompleted()
			{
				if (!this._hasAccumulation)
				{
					base.ForwardOnError(new InvalidOperationException(Strings_Linq.NO_ELEMENTS));
					return;
				}
				TSource accumulation = this._accumulation;
				this._accumulation = default(TSource);
				base.ForwardOnNext(accumulation);
				base.ForwardOnCompleted();
			}

			private readonly Func<TSource, TSource, TSource> _accumulator;

			private TSource _accumulation;

			private bool _hasAccumulation;
		}
	}
}
