﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class Aggregate<TSource, T, TResult> : Producer<TResult, Aggregate<TSource, T, TResult>._>
	{
		public Aggregate(IObservable<TSource> source, T seed, Func<T, TSource, T> accumulator, Func<T, TResult> resultSelector)
		{
			this._source = source;
			this._seed = seed;
			this._accumulator = accumulator;
			this._resultSelector = resultSelector;
		}

		protected override Aggregate<TSource, T, TResult>._ CreateSink(IObserver<TResult> observer)
		{
			return new Aggregate<TSource, T, TResult>._(this, observer);
		}

		protected override void Run(Aggregate<TSource, T, TResult>._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<TSource> _source;

		private readonly T _seed;

		private readonly Func<T, TSource, T> _accumulator;

		private readonly Func<T, TResult> _resultSelector;

		internal sealed class _ : Sink<TSource, TResult>
		{
			public _(Aggregate<TSource, T, TResult> parent, IObserver<TResult> observer)
				: base(observer)
			{
				this._accumulator = parent._accumulator;
				this._resultSelector = parent._resultSelector;
				this._accumulation = parent._seed;
			}

			public override void OnNext(TSource value)
			{
				try
				{
					this._accumulation = this._accumulator(this._accumulation, value);
				}
				catch (Exception ex)
				{
					base.ForwardOnError(ex);
				}
			}

			public override void OnError(Exception error)
			{
				base.ForwardOnError(error);
			}

			public override void OnCompleted()
			{
				TResult tresult;
				try
				{
					tresult = this._resultSelector(this._accumulation);
				}
				catch (Exception ex)
				{
					base.ForwardOnError(ex);
					return;
				}
				base.ForwardOnNext(tresult);
				base.ForwardOnCompleted();
			}

			private readonly Func<T, TSource, T> _accumulator;

			private readonly Func<T, TResult> _resultSelector;

			private T _accumulation;
		}
	}
}
