﻿using System;

namespace System.Reactive.Linq.ObservableImpl
{
	internal sealed class Aggregate<TSource, T> : Producer<T, Aggregate<TSource, T>._>
	{
		public Aggregate(IObservable<TSource> source, T seed, Func<T, TSource, T> accumulator)
		{
			this._source = source;
			this._seed = seed;
			this._accumulator = accumulator;
		}

		protected override Aggregate<TSource, T>._ CreateSink(IObserver<T> observer)
		{
			return new Aggregate<TSource, T>._(this._seed, this._accumulator, observer);
		}

		protected override void Run(Aggregate<TSource, T>._ sink)
		{
			sink.Run(this._source);
		}

		private readonly IObservable<TSource> _source;

		private readonly T _seed;

		private readonly Func<T, TSource, T> _accumulator;

		internal sealed class _ : Sink<TSource, T>
		{
			public _(T seed, Func<T, TSource, T> accumulator, IObserver<T> observer)
				: base(observer)
			{
				this._accumulator = accumulator;
				this._accumulation = seed;
			}

			public override void OnNext(TSource value)
			{
				try
				{
					this._accumulation = this._accumulator(this._accumulation, value);
				}
				catch (Exception ex)
				{
					this._accumulation = default(T);
					base.ForwardOnError(ex);
				}
			}

			public override void OnError(Exception error)
			{
				this._accumulation = default(T);
				base.ForwardOnError(error);
			}

			public override void OnCompleted()
			{
				T accumulation = this._accumulation;
				this._accumulation = default(T);
				base.ForwardOnNext(accumulation);
				base.ForwardOnCompleted();
			}

			private readonly Func<T, TSource, T> _accumulator;

			private T _accumulation;
		}
	}
}
