﻿using System;
using System.ComponentModel;

namespace System.Reactive.Linq
{
	[AttributeUsage(AttributeTargets.Class, Inherited = false)]
	[EditorBrowsable(EditorBrowsableState.Never)]
	public sealed class LocalQueryMethodImplementationTypeAttribute : Attribute
	{
		public LocalQueryMethodImplementationTypeAttribute(Type targetType)
		{
			this._targetType = targetType;
		}

		public Type TargetType
		{
			get
			{
				return this._targetType;
			}
		}

		private readonly Type _targetType;
	}
}
