﻿using System;
using System.Reactive.Disposables;
using System.Reactive.Subjects;

namespace System.Reactive.Linq
{
	internal sealed class GroupedObservable<TKey, TElement> : ObservableBase<TElement>, GInterface4<TKey, TElement>, IObservable<TElement>
	{
		public GroupedObservable(TKey key, ISubject<TElement> subject, RefCountDisposable refCount)
		{
			this.Key = key;
			this._subject = subject;
			this._refCount = refCount;
		}

		public GroupedObservable(TKey key, ISubject<TElement> subject)
		{
			this.Key = key;
			this._subject = subject;
		}

		public TKey Key { get; }

		protected override IDisposable SubscribeCore(IObserver<TElement> observer)
		{
			if (this._refCount != null)
			{
				IDisposable disposable = this._refCount.GetDisposable();
				IDisposable disposable2 = this._subject.Subscribe(observer);
				return StableCompositeDisposable.Create(disposable, disposable2);
			}
			return this._subject.Subscribe(observer);
		}

		private readonly IObservable<TElement> _subject;

		private readonly RefCountDisposable _refCount;
	}
}
