﻿using System;
using System.Collections.Generic;

namespace System.Reactive.Joins
{
	public abstract class Plan<TResult>
	{
		internal Plan()
		{
		}

		internal abstract ActivePlan Activate(Dictionary<object, IJoinObserver> externalSubscriptions, IObserver<TResult> observer, Action<ActivePlan> deactivate);

		internal static JoinObserver<TSource> CreateObserver<TSource>(Dictionary<object, IJoinObserver> externalSubscriptions, IObservable<TSource> observable, Action<Exception> onError)
		{
			IJoinObserver joinObserver;
			JoinObserver<TSource> joinObserver2;
			if (!externalSubscriptions.TryGetValue(observable, out joinObserver))
			{
				joinObserver2 = new JoinObserver<TSource>(observable, onError);
				externalSubscriptions.Add(observable, joinObserver2);
			}
			else
			{
				joinObserver2 = (JoinObserver<TSource>)joinObserver;
			}
			return joinObserver2;
		}
	}
}
