﻿using System;
using System.Collections.Generic;

namespace System.Reactive.Joins
{
	internal class Plan<T1, T2, TResult> : Plan<TResult>
	{
		internal Pattern<T1, T2> Expression { get; }

		internal Func<T1, T2, TResult> Selector { get; }

		internal Plan(Pattern<T1, T2> expression, Func<T1, T2, TResult> selector)
		{
			this.Expression = expression;
			this.Selector = selector;
		}

		internal override ActivePlan Activate(Dictionary<object, IJoinObserver> externalSubscriptions, IObserver<TResult> observer, Action<ActivePlan> deactivate)
		{
			Action<Exception> action = new Action<Exception>(observer.OnError);
			JoinObserver<T1> firstJoinObserver = Plan<TResult>.CreateObserver<T1>(externalSubscriptions, this.Expression.First, action);
			JoinObserver<T2> secondJoinObserver = Plan<TResult>.CreateObserver<T2>(externalSubscriptions, this.Expression.Second, action);
			ActivePlan<T1, T2> activePlan = null;
			activePlan = new ActivePlan<T1, T2>(firstJoinObserver, secondJoinObserver, delegate(T1 first, T2 second)
			{
				TResult tresult;
				try
				{
					tresult = this.Selector(first, second);
				}
				catch (Exception ex)
				{
					observer.OnError(ex);
					return;
				}
				observer.OnNext(tresult);
			}, delegate
			{
				firstJoinObserver.RemoveActivePlan(activePlan);
				secondJoinObserver.RemoveActivePlan(activePlan);
				deactivate(activePlan);
			});
			firstJoinObserver.AddActivePlan(activePlan);
			secondJoinObserver.AddActivePlan(activePlan);
			return activePlan;
		}
	}
}
