﻿using System;

namespace System.Reactive.Joins
{
	public class Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8> : Pattern
	{
		internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second, IObservable<TSource3> third, IObservable<TSource4> fourth, IObservable<TSource5> fifth, IObservable<TSource6> sixth, IObservable<TSource7> seventh, IObservable<TSource8> eighth)
		{
			this.First = first;
			this.Second = second;
			this.Third = third;
			this.Fourth = fourth;
			this.Fifth = fifth;
			this.Sixth = sixth;
			this.Seventh = seventh;
			this.Eighth = eighth;
		}

		internal IObservable<TSource1> First { get; }

		internal IObservable<TSource2> Second { get; }

		internal IObservable<TSource3> Third { get; }

		internal IObservable<TSource4> Fourth { get; }

		internal IObservable<TSource5> Fifth { get; }

		internal IObservable<TSource6> Sixth { get; }

		internal IObservable<TSource7> Seventh { get; }

		internal IObservable<TSource8> Eighth { get; }

		public Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9> And<TSource9>(IObservable<TSource9> other)
		{
			if (other == null)
			{
				throw new ArgumentNullException("other");
			}
			return new Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9>(this.First, this.Second, this.Third, this.Fourth, this.Fifth, this.Sixth, this.Seventh, this.Eighth, other);
		}

		public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TResult> selector)
		{
			if (selector == null)
			{
				throw new ArgumentNullException("selector");
			}
			return new Plan<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TResult>(this, selector);
		}
	}
}
