﻿using System;

namespace System.Reactive.Joins
{
	public class Pattern<TSource1, TSource2, TSource3, TSource4, TSource5> : Pattern
	{
		internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second, IObservable<TSource3> third, IObservable<TSource4> fourth, IObservable<TSource5> fifth)
		{
			this.First = first;
			this.Second = second;
			this.Third = third;
			this.Fourth = fourth;
			this.Fifth = fifth;
		}

		internal IObservable<TSource1> First { get; }

		internal IObservable<TSource2> Second { get; }

		internal IObservable<TSource3> Third { get; }

		internal IObservable<TSource4> Fourth { get; }

		internal IObservable<TSource5> Fifth { get; }

		public Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6> And<TSource6>(IObservable<TSource6> other)
		{
			if (other == null)
			{
				throw new ArgumentNullException("other");
			}
			return new Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6>(this.First, this.Second, this.Third, this.Fourth, this.Fifth, other);
		}

		public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TSource3, TSource4, TSource5, TResult> selector)
		{
			if (selector == null)
			{
				throw new ArgumentNullException("selector");
			}
			return new Plan<TSource1, TSource2, TSource3, TSource4, TSource5, TResult>(this, selector);
		}
	}
}
